rm(list=ls())
library(Bolstad) 
library(AER) 
library(mvtnorm) 
source("TSIV_functions.R")

n1=1000
n2=200
S=5000
p=1
eta=rep(0,p)
nu=rep(0,p)
beta =seq(-0.45,0.45,0.05)

pdf("C:/Users/JAERIM/Dropbox/TS2SLS_Jaerim/Data/simulations/graphs/size_hetero2.pdf",width=7,height=5)
K=c(5,10)
CONC=c(1,4,16)
par(mfrow=c(length(K),length(CONC)),mai=c(0.55,0.55,0.25,0.1))
num=0

ptm <- proc.time()
for (k in K){
for (conc in CONC){
	print(c(k,conc))
	lambda = conc*k   
	Pi=rep(sqrt(lambda / (n2*k)),k)
	size3=rep(NA,length(beta))
	size4=rep(NA,length(beta))
	size5=rep(NA,length(beta))
	size6=rep(NA,length(beta))
	size7=rep(NA,length(beta))  
	size8=rep(NA,length(beta))     
	
for (b in 1:length(beta)){  
set.seed(1234)  
ARstat=rep(NA,S)
Kstat=rep(NA,S)
CLRstat=rep(NA,S)
CLRpvalue=rep(NA,S)
ARstat2=rep(NA,S)
Kstat2=rep(NA,S)
CLRstat2=rep(NA,S)
CLRpvalue2=rep(NA,S)

for (s in 1:S){
	z1=rmvnorm(n1,sigma=diag(k))
	z2=rmvnorm(n2,sigma=diag(k))
	if (p==1){
	x1<-matrix(1,nrow=n1,ncol=p)
    x2<-matrix(1,nrow=n2,ncol=p)
    }
    else{
    x1<-cbind(rep(1,n1),rnorm(n1))
    x2<-cbind(rep(1,n2),rnorm(n2))		
    }
    	v1=rnorm(n1)
	v2=rnorm(n2)
	w1=t(t(z1))%*%Pi+x1%*%eta+v1
	w2=t(t(z2))%*%Pi+x2%*%eta+v2
	e=rnorm(n1)*(t(t(z1))%*%Pi+x1%*%eta)
	e=e/sd(e)
	u1=v1*0.1+e*sqrt(0.99)
	y1=beta[b]*w1+x1%*%nu+u1

## specify the null hypothesis	
beta0=beta[b]
    
## Two-sample 2SLS 
	Pihat<-lm(w2~z2+x2-1)$coefficients
	v2sigmasq<-sum((residuals(lm(w2~z2+x2-1)))^2)/(n2-k-p)
	w1hat<-cbind(z1,x1)%*%Pihat
	betahat<-lm(y1~w1hat+x1-1)$coefficients[1]  
	e1sigmasq<-sum((residuals(lm(y1~w1hat+x1-1)))^2)/(n1-1-p)
	vbetahat_null=(summary(lm(y1~w1hat+x1-1))$coefficients[1,2])^2*(1+n1/n2*beta0^2*(v2sigmasq)/(e1sigmasq))
	vbetahat=(summary(lm(y1~w1hat+x1-1))$coefficients[1,2])^2*(1+n1/n2*betahat^2*(v2sigmasq)/(e1sigmasq))

## benchmark two-sample AR, LM, and CLR test
    results=TStest(y1,w1hat,w2,z1,z2,x1,x2,beta0)
    ARstat[s]=results$ARstat
    Kstat[s]=results$Kstat 
    CLRstat[s]=results$CLRstat  
    CLRpvalue[s]=results$CLRpvalue
    
## heteroskedasticity-robust two-sample AR, LM, and CLR test
    results=TStest_hetero(y1,w1hat,w2,z1,z2,x1,x2,beta0)
    ARstat2[s]=results$ARstat
    Kstat2[s]=results$Kstat 
    CLRstat2[s]=results$CLRstat  
    CLRpvalue2[s]=results$CLRpvalue
        
}
size3[b]<-mean(ARstat>qchisq((1-0.05),k))
size4[b]<-mean(Kstat>qchisq((1-0.05),1))
size5[b]<-mean(CLRpvalue<0.05)
size6[b]<-mean(ARstat2>qchisq((1-0.05),k))
size7[b]<-mean(Kstat2>qchisq((1-0.05),1))
size8[b]<-mean(CLRpvalue2<0.05)
}
num=num+1
plot(beta,size3,type="l",ylim=c(0,0.5),xlab=expression(beta), ylab="prop. of rej.",lty=3, main=paste(num,")  k=",k,", lambda/k=",conc,sep=""),cex.main=1)
lines(beta,size4,lty=4)
lines(beta,size5,lty=5)
lines(beta,size6,lty=6)
lines(beta,size7,lty=7)
lines(beta,size8,lty=8)
	if (num==1) {
legend("topleft", legend=c("Benchmark TSAR","Benchmark TSK","Benchmark TSCLR","Robust TSAR","Robust TSK","Robust TSCLR"),lty=c(3,4,5,6,7,8),cex=0.75)
     }
save(size3,size4,size5,size6,size7,size8,file=paste("C:/Users/JAERIM/Dropbox/TS2SLS_Jaerim/Data/simulations/mktable/size_hetero2_",k,conc,".RData",sep=""))
print(proc.time() - ptm)
}
}
dev.off()


