rm(list=ls())
library(Bolstad) 
library(AER) 
library(mvtnorm) 
source("TSIV_functions.R")

n1=5000
n2=1000
S=5000
p=1
eta=rep(0,p)
nu=rep(0,p)
k=2
CONC=c(0.5,1)

for (beta0 in c(0,2)){
beta = seq(-21,21,1)+beta0
for (conc in CONC){
	print(c(beta0,conc))
	lambda = conc*k   
	Pi=rep(sqrt(lambda / (n2*k)),k)
	size=rep(NA,length(beta))
	size2=rep(NA,length(beta))
	size3=rep(NA,length(beta))
	size4=rep(NA,length(beta))
	size5=rep(NA,length(beta))
   
for (b in 1:length(beta)){  
set.seed(1234)  
t1=rep(NA,S)
t2=rep(NA,S)
ARstat=rep(NA,S)
Kstat=rep(NA,S)
CLRstat=rep(NA,S)
CLRpvalue=rep(NA,S)
betahat=rep(NA,S)
vbetahat=rep(NA,S)
vbetahat_null=rep(NA,S)
for (s in 1:S){
	z1=rmvnorm(n1,sigma=diag(k))
	z2=rmvnorm(n2,sigma=diag(k))
	if (p==1){
	x1<-matrix(1,nrow=n1,ncol=p)
    x2<-matrix(1,nrow=n2,ncol=p)
    }
    else{
    x1<-cbind(rep(1,n1),rnorm(n1))
    x2<-cbind(rep(1,n2),rnorm(n2))		
    }
	v1=rnorm(n1)
	v2=rnorm(n2)
	w1=t(t(z1))%*%Pi+x1%*%eta+v1
	w2=t(t(z2))%*%Pi+x2%*%eta+v2
	e=rnorm(n1)
	u1=v1*0.1+e*sqrt(0.99)
	y1=beta[b]*w1+x1%*%nu+u1
    
## The two sample 2SLS method
	Pihat<-lm(w2~z2+x2-1)$coefficients
	v2sigmasq<-sum((residuals(lm(w2~z2+x2-1)))^2)/(n2-k-p)
	w1hat<-cbind(z1,x1)%*%Pihat
	betahat[s]<-lm(y1~w1hat+x1-1)$coefficients[1]  
	e1sigmasq<-sum((residuals(lm(y1~w1hat+x1-1)))^2)/(n1-1-p)
	vbetahat_null[s]=(summary(lm(y1~w1hat+x1-1))$coefficients[1,2])^2*(1+n1/n2*beta0^2*(v2sigmasq)/(e1sigmasq))
	vbetahat[s]=(summary(lm(y1~w1hat+x1-1))$coefficients[1,2])^2*(1+n1/n2*betahat[s]^2*(v2sigmasq)/(e1sigmasq))

## proposed two-sample AR and CLR test
    results=TStest(y1,w1hat,w2,z1,z2,x1,x2,beta0)
    ARstat[s]=results$ARstat
    Kstat[s]=results$Kstat
    CLRstat[s]=results$CLRstat

## obtaining p-value for the CLR test    
    CLRpvalue[s]=results$CLRpvalue
}
size3[b]<-mean(ARstat>qchisq((1-0.05),k))
size4[b]<-mean(Kstat>qchisq((1-0.05),1))
size5[b]<-mean(CLRpvalue<0.05)
}
save(size3,size4,size5,file=paste("C:/Users/JAERIM/Dropbox/TS2SLS_Jaerim/Data/simulations/mktable/power_weak_",beta0,conc,".RData",sep=""))
}
}

pdf("C:/Users/JAERIM/Dropbox/TS2SLS_Jaerim/Data/simulations/graphs/power_weak.pdf",width=5,height=3)
par(mfrow=c(1,2),mai=c(0.55,0.55,0.25,0.1))
num=0
for (beta0 in c(0,2)){
num=num+1
beta = seq(-21,21,1)+beta0
load(paste("C:/Users/JAERIM/Dropbox/TS2SLS_Jaerim/Data/simulations/mktable/power_weak_",beta0,"0.5.RData",sep=""))

plot(beta,beta*0+1,type="l",ylim=c(0.8,1.1),xlab=expression(beta), ylab="ration between power functions of two-sample AR and CLR",lty=1, main=paste(num,")  H0: beta=",beta0,sep=""),cex.main=1)
ratio=size3/size5
lines(beta,ratio,lty=2)
load(paste("C:/Users/JAERIM/Dropbox/TS2SLS_Jaerim/Data/simulations/mktable/power_weak_",beta0,"1.RData",sep=""))
ratio=size3/size5
lines(beta,ratio,lty=3)
legend("bottomleft", legend=c("lambda/k=0.5","lambda/k=1"),lty=c(2,3),cex=0.75)
}	
dev.off()


