rm(list=ls())
library(Bolstad) 
library(AER) 
library(mvtnorm) 
source("TSIV_functions.R")

n1=1000
n2=200
S=5000
p=1
eta=rep(0,p)
nu=rep(0,p)
beta0=0
beta = seq(-0.45,0.45,0.05)+beta0

pdf("C:/Users/JAERIM/Dropbox/TS2SLS_Jaerim/Data/simulations/graphs/power1.pdf",width=7,height=5)
K=c(5,10)
CONC=c(1,4,16)
par(mfrow=c(length(K),length(CONC)),mai=c(0.55,0.55,0.25,0.1))
num=0
for (k in K){
for (conc in CONC){
	print(c(k,conc))
	lambda = conc*k   
	Pi=rep(sqrt(lambda / (n2*k)),k)
	size=rep(NA,length(beta))
	size2=rep(NA,length(beta))
	size3=rep(NA,length(beta))
	size4=rep(NA,length(beta))
	size5=rep(NA,length(beta))
   
for (b in 1:length(beta)){  
set.seed(1234)  
t1=rep(NA,S)
t2=rep(NA,S)
ARstat=rep(NA,S)
Kstat=rep(NA,S)
CLRstat=rep(NA,S)
CLRpvalue=rep(NA,S)
betahat=rep(NA,S)
vbetahat=rep(NA,S)
vbetahat_null=rep(NA,S)
for (s in 1:S){
	z1=rmvnorm(n1,sigma=diag(k))
	z2=rmvnorm(n2,sigma=diag(k))
	if (p==1){
	x1<-matrix(1,nrow=n1,ncol=p)
    x2<-matrix(1,nrow=n2,ncol=p)
    }
    else{
    x1<-cbind(rep(1,n1),rnorm(n1))
    x2<-cbind(rep(1,n2),rnorm(n2))		
    }
	v1=rnorm(n1)
	v2=rnorm(n2)
	w1=t(t(z1))%*%Pi+x1%*%eta+v1
	w2=t(t(z2))%*%Pi+x2%*%eta+v2
	e=rnorm(n1)
	u1=v1*0.1+e*sqrt(0.99)
	y1=beta[b]*w1+x1%*%nu+u1
    
## The two sample 2SLS method
	Pihat<-lm(w2~z2+x2-1)$coefficients
	v2sigmasq<-sum((residuals(lm(w2~z2+x2-1)))^2)/(n2-k-p)
	w1hat<-cbind(z1,x1)%*%Pihat
	betahat[s]<-lm(y1~w1hat+x1-1)$coefficients[1]  
	e1sigmasq<-sum((residuals(lm(y1~w1hat+x1-1)))^2)/(n1-1-p)
	vbetahat_null[s]=(summary(lm(y1~w1hat+x1-1))$coefficients[1,2])^2*(1+n1/n2*beta0^2*(v2sigmasq)/(e1sigmasq))
	vbetahat[s]=(summary(lm(y1~w1hat+x1-1))$coefficients[1,2])^2*(1+n1/n2*betahat[s]^2*(v2sigmasq)/(e1sigmasq))

## standard t-test
	t1[s]=abs(betahat[s]-beta0)/sqrt(vbetahat[s])	

## null-imposed t-test
	t2[s]=abs(betahat[s]-beta0)/sqrt(vbetahat_null[s])

## proposed two-sample AR and CLR test
    results=TStest(y1,w1hat,w2,z1,z2,x1,x2,beta0)
    ARstat[s]=results$ARstat
    Kstat[s]=results$Kstat
    CLRstat[s]=results$CLRstat

## obtaining p-value for the CLR test    
    CLRpvalue[s]=results$CLRpvalue
}
size[b]<-mean(t1>qt((1-0.05/2),n1-k-p))
size2[b]<-mean(t2>qt((1-0.05/2),n1-k-p))
size3[b]<-mean(ARstat>qchisq((1-0.05),k))
size4[b]<-mean(Kstat>qchisq((1-0.05),1))
size5[b]<-mean(CLRpvalue<0.05)
}
num=num+1
plot(beta,size2,type="l",ylim=c(0,1),xlab=expression(beta), ylab="prop. of rej.",lty=1, main=paste(num,")  k=",k,", lambda/k=",conc,sep=""),cex.main=1)
lines(beta,size3,lty=3)
lines(beta,size4,lty=4)
lines(beta,size5,lty=5)
	if (num==1) {
legend("topleft", legend=c("TS2SLS-H0","TSAR","TSK","TSCLR"),lty=c(1,3,4,5),cex=0.75)
     }
save(size,size2,size3,size4,size5,file=paste("C:/Users/JAERIM/Dropbox/TS2SLS_Jaerim/Data/simulations/mktable/power1_",k,conc,".RData",sep=""))
}
}
dev.off()


