clear all
set more off

*** Specify your working directory ***
global main_dir "C:\Users\JAERIM\Dropbox\TS2SLS_Jaerim\Data\public\"
cd ${main_dir}

global hdvar1="hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp"
global hdvar2="hded0911 hded1212 hded1315 hded16p pct* boys"


*** Panel A ***
drop _all
use pctprj pctvch pctrehab pctlihtc part_pub extra $hdvar1 in_cps rent rooms dense msa anycps rhhinc boys frelu18 kids using ${main_dir}raw_data\reg2.dta if ((kids==2 & in_cps==0) | (frelu18==2 & in_cps==1)) & anycps==1
ds

reg part_pub extra hdage hdage2 hdfemale hdblack hdother hdhisp pct* boys if in_cps==1
test extra == 0
qui predict projhat

drop if pctprj ==.
rename part_pub w2
rename extra z2
outsheet w2 z2 hdage hdage2 hdfemale hdblack hdother hdhisp pct* boys using A1_second.csv if in_cps==1, comma replace
outsheet w2 z2 hdage hdage2 hdfemale hdblack hdother hdhisp pct* boys using A2_second.csv if in_cps==1, comma replace


*** Panel A_1***

reg rooms projhat hdage hdage2 hdfemale hdblack hdother hdhisp pct* boys if in_cps==0
predict roomshat
matrix B1=get(_b)
matrix V1=get(VCE)
qui reg roomshat projhat hdage hdage2 hdfemale hdblack hdother hdhisp pct* boys if in_cps==1
matrix V2=get(VCE)
matrix V3=V1+V2
matrix post B1 V3, dep(rooms)
matrix mlout

rename rooms y1
rename projhat w1hat
rename z2 z1
outsheet y1 w1hat z1 hdage hdage2 hdfemale hdblack hdother hdhisp pct* boys using A1_first.csv if in_cps==0, comma replace
rename y1 rooms
rename w1hat projhat


*** Panel A_2***
reg dense projhat hdage hdage2 hdfemale hdblack hdother hdhisp pct* boys if in_cps==0
predict densehat
matrix B1=get(_b)
matrix V1=get(VCE)
qui reg densehat projhat hdage hdage2 hdfemale hdblack hdother hdhisp pct* boys if in_cps==1
matrix V2=get(VCE)
matrix V3=V1+V2
matrix post B1 V3, dep(dense)
matrix mlout


rename dense y1
rename projhat w1hat
outsheet y1 w1hat z1 hdage hdage2 hdfemale hdblack hdother hdhisp pct* boys using A2_first.csv if in_cps==0, comma replace



drop _all
use pctprj pctvch pctrehab pctlihtc kidage part_pub extra kdfemale $hdvar1 in_cps hhid heldback hhid2 msa anycps rhhinc boys frelu18 kids using ${main_dir}raw_data\reg1.dta if ((kids==2 & in_cps==0) | (frelu18==2 & in_cps==1)) & anycps==1
ds
qui xi i.kidage
reg part_pub extra _I* kdfemale hdage hdage2 hdfemale hdblack hdother hdhisp pct* boys if in_cps==1
test extra == 0

testparm _I*
predict projhat

drop if pctprj ==.
rename part_pub w2
rename extra z2
outsheet w2 z2 _I* kdfemale hdage hdage2 hdfemale hdblack hdother hdhisp pct* boys using A3_second.csv if in_cps==1, comma replace


*** Panel A_3***
reg heldback projhat _I* kdfemale hdage hdage2 hdfemale hdblack hdother hdhisp pct* boys if in_cps==0
testparm _I*
predict heldhat
matrix B1=get(_b)
matrix V1=get(VCE)
qui reg heldhat projhat _I* kdfemale hdage hdage2 hdfemale hdblack hdother hdhisp pct* boys if in_cps==1
matrix V2=get(VCE)
matrix V3=V1+V2
matrix post B1 V3, dep(heldback)
matrix mlout 

rename heldback y1
rename projhat w1hat
rename z2 z1
outsheet y1 w1hat z1 _I* kdfemale hdage hdage2 hdfemale hdblack hdother hdhisp pct* boys using A3_first.csv if in_cps==0, comma replace


*** Panel B ***

drop _all
use pctprj pctvch pctrehab pctlihtc part_pub extra $hdvar1 hded0911 hded1212 hded1315 hded16p in_cps rent rooms dense rhhinc msa anycps rhhinc boys frelu18 kids using ${main_dir}raw_data\reg2.dta if ((kids==2 & in_cps==0) | (frelu18==2 & in_cps==1)) & anycps==1
ds
replace rhhinc=0 if rhhinc<0
replace rhhinc=rhhinc/1000
gen rhhinc2=rhhinc*rhhinc
reg part_pub extra $hdvar1 $hdvar2 rhhinc* if in_cps==1
test extra == 0

qui predict projhat

drop if pctprj ==.
rename part_pub w2
rename extra z2
outsheet w2 z2 $hdvar1 $hdvar2 rhhinc* using B1_second.csv if in_cps==1, comma replace
outsheet w2 z2 $hdvar1 $hdvar2 rhhinc* using B2_second.csv if in_cps==1, comma replace

*** Panel B_1***
reg rooms projhat $hdvar1 $hdvar2 rhhinc* if in_cps==0
predict roomshat
matrix B1=get(_b)
matrix V1=get(VCE)
qui reg roomshat projhat $hdvar1 $hdvar2 rhhinc* if in_cps==1
matrix V2=get(VCE)
matrix V3=V1+V2
matrix post B1 V3, dep(rooms)
matrix mlout

rename rooms y1
rename projhat w1hat
rename z2 z1
outsheet y1 w1hat z1 $hdvar1 $hdvar2 rhhinc* using B1_first.csv if in_cps==0, comma replace
rename y1 rooms
rename w1hat projhat

*** Panel B_2***
reg dense projhat $hdvar1 $hdvar2 rhhinc* if in_cps==0
predict densehat
matrix B1=get(_b)
matrix V1=get(VCE)
qui reg densehat projhat $hdvar1 $hdvar2 rhhinc* if in_cps==1
matrix V2=get(VCE)
matrix V3=V1+V2
matrix post B1 V3, dep(dense)
matrix mlout


rename dense y1
rename projhat w1hat
outsheet y1 w1hat z1 $hdvar1 $hdvar2 rhhinc* using B2_first.csv if in_cps==0, comma replace

drop _all
use pctprj pctvch pctrehab pctlihtc kidage part_pub extra kdfemale $hdvar1 hded0911 hded1212 hded1315 hded16p in_cps hhid heldback hhid2 renter rhhinc msa anycps rhhinc boys frelu18 kids using ${main_dir}raw_data\reg1.dta if ((kids==2 & in_cps==0) | (frelu18==2 & in_cps==1)) & anycps==1
ds
replace rhhinc=0 if rhhinc<0
replace rhhinc=rhhinc/1000
gen rhhinc2=rhhinc*rhhinc
qui xi i.kidage
reg part_pub extra _I* kdfemale $hdvar1 $hdvar2 rhhinc* if in_cps==1
test extra == 0

testparm _I*
predict projhat


drop if pctprj ==.
rename part_pub w2
rename extra z2
outsheet w2 z2 _I* kdfemale $hdvar1 $hdvar2 rhhinc* using B3_second.csv if in_cps==1, comma replace

*** Panel B_3***
reg heldback projhat _I* kdfemale $hdvar1 $hdvar2 rhhinc* if in_cps==0

testparm _I*
predict heldhat
matrix B1=get(_b)
matrix V1=get(VCE)
qui reg heldhat projhat _I* kdfemale $hdvar1 $hdvar2 rhhinc* if in_cps==1
matrix V2=get(VCE)
matrix V3=V1+V2
matrix post B1 V3, dep(heldback)
matrix mlout 

rename heldback y1
rename projhat w1hat
rename z2 z1
outsheet y1 w1hat z1 _I* kdfemale $hdvar1 $hdvar2 rhhinc* using B3_first.csv if in_cps==0, comma replace



clear all
global hdvar1="hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp"
global hdvar2="hded0911 hded1212 hded1315 hded16p pct* boys"

*** Panel C ***

drop _all
use pctprj pctvch pctrehab pctlihtc part_pub extra $hdvar1 hded0911 hded1212 hded1315 hded16p in_cps rooms dense msa anycps rhhinc boys frelu18 kids using ${main_dir}raw_data\reg2.dta if hded1315+hded16p==0 & ((kids==2 & in_cps==0) | (frelu18==2 & in_cps==1)) & anycps==1
ds
reg part_pub extra hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp hded0911 hded1212 pct* boys if in_cps==1
test extra == 0

qui predict projhat



drop if pctprj ==.
rename part_pub w2
rename extra z2
outsheet w2 z2 hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp hded0911 hded1212 pct* boys using C1_second.csv if in_cps==1, comma replace
outsheet w2 z2 hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp hded0911 hded1212 pct* boys using C2_second.csv if in_cps==1, comma replace



*** Panel C_1***
reg rooms projhat hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp hded0911 hded1212 pct* boys if in_cps==0
predict roomshat
matrix B1=get(_b)
matrix V1=get(VCE)
qui reg roomshat projhat hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp hded0911 hded1212 pct* boys if in_cps==1
matrix V2=get(VCE)
matrix V3=V1+V2
matrix post B1 V3, dep(rooms)
matrix mlout




rename rooms y1
rename projhat w1hat
rename z2 z1
outsheet y1 w1hat z1 hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp hded0911 hded1212 pct* boys using C1_first.csv if in_cps==0, comma replace
rename y1 rooms
rename w1hat projhat



*** Panel C_2***
reg dense projhat hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp hded0911 hded1212 pct* boys if in_cps==0
predict densehat
matrix B1=get(_b)
matrix V1=get(VCE)
qui reg densehat projhat hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp hded0911 hded1212 pct* boys if in_cps==1
matrix V2=get(VCE)
matrix V3=V1+V2
matrix post B1 V3, dep(dense)
matrix mlout



rename dense y1
rename projhat w1hat
outsheet y1 w1hat z1 hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp hded0911 hded1212 pct* boys using C2_first.csv if in_cps==0, comma replace




drop _all
use pctprj pctvch pctrehab pctlihtc kidage part_pub extra kdfemale $hdvar1 hded0911 hded1212 hded1315 hded16p in_cps hhid heldback hhid2 msa anycps rhhinc boys frelu18 kids using ${main_dir}raw_data\reg1.dta if hded1315+hded16p==0 & ((kids==2 & in_cps==0) | (frelu18==2 & in_cps==1)) & anycps==1
ds
qui xi i.kidage
reg part_pub extra _I* kdfemale hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp hded0911 hded1212 pct* boys if in_cps==1
test extra == 0

qui testparm _I*
predict projhat

drop if pctprj ==.
rename part_pub w2
rename extra z2
outsheet w2 z2 _I* kdfemale hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp hded0911 hded1212 pct* boys using C3_second.csv if in_cps==1, comma replace


*** Panel C_3***
reg heldback projhat _I* kdfemale hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp hded0911 hded1212 pct* boys if in_cps==0
testparm _I*
predict heldhat
matrix B1=get(_b)
matrix V1=get(VCE)
qui reg heldhat projhat _I* kdfemale hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp hded0911 hded1212 pct* boys if in_cps==1
matrix V2=get(VCE)
matrix V3=V1+V2
matrix post B1 V3, dep(heldback)
matrix mlout

rename heldback y1
rename projhat w1hat
rename z2 z1
outsheet y1 w1hat z1 _I* kdfemale hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp hded0911 hded1212 pct* boys using C3_first.csv if in_cps==0, comma replace





clear all


*** Panel D ***
drop _all
use pctprj pctvch pctrehab pctlihtc part_pub extra $hdvar1 hded1315 hded16p in_cps rooms dense msa anycps rhhinc boys frelu18 kids using ${main_dir}raw_data\reg2.dta if hded1315+hded16p==1 & ((kids==2 & in_cps==0) | (frelu18==2 & in_cps==1)) & anycps==1
ds
reg part_pub extra hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp hded1315 pct* boys if in_cps==1
test extra == 0

qui predict projhat

drop if pctprj ==.
rename part_pub w2
rename extra z2
outsheet w2 z2 hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp hded1315 pct* boys using D1_second.csv if in_cps==1, comma replace
outsheet w2 z2 hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp hded1315 pct* boys using D2_second.csv if in_cps==1, comma replace



*** Panel D_1***
reg rooms projhat hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp hded1315 pct* boys if in_cps==0
predict roomshat
matrix B1=get(_b)
matrix V1=get(VCE)
qui reg roomshat projhat hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp hded1315 pct* boys if in_cps==1
matrix V2=get(VCE)
matrix V3=V1+V2
matrix post B1 V3, dep(rooms)
matrix mlout



rename rooms y1
rename projhat w1hat
rename z2 z1
outsheet y1 w1hat z1 hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp hded1315 pct* boys using D1_first.csv if in_cps==0, comma replace
rename y1 rooms
rename w1hat projhat



*** Panel D_2***
reg dense projhat hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp hded1315 pct* boys if in_cps==0
predict densehat
matrix B1=get(_b)
matrix V1=get(VCE)
qui reg densehat projhat hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp hded1315 pct* boys if in_cps==1
matrix V2=get(VCE)
matrix V3=V1+V2
matrix post B1 V3, dep(dense)
matrix mlout




rename dense y1
rename projhat w1hat
outsheet y1 w1hat z1 hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp hded1315 pct* boys using D2_first.csv if in_cps==0, comma replace






drop _all
use pctprj pctvch pctrehab pctlihtc kidage part_pub extra kdfemale $hdvar1 hded1315 hded16p in_cps hhid heldback hhid2 msa anycps rhhinc boys frelu18 kids using ${main_dir}raw_data\reg1.dta if hded1315+hded16p==1 & ((kids==2 & in_cps==0) | (frelu18==2 & in_cps==1)) & anycps==1
ds
qui xi i.kidage
reg part_pub extra _I* kdfemale hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp hded1315 pct* boys if in_cps==1
test extra == 0

qui testparm _I*
predict projhat

drop if pctprj ==.
rename part_pub w2
rename extra z2
outsheet w2 z2 _I* kdfemale hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp hded1315 pct* boys using D3_second.csv if in_cps==1, comma replace


*** Panel D_3***

reg heldback projhat _I* kdfemale hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp hded1315 pct* boys if in_cps==0
testparm _I*
predict heldhat
matrix B1=get(_b)
matrix V1=get(VCE)
qui reg heldhat projhat _I* kdfemale hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp hded1315 pct* boys if in_cps==1
matrix V2=get(VCE)
matrix V3=V1+V2
matrix post B1 V3, dep(heldback)
matrix mlout

rename heldback y1
rename projhat w1hat
rename z2 z1
outsheet y1 w1hat z1 _I* kdfemale hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp hded1315 pct* boys using D3_first.csv if in_cps==0, comma replace



clear all
drop _all




* **********************
* Low income sample
* Specification check
global hdvar1="hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp"
global hdvar2="hded0911 hded1212 hded1315 hded16p pct* boys"


*** Panel E ***

use boys pctprj pctvch pctrehab pctlihtc part_pub extra $hdvar1 hded0911 hded1212 hded1315 hded16p in_cps rent rooms dense msa anycps rhhinc boys frelu18 kids using ${main_dir}raw_data\reg2.dta if rhhinc<=25000 & ((kids==2 & in_cps==0) | (frelu18==2 & in_cps==1)) & anycps==1
ds
reg part_pub extra $hdvar1 $hdvar2 if in_cps==1
test extra == 0

qui predict projhat

drop if pctprj ==.
rename part_pub w2
rename extra z2
outsheet w2 z2 $hdvar1 $hdvar2 using E1_second.csv if in_cps==1, comma replace
outsheet w2 z2 $hdvar1 $hdvar2 using E2_second.csv if in_cps==1, comma replace


*** Panel E_1***
reg rooms projhat $hdvar1 $hdvar2 if in_cps==0
predict roomshat
matrix B1=get(_b)
matrix V1=get(VCE)
qui reg roomshat projhat $hdvar1 $hdvar2 if in_cps==1
matrix V2=get(VCE)
matrix V3=V1+V2
matrix post B1 V3, dep(rooms)
matrix mlout

rename rooms y1
rename projhat w1hat
rename z2 z1
outsheet y1 w1hat z1 $hdvar1 $hdvar2 using E1_first.csv if in_cps==0, comma replace
rename y1 rooms
rename w1hat projhat


*** Panel E_2***
reg dense projhat $hdvar1 $hdvar2 if in_cps==0
predict densehat
matrix B1=get(_b)
matrix V1=get(VCE)
qui reg densehat projhat $hdvar1 $hdvar2 if in_cps==1
matrix V2=get(VCE)
matrix V3=V1+V2
matrix post B1 V3, dep(dense)
matrix mlout




rename dense y1
rename projhat w1hat
outsheet y1 w1hat z1 $hdvar1 $hdvar2 using E2_first.csv if in_cps==0, comma replace



drop _all
use boys pctprj pctvch pctrehab pctlihtc kidage part_pub extra kdfemale $hdvar1 hded0911 hded1212 hded1315 hded16p in_cps hhid heldback hhid2 renter msa anycps rhhinc boys frelu18 kids using ${main_dir}raw_data\reg1.dta if rhhinc<=25000 & ((kids==2 & in_cps==0) | (frelu18==2 & in_cps==1)) & anycps==1
ds
qui xi i.kidage
reg part_pub extra _I* kdfemale $hdvar1 $hdvar2 if in_cps==1
test extra == 0

qui testparm _I*
predict projhat

drop if pctprj ==.
rename part_pub w2
rename extra z2
outsheet w2 z2 _I* kdfemale $hdvar1 $hdvar2 using E3_second.csv if in_cps==1, comma replace



*** Panel E_3***
reg heldback projhat _I* kdfemale $hdvar1 $hdvar2 if in_cps==0
testparm _I*
predict heldhat
matrix B1=get(_b)
matrix V1=get(VCE)
qui reg heldhat projhat _I* kdfemale $hdvar1 $hdvar2 if in_cps==1
matrix V2=get(VCE)
matrix V3=V1+V2
matrix post B1 V3, dep(heldback)
matrix mlout

rename heldback y1
rename projhat w1hat
rename z2 z1
outsheet y1 w1hat z1 _I* kdfemale $hdvar1 $hdvar2 using E3_first.csv if in_cps==0, comma replace










clear all
drop _all

global hdvar1="hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp"
global hdvar2="hded0911 hded1212 hded1315 hded16p pct* boys"


*** Panel F ***

drop _all
use boys pctprj pctvch pctrehab pctlihtc part_pub extra $hdvar1 hded0911 hded1212 hded1315 hded16p in_cps rent rooms dense msa anycps rhhinc boys frelu18 kids using ${main_dir}raw_data\reg2.dta if rhhinc>25000 & ((kids==2 & in_cps==0) | (frelu18==2 & in_cps==1)) & anycps==1
ds
reg part_pub extra $hdvar1 $hdvar2 if in_cps==1
test extra == 0

qui predict projhat

drop if pctprj ==.
rename part_pub w2
rename extra z2
outsheet w2 z2 $hdvar1 $hdvar2 using F1_second.csv if in_cps==1, comma replace
outsheet w2 z2 $hdvar1 $hdvar2 using F2_second.csv if in_cps==1, comma replace


*** Panel F_1***
reg rooms projhat $hdvar1 $hdvar2 if in_cps==0
predict roomshat
matrix B1=get(_b)
matrix V1=get(VCE)
qui reg roomshat projhat $hdvar1 $hdvar2 if in_cps==1
matrix V2=get(VCE)
matrix V3=V1+V2
matrix post B1 V3, dep(rooms)
matrix mlout

rename rooms y1
rename projhat w1hat
rename z2 z1
outsheet y1 w1hat z1 $hdvar1 $hdvar2 using F1_first.csv if in_cps==0, comma replace
rename y1 rooms
rename w1hat projhat


*** Panel F_2***
reg dense projhat $hdvar1 $hdvar2 if in_cps==0
predict densehat
matrix B1=get(_b)
matrix V1=get(VCE)
qui reg densehat projhat $hdvar1 $hdvar2 if in_cps==1
matrix V2=get(VCE)
matrix V3=V1+V2
matrix post B1 V3, dep(dense)
matrix mlout



rename dense y1
rename projhat w1hat
outsheet y1 w1hat z1 $hdvar1 $hdvar2 using F2_first.csv if in_cps==0, comma replace



drop _all
use boys pctprj pctvch pctrehab pctlihtc kidage part_pub extra kdfemale $hdvar1 hded0911 hded1212 hded1315 hded16p in_cps hhid heldback hhid2 renter msa anycps rhhinc boys frelu18 kids using ${main_dir}raw_data\reg1.dta if rhhinc>25000 & ((kids==2 & in_cps==0) | (frelu18==2 & in_cps==1)) & anycps==1
ds
qui xi i.kidage
reg part_pub extra _I* kdfemale $hdvar1 $hdvar2 if in_cps==1
test extra == 0

qui testparm _I*
predict projhat

drop if pctprj ==.
rename part_pub w2
rename extra z2
outsheet w2 z2 _I* kdfemale $hdvar1 $hdvar2 using F3_second.csv if in_cps==1, comma replace


*** Panel F_3***
reg heldback projhat _I* kdfemale $hdvar1 $hdvar2 if in_cps==0
testparm _I*
predict heldhat
matrix B1=get(_b)
matrix V1=get(VCE)
qui reg heldhat projhat _I* kdfemale $hdvar1 $hdvar2 if in_cps==1
matrix V2=get(VCE)
matrix V3=V1+V2
matrix post B1 V3, dep(heldback)
matrix mlout

rename heldback y1
rename projhat w1hat
rename z2 z1
outsheet y1 w1hat z1 _I* kdfemale $hdvar1 $hdvar2 using F3_first.csv if in_cps==0, comma replace

clear all
global hdvar1="hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp"
global hdvar2="hded0911 hded1212 hded1315 hded16p pct* boys"


*** Panel G ***

drop _all
use pctprj pctvch pctrehab pctlihtc part_pub extra $hdvar1 hded0911 hded1212 hded1315 hded16p in_cps rent rooms dense msa anycps rhhinc boys kids using ${main_dir}raw_data\reg2.dta if kids>=2 & kids<=6 & anycps==1
ds
xi i.kids
reg part_pub extra _I* $hdvar1 $hdvar2 if in_cps==1
test extra == 0

qui predict projhat

drop if pctprj ==.
rename part_pub w2
rename extra z2
outsheet w2 z2 _I* $hdvar1 $hdvar2 using G1_second.csv if in_cps==1, comma replace
outsheet w2 z2 _I* $hdvar1 $hdvar2 using G2_second.csv if in_cps==1, comma replace


*** Panel G_1***
reg rooms projhat _I* $hdvar1 $hdvar2 if in_cps==0
predict roomshat
matrix B1=get(_b)
matrix V1=get(VCE)
qui reg roomshat projhat _I* $hdvar1 $hdvar2 if in_cps==1
matrix V2=get(VCE)
matrix V3=V1+V2
matrix post B1 V3, dep(rooms)
matrix mlout

rename rooms y1
rename projhat w1hat
rename z2 z1
outsheet y1 w1hat z1 _I* $hdvar1 $hdvar2 using G1_first.csv if in_cps==0, comma replace
rename y1 rooms
rename w1hat projhat


*** Panel G_2***
reg dense projhat _I* $hdvar1 $hdvar2 if in_cps==0
predict densehat
matrix B1=get(_b)
matrix V1=get(VCE)
qui reg densehat projhat _I* $hdvar1 $hdvar2 if in_cps==1
matrix V2=get(VCE)
matrix V3=V1+V2
matrix post B1 V3, dep(dense)
matrix mlout

rename dense y1
rename projhat w1hat
outsheet y1 w1hat z1 _I* $hdvar1 $hdvar2 using G2_first.csv if in_cps==0, comma replace



drop _all
use pctprj pctvch pctrehab pctlihtc kidage part_pub extra kdfemale $hdvar1 hded0911 hded1212 hded1315 hded16p in_cps hhid heldback hhid2 renter msa anycps rhhinc boys kids using ${main_dir}raw_data\reg1.dta if kids>=2 & kids<=6 & anycps==1
ds
qui xi i.kidage i.kids
reg part_pub extra _I* kdfemale $hdvar1 $hdvar2 if in_cps==1
test extra == 0

qui testparm _I*
predict projhat

drop if pctprj ==.
rename part_pub w2
rename extra z2
outsheet w2 z2 _I* kdfemale $hdvar1 $hdvar2 using G3_second.csv if in_cps==1, comma replace



*** Panel G_3***
reg heldback projhat _I* kdfemale $hdvar1 $hdvar2 if in_cps==0
testparm _I*
predict heldhat
matrix B1=get(_b)
matrix V1=get(VCE)
qui reg heldhat projhat _I* kdfemale $hdvar1 $hdvar2 if in_cps==1
matrix V2=get(VCE)
matrix V3=V1+V2
matrix post B1 V3, dep(heldback)
matrix mlout

rename heldback y1
rename projhat w1hat
rename z2 z1
outsheet y1 w1hat z1 _I* kdfemale $hdvar1 $hdvar2 using G3_first.csv if in_cps==0, comma replace


