clear all
set more off

*** Specify your working directory ***
global main_dir "C:\Users\JAERIM\Dropbox\TS2SLS_Jaerim\Data\public\"
cd ${main_dir}

global hdvar1="hdage hdage2 hdmarr hdfemale hdblack hdother hdhisp"
global hdvar2="hded0911 hded1212 hded1315 hded16p pct* boys"

* Table 3 - Column 1 *
drop _all
use pctprj pctvch pctrehab pctlihtc part_pub extra $hdvar1 hded0911 hded1212 hded1315 hded16p in_cps rent rooms dense renter msa anycps rhhinc boys frelu18 kids using ${main_dir}raw_data\reg2.dta if renter==1 & ((kids==2 & in_cps==0) | (frelu18==2 & in_cps==1)) & anycps==1
drop if rent==. & in_cps==0
replace rent=rent/1000

drop if pctprj ==.
*** 1st stage ***
reg part_pub extra $hdvar1 $hdvar2 if in_cps==1
predict projhat
test extra == 0
local n2=e(N)
local sigma_eta = (e(rmse))^2

rename part_pub w2
rename extra z2
outsheet w2 z2 $hdvar1 $hdvar2 using t3_c1_second.csv if in_cps==1, comma replace

*** 2nd stage ***
reg rent projhat $hdvar1 $hdvar2 if in_cps==0
matrix coef=e(b)
matrix vcv=e(V)
local beta_hat=coef[1,1]
local se_raw=sqrt(vcv[1,1])
local n1=e(N)
local sigma11=(e(rmse))^2
scalar se_adj = `se_raw'*sqrt((`sigma11' + (`n1'/`n2')*(`beta_hat')^2*`sigma_eta')/`sigma11')
display se_adj	

rename rent y1
rename projhat w1hat
rename z2 z1

outsheet y1 w1hat z1 $hdvar1 $hdvar2 using t3_c1_first.csv if in_cps==0, comma replace

* Table 3 - Column 2 *
drop _all
use pctprj pctvch pctrehab pctlihtc part_pub extra $hdvar1 hded0911 hded1212 hded1315 hded16p in_cps rent rooms dense msa anycps rhhinc boys frelu18 kids using ${main_dir}raw_data\reg2.dta if ((kids==2 & in_cps==0) | (frelu18==2 & in_cps==1)) & anycps==1

drop if pctprj ==.
*** 1st stage ***
reg part_pub extra $hdvar1 $hdvar2 if in_cps==1
predict projhat
test extra == 0
local n2=e(N)
display `n2'
local sigma_eta = (e(rmse))^2
display `sigma_eta'

rename part_pub w2
rename extra z2
outsheet w2 z2 $hdvar1 $hdvar2 using t3_c2_second.csv if in_cps==1, comma replace
outsheet w2 z2 $hdvar1 $hdvar2 using t3_c3_second.csv if in_cps==1, comma replace

*** 2nd stage ***
reg rooms projhat $hdvar1 $hdvar2 if in_cps==0
matrix coef=e(b)
matrix vcv=e(V)
local beta_hat=coef[1,1]
local se_raw=sqrt(vcv[1,1])
display `se_raw'
local n1=e(N)
display `n1'
local sigma11=(e(rmse))^2
display `sigma11'

scalar se_adj = `se_raw'*sqrt((`sigma11' + (`n1'/`n2')*(`beta_hat')^2*`sigma_eta')/`sigma11')
display se_adj

rename rooms y1
rename projhat w1hat
rename z2 z1

outsheet y1 w1hat z1 $hdvar1 $hdvar2 using t3_c2_first.csv if in_cps==0, comma replace

rename w1hat projhat

* Table 3 - Column 3 *

*** 2nd stage ***
reg dense projhat $hdvar1 $hdvar2 if in_cps==0
matrix coef=e(b)
matrix vcv=e(V)
local beta_hat=coef[1,1]
local se_raw=sqrt(vcv[1,1])
local n1=e(N)
local sigma11=(e(rmse))^2
scalar se_adj = `se_raw'*sqrt((`sigma11' + (`n1'/`n2')*(`beta_hat')^2*`sigma_eta')/`sigma11')
display se_adj

rename y1 rooms
rename dense y1
rename projhat w1hat
outsheet y1 w1hat z1 $hdvar1 $hdvar2 using t3_c3_first.csv if in_cps==0, comma replace


* Table 3 - Column 4 *
drop _all
use pctprj pctvch pctrehab pctlihtc kidage part_pub extra kdfemale $hdvar1 hded0911 hded1212 hded1315 hded16p in_cps hhid heldback hhid2 renter msa anycps rhhinc boys frelu18 kids using ${main_dir}raw_data\reg1.dta if ((kids==2 & in_cps==0) | (frelu18==2 & in_cps==1)) & anycps==1
qui xi i.kidage

drop if pctprj ==.

*** 1st stage ***
reg part_pub extra _I* kdfemale $hdvar1 $hdvar2 if in_cps==1, cluster(hhid)
test extra == 0
qui testparm _I*
predict projhat
local n2=e(N)
local sigma_eta = (e(rmse))^2

rename part_pub w2
rename extra z2
outsheet w2 z2 _I* kdfemale $hdvar1 $hdvar2 using t3_c4_second.csv if in_cps==1, comma replace

*** 2nd stage ***
reg heldback projhat _I* kdfemale $hdvar1 $hdvar2 if in_cps==0, cluster(hhid2)
matrix coef=e(b)
matrix vcv=e(V)
local beta_hat=coef[1,1]
local se_raw=sqrt(vcv[1,1])
local n1=e(N)
local sigma11=(e(rmse))^2
scalar se_adj = `se_raw'*sqrt((`sigma11' + (`n1'/`n2')*(`beta_hat')^2*`sigma_eta')/`sigma11')
display se_adj

rename heldback y1
rename projhat w1hat
rename z2 z1

outsheet y1 w1hat z1 _I* kdfemale $hdvar1 $hdvar2 using t3_c4_first.csv if in_cps==0, comma replace
