  rm(list=ls())
  setwd("C:/Users/JAERIM/Dropbox/TS2SLS_Jaerim/Data/public")
  library(ggplot2)
  library(Bolstad)
  library(AER)
  library(mvtnorm)
  #library(MASS)
  
  source("C:/Users/JAERIM/Dropbox/TS2SLS_Jaerim/Data/TSIV_functions.R")
  
  df1 <- read.table("t3_c1_first.csv",header = TRUE, sep = ",") 
  df2 <- read.table("t3_c1_second.csv",header = TRUE, sep = ",") 
  
  # Set parameters
  alpha = 0.05
  eps=10^-8
  
  # Define Variables
  y1 <- df1$y1
  w1hat <- df1$w1hat
  z1 <- matrix(df1$z1)
  x1 <- data.matrix(data.frame(df1)[,c(4:ncol(df1))])
  x1_con <- matrix(1,nrow=length(w1hat),ncol=1)
  x1_combine <- cbind(x1,x1_con)
  
  
  w2 <- df2$w2
  z2 <- matrix(df2$z2)
  x2 <- data.matrix(data.frame(df2)[,c(3:ncol(df2))])
  x2_con <- matrix(1,nrow=length(w2),ncol=1)
  x2_combine <- cbind(x2,x2_con)
  
  ## Testing Equality of Moments
  Z1=cbind(z1,x1_combine)
  Z2=cbind(z2,x2_combine)	
  
  pvalue <- matrix(NA,nrow=ncol(Z1),ncol=ncol(Z1))
  
  for (h in 1:ncol(Z1)){
  for (g in 1:ncol(Z1)){
    pvalue[h,g] <- t.test(t(Z1[,h])*Z1[,g], t(Z2[,h])*Z2[,g])$p.value
  }
  }
  
  
  library(foreign)
  mydata <- data.frame(pvalue)
  write.dta(mydata, "C:/Users/JAERIM/Dropbox/TS2SLS_Jaerim/Data/public/pvalue.dta")
  
  ## 95% Confidence Set - AR method
  results<-TSci(y1,w1hat,w2,z1,z2,x1_combine,x2_combine,alpha)
  type_AR=results$type_AR
  set_AR=results$set_AR
  
  ## 95% Confidence Set - CLR method
  #type_CLR=results$type_CLR
  #set_CLR=results$set_CLR 
  
  
  ## 95% Inoue and Solon (2010)
  betahat<-lm(y1~w1hat+x1)$coefficients[2]
  e1sigmasq<-sum((residuals(lm(y1~w1hat+x1)))^2)/(lm(y1~w1hat+x1)$df)
  v2sigmasq<-sum((residuals(lm(w2~z2+x2)))^2)/(lm(w2~z2+x2)$df)
  n1=length(y1)
  n2=length(w2)
  k=ncol(z1)
  vbetahat=(summary(lm(y1~w1hat+x1))$coefficients[2,2])^2*(1+n1/n2*betahat^2*(v2sigmasq)/(e1sigmasq))
  se_Inoue_Solon = sqrt(vbetahat)
  ci_Inoue_Solon <- c(betahat-qt(0.975,n1-k-1)*sqrt(vbetahat), betahat+qt(0.975,n1-k-1)*sqrt(vbetahat))
  
  
  
  
  
  
  
  ## Create grid [0,1]
  points <- 1001
  gridmin <- 0
  gridmax <- 1
  gridinterval = (gridmax - gridmin)/(points-1)
  grid <- seq(gridmin, gridmax, gridinterval)
  
  ## 95% Confidence Set - CLR method (Hetero)
  ARstat=rep(NA,points)
  AR_r=rep(NA,points)
  
  AR_rbegin=0
  AR_rbegin_null=0
  AR_rend=0
  AR_rend_null=0
  
  AR_cset = rep("",1)
  
  
  
  results=TStest_hetero(y1,w1hat,w2,z1,z2,x1,x2,grid)
  ARstat=results$ARstat
  
  ## Create rejection indicators
  AR_r<-ARstat>qchisq((1-0.05),k)
  print(results$AR_r)
  
  for (g in 1:length(grid)){
    
    ## Proposed two-sample CLR test
    
    ## Create rejection indicators
    
    ## AR CI
    if (AR_r[g]==0){
      if (AR_rbegin==0){
        AR_rbegin = g
        AR_rbegin_null=grid[g]
      }
      AR_rend=g
      AR_rend_null=grid[g]
    }
    if (AR_r[g]==1 | (AR_r[g]==0 & g==points)){
     if (AR_rbegin>0 & AR_rend>0 & AR_rbegin==AR_rend){
        rnull = format(AR_rbegin_null,digits=2,nsmall=2)
        if (nchar(AR_cset)==0){
          AR_cset <- toString(rnull) 
        }     
        else{
          AR_cset <- paste(AR_cset,"U",toString(rnull))}
        AR_rbegin=0
        AR_rend=0
      
      }
      else if (AR_rbegin>0 & AR_rend>0 & AR_rbegin<AR_rend){
        rnull1 = format(AR_rbegin_null,digits=2,nsmall=2)
        rnull2 = format(AR_rend_null,digits=2,nsmall=2)
        if (nchar(AR_cset)==0){
          AR_cset <- paste("[",toString(rnull1),",",toString(rnull2),"]") 
        }       
        else{                                                           
          AR_cset <- paste(AR_cset,"U","[",toString(rnull1),",",toString(rnull2),"]")}
        AR_rbegin=0
        AR_rend=0
      
        
      }
    }
   }
  
   if (nchar(AR_cset)==0){
    AR_cset <- "null set"
   } 
set_AR
ci_Inoue_Solon
AR_cset
n1
n2