clear all
set more off
set matsize 10000

*** Specify your working directory ***
global main_dir "C:\Users\JAERIM\Dropbox\TS2SLS_Jaerim\Data\intergeneration\"
cd ${main_dir}

* (In Table 2) Col 1 - married

use ${main_dir}raw_data\individual\1870_daughters.dta, clear
keep if sex==2 & age>=20 & age<=35

merge m:1 first using ${main_dir}raw_data\fathers_collapsed\names_m_50_base.dta, keep(master match) nogen

rename logoccscore_50_father logoccscore_50_father_base

keep if logoccscore_70_husb!=. & logoccscore_50_father_base!=. & age_70_husb>=20 & age_70_husb<=35 

encode first, generate(first_dummy)
quietly tabulate first_dummy, gen(z1_)
rename logoccscore_70_husb y1
rename logoccscore_50_father_base w1hat

outsheet y1 w1hat z1_* using t3_c1_sons_married_first.csv, comma replace



preserve
					keep if w1hat !=.
					keep first
					duplicates drop
					merge 1:m first using ${main_dir}raw_data\individual\1850_fathers.dta, keepusing(sex age relate bpl* statefip occ_50_father logoccscore_50_father logoccwage_PHall_50_father reg_brth*) keep(master match) nogen
					keep if sex==1 & relate==3
					keep if logoccscore_50_father !=.
					sort first
					encode first, generate(first_dummy)
                    quietly tabulate first_dummy, gen(z2_)
					rename logoccscore_50_father w2
					outsheet w2 z2_* using t3_c1_sons_married_second.csv, comma replace

					areg w2, absorb(first)
					local n2_jaerim=e(N)
					local sigma_eta_jaerim = (e(rmse))^2
restore



clear all
cd ${main_dir}

* (In Table 2) Col 2 - married

use ${main_dir}raw_data\individual\1880_sons.dta, clear
keep if sex==1 & age>=20 & age<=35

merge m:1 first using ${main_dir}raw_data\fathers_collapsed\names_m_60_base.dta, keep(master match) nogen

rename logoccscore_60_father logoccscore_60_father_base

keep if logoccscore_80_son!=. & logoccscore_60_father_base!=. & married_80_son==1

encode first, generate(first_dummy)
quietly tabulate first_dummy, gen(z1_)
rename logoccscore_80_son y1
rename logoccscore_60_father_base w1hat

outsheet y1 w1hat z1_* using t3_c2_sons_married_first.csv, comma replace



preserve
					keep if w1hat !=.
					keep first
					duplicates drop
					merge 1:m first using ${main_dir}raw_data\individual\1860_fathers.dta, keepusing(sex age relate bpl* statefip occ_60_father logoccscore_60_father logoccwage_PHall_60_father reg_brth*) keep(master match) nogen
					keep if sex==1 & relate==3
					keep if logoccscore_60_father !=.
					sort first
					encode first, generate(first_dummy)
                    quietly tabulate first_dummy, gen(z2_)
					rename logoccscore_60_father w2
					outsheet w2 z2_* using t3_c2_sons_married_second.csv, comma replace

					areg w2, absorb(first)
					local n2_jaerim=e(N)
					local sigma_eta_jaerim = (e(rmse))^2
restore



clear all
cd ${main_dir}

* (In Table 2) Col 3 - married

use ${main_dir}raw_data\individual\1900_sons.dta, clear
keep if sex==1 & age>=20 & age<=35

merge m:1 first using ${main_dir}raw_data\fathers_collapsed\names_m_80_base.dta, keep(master match) nogen

rename logoccscore_80_father logoccscore_80_father_base

keep if logoccscore_00_son!=. & logoccscore_80_father_base!=. & married_00_son==1

encode first, generate(first_dummy)
quietly tabulate first_dummy, gen(z1_)
rename logoccscore_00_son y1
rename logoccscore_80_father_base w1hat

outsheet y1 w1hat z1_* using t3_c3_sons_married_first.csv, comma replace



preserve
					keep if w1hat !=.
					keep first
					duplicates drop
					merge 1:m first using ${main_dir}raw_data\individual\1880_fathers.dta, keepusing(sex age relate bpl* statefip occ_80_father logoccscore_80_father logoccwage_PHall_80_father reg_brth*) keep(master match) nogen
					keep if sex==1 & relate==3
					keep if logoccscore_80_father !=.
					sort first
					encode first, generate(first_dummy)
                    quietly tabulate first_dummy, gen(z2_)
					rename logoccscore_80_father w2
					outsheet w2 z2_* using t3_c3_sons_married_second.csv, comma replace

					areg w2, absorb(first)
					local n2_jaerim=e(N)
					local sigma_eta_jaerim = (e(rmse))^2
restore



clear all
cd ${main_dir}

* (In Table 2) Col 4 - married

use ${main_dir}raw_data\individual\1920_sons.dta, clear
keep if sex==1 & age>=20 & age<=35

merge m:1 first using ${main_dir}raw_data\fathers_collapsed\names_m_00_base.dta, keep(master match) nogen

rename logoccscore_00_father logoccscore_00_father_base

keep if logoccscore_20_son!=. & logoccscore_00_father_base!=. & married_20_son==1

encode first, generate(first_dummy)
quietly tabulate first_dummy, gen(z1_)
rename logoccscore_20_son y1
rename logoccscore_00_father_base w1hat

outsheet y1 w1hat z1_* using t3_c4_sons_married_first.csv, comma replace



preserve
					keep if w1hat !=.
					keep first
					duplicates drop
					merge 1:m first using ${main_dir}raw_data\individual\1900_fathers.dta, keepusing(sex age relate bpl* statefip occ_00_father logoccscore_00_father logoccwage_PHall_00_father reg_brth*) keep(master match) nogen
					keep if sex==1 & relate==3
					keep if logoccscore_00_father !=.
					sort first
					encode first, generate(first_dummy)
                    quietly tabulate first_dummy, gen(z2_)
					rename logoccscore_00_father w2
					outsheet w2 z2_* using t3_c4_sons_married_second.csv, comma replace

					areg w2, absorb(first)
					local n2_jaerim=e(N)
					local sigma_eta_jaerim = (e(rmse))^2
restore



clear all
cd ${main_dir}

* (In Table 2) Col 5 - married

use ${main_dir}raw_data\individual\1930_sons.dta, clear
keep if sex==1 & age>=20 & age<=35


merge m:1 first using ${main_dir}raw_data\fathers_collapsed\names_m_10_base.dta, keep(master match) nogen

rename logoccscore_10_father logoccscore_10_father_base

keep if logoccscore_30_son!=. & logoccscore_10_father_base!=. & married_30_son==1

encode first, generate(first_dummy)
quietly tabulate first_dummy, gen(z1_)
rename logoccscore_30_son y1
rename logoccscore_10_father_base w1hat

outsheet y1 w1hat z1_* using t3_c5_sons_married_first.csv, comma replace



preserve
					keep if w1hat !=.
					keep first
					duplicates drop
					merge 1:m first using ${main_dir}raw_data\individual\1910_fathers.dta, keepusing(sex age relate bpl* statefip occ_10_father logoccscore_10_father logoccwage_PHall_10_father reg_brth*) keep(master match) nogen
					keep if sex==1 & relate==3
					keep if logoccscore_10_father !=.
					sort first
					encode first, generate(first_dummy)
                    quietly tabulate first_dummy, gen(z2_)
					rename logoccscore_10_father w2
					outsheet w2 z2_* using t3_c5_sons_married_second.csv, comma replace

					areg w2, absorb(first)
					local n2_jaerim=e(N)
					local sigma_eta_jaerim = (e(rmse))^2
restore

