rm(list=ls())
setwd("C:/Users/JAERIM/Dropbox/TS2SLS_Jaerim/Data/intergeneration/")
library(Bolstad) 
library(AER) 
library(mvtnorm) 
source("TSIV_functions.R")


df1 <- read.table("t3_c1_sons_base_first.csv",header = TRUE, sep = ",") 
df2 <- read.table("t3_c1_sons_base_second.csv",header = TRUE, sep = ",") 

# Set parameters
alpha = 0.1
eps=10^-8

# Define Variables

y1 <- df1$y1-mean(df1$y1)
w1hat <- df1$w1hat-mean(df1$w1hat)
x1 <- NULL
w2 <- df2$w2-mean(df2$w2)
x2 <- NULL

z1 <- data.matrix(data.frame(df1)[,c(3:ncol(df1))])
z2 <- data.matrix(data.frame(df2)[,c(2:ncol(df2))])

# Testing Equal Moments #
x11 <- matrix(1,nrow=length(y1),ncol=1)
x22 <- matrix(1,nrow=length(w2),ncol=1)
z11 <- data.matrix(data.frame(df1)[,c(4:ncol(df1))])
z22 <- data.matrix(data.frame(df2)[,c(3:ncol(df2))])
results<-Test_Equal_Moment(x11,x22,z11,z22)
Qstat=results$Qstat
Qstat
qchisq(.95, df=ncol(z1)-1)


# 90% Confidence Set - CLR method
results<-TSci(y1,w1hat,w2,z1,z2,x1,x2,alpha)
type_CLR=results$type_CLR
set_CLR=results$set_CLR 

## 90% Inoue and Solon (2010)
betahat<-lm(y1~w1hat)$coefficients[2]
e1sigmasq<-sum((residuals(lm(y1~w1hat)))^2)/(lm(y1~w1hat)$df)
v2sigmasq<-sum((residuals(lm(w2~z2)))^2)/(lm(w2~z2)$df)
n1=length(y1)
n2=length(w2)
k = ncol(z1)
vbetahat=(summary(lm(y1~w1hat))$coefficients[2,2])^2*(1+n1/n2*betahat^2*(v2sigmasq)/(e1sigmasq))
se_Inoue_Solon = sqrt(vbetahat)
ci_Inoue_Solon <- c(betahat-qt(0.95,n1-k-1)*sqrt(vbetahat), betahat+qt(0.95,n1-k-1)*sqrt(vbetahat))




## Create grid [0,2]
points <- 201
gridmin <- 0
gridmax <- 2
gridinterval = (gridmax - gridmin)/(points-1)
grid <- seq(gridmin, gridmax, gridinterval)

## 90% Confidence Set - CLR method (HOMO_UNEQUAL)
CLRstat=rep(NA,points)
CLR_r=rep(NA,points)

CLR_rbegin=0
CLR_rbegin_null=0
CLR_rend=0
CLR_rend_null=0

CLR_cset = rep("",1)

results=TStest_homo_unequal(y1,w2,z1,z2,x1,x2,grid)
CLRstat=results$CLRstat 

## Create rejection indicators
CLRpvalue=results$CLRpvalue
CLR_r<-CLRpvalue<0.1
print(results$CLR_r)

for (g in 1:length(grid)){
  
  
  ## Proposed two-sample AR K CLR test
  
  
  ## Create rejection indicators
  
  
  
  ## Proposed two-sample CLR test
  
  ## Create rejection indicators
  
  ## CLR CI
  if (CLR_r[g]==0){
    if (CLR_rbegin==0){
      CLR_rbegin = g
      CLR_rbegin_null=grid[g]
    }
    CLR_rend=g
    CLR_rend_null=grid[g]
  }
  if (CLR_r[g]==1 | (CLR_r[g]==0 & g==points)){
    if (CLR_rbegin>0 & CLR_rend>0 & CLR_rbegin==CLR_rend){
      rnull = format(CLR_rbegin_null,digits=2,nsmall=2)
      if (nchar(CLR_cset)==0){
        CLR_cset <- toString(rnull) 
      }     
      else{
        CLR_cset <- paste(CLR_cset,"U",toString(rnull))}
      CLR_rbegin=0
      CLR_rend=0
      
    }
    else if (CLR_rbegin>0 & CLR_rend>0 & CLR_rbegin<CLR_rend){
      rnull1 = format(CLR_rbegin_null,digits=2,nsmall=2)
      rnull2 = format(CLR_rend_null,digits=2,nsmall=2)
      if (nchar(CLR_cset)==0){
        CLR_cset <- paste("[",toString(rnull1),",",toString(rnull2),"]") 
      }       
      else{                                                           
        CLR_cset <- paste(CLR_cset,"U","[",toString(rnull1),",",toString(rnull2),"]")}
      CLR_rbegin=0
      CLR_rend=0
      
      
    }
  }
}

if (nchar(CLR_cset)==0){
  CLR_cset <- "null set"
} 



set_CLR
CLR_cset
ci_Inoue_Solon
n1
n2
