clear all
set more off

import delimited C:\Users\JAERIM\Dropbox\TS2SLS_Jaerim\Data\intergeneration\Figure5.csv

label var year "Year"
replace year = year+20

gen lob20_sil = b20_sil - 1.645*se20_sil
gen upb20_sil = b20_sil + 1.645*se20_sil

twoway (connected b20_sil year if year>=1870 & year<=1930, yaxis(1) ytitle("Inter-Generational Elasticity") ylabel(0.2(0.2)1,nogrid axis(1)) ysc(range(0.25(0.05)0.75) axis(1)) msym(d) mlabel(b20_sil) mlabposition(12) mlabsize(3) lpattern(dash)) /*
*/     (connected F year if year>=1870 & year<=1930, yaxis(2) ytitle("First Stage F Statistic", axis(2)) ylabel(0(1)4,nogrid axis(2)) ysc(range(0(1)4)  axis(2)) mlabel(F) mlabposition(12) mlabsize(3)) /*
*/      ,legend(order(1 2 ) label(1 "TS2SLS Estimate") label(2 "First Stage F Statistic") ring(0) bplacement(nwest)) xsc(range(1865(10)1935)) xlabel(1870(10)1935) /*
*/     graphregion(color(white)) bgcolor(white)

graph export C:\Users\JAERIM\Dropbox\TS2SLS_Jaerim\Data\intergeneration\Figure5_1.pdf, as(pdf) replace

twoway (rarea clr_lower clr_upper year if year>=1870 & year<=1930, sort color(gs14) ) /*
*/     (rarea lob20_sil upb20_sil year if year>=1870 & year<=1930, sort color(gs14) ) /*
*/     (scatter clr_lower clr_upper year if year>=1870 & year<=1930, c(l l) msym(i i) msize(large) clcolor(gs1 gs1) lwidth(thin thin) lpattern(solid solid) ) /*
*/     (scatter lob20_sil upb20_sil year if year>=1870 & year<=1930, c(l l) msym(i i)  msize(large) clcolor(gs10 gs10) lwidth(thin thin) lpattern(longdash longdash) ) /*
*/     , legend(order(3 6) label(3 "Benchmark TSCLR CI") label(6 "TS2SLS CI") ring(0) bplacement(nwest)) xsc(range(1865(10)1935)) xlabel(1870(10)1935) ytitle("Inter-Generational Elasticity") ylabel(,nogrid) /*
*/     graphregion(color(white)) bgcolor(white)


graph export C:\Users\JAERIM\Dropbox\TS2SLS_Jaerim\Data\intergeneration\Figure5_2.pdf, as(pdf) replace

twoway (rarea clr_unequal_lower clr_unequal_upper year if year>=1870 & year<=1930, sort color(gs15) ) /*
*/     (rarea lob20_sil upb20_sil year if year>=1870 & year<=1930, sort color(gs14) ) /*
*/     (scatter clr_unequal_lower clr_unequal_upper year if year>=1870 & year<=1930, c(l l) msym(i i) msize(large) clcolor(gs1 gs1) lwidth(thin thin) lpattern(dash dash) ) /*
*/     (scatter lob20_sil upb20_sil year if year>=1870 & year<=1930, c(l l) msym(i i)  msize(large) clcolor(gs10 gs10) lwidth(thin thin) lpattern(longdash longdash) ) /*
*/     , legend(order(3 6) label(3 "TSCLR CI (Uneq. Mom.)") label(6 "TS2SLS CI") ring(0) bplacement(neast)) xsc(range(1865(10)1935)) xlabel(1870(10)1935) ytitle("Inter-Generational Elasticity") ylabel(,nogrid) /*
*/     graphregion(color(white)) bgcolor(white)


graph export C:\Users\JAERIM\Dropbox\TS2SLS_Jaerim\Data\intergeneration\Figure5_3.pdf, as(pdf) replace
