%% ABG replication -- Summary Statistics & SW Test
clear all

%% Load Data 1973Q1 to 2021Q3 - see ABGRep_Data.m for details

load ABGRep
g1 = g1GDP ;	
g4 = g4GDP ;	
fc = NFCI ;

%% Extended Sample 

disp('1973:1 - 2021:3') 
disp('***************')
disp(blanks(1))
g1_moments = [ mean(g1) std(g1) skewness(g1) kurtosis(g1) min(g1) max(g1) size(g1,1) ] ;
g4_moments = [ mean(g4) std(g4) skewness(g4) kurtosis(g4) min(g4) max(g4) size(g4,1) ] ;
fc_moments = [ mean(fc) std(fc) skewness(fc) kurtosis(fc) min(fc) max(fc) size(fc,1) ] ;  
disp('Variable                   Mean        Std Dev      Skewness       Kurtosis       Minimum        Maximum            N') 
disp(['1 quarter output growth: ' num2str(g1_moments) ]) 
disp(['4 quarter output growth: ' num2str(g4_moments) ]) 
disp(['   Financial conditions: ' num2str(fc_moments) ]) 

disp(blanks(1))

% Normality Test
[g1_rj, g1_pv, g1_sw ] = swtest(g1) ;
[g4_rj, g4_pv, g4_sw ] = swtest(g4) ;
[fc_rj, fc_pv, fc_sw ] = swtest(fc) ;
 
disp('Shapiro-Wilk Test')
disp(['1 quarter output growth: ' num2str([g1_sw]) ' (' num2str(g1_pv) ')'  ]) 
disp(['4 quarter output growth: ' num2str([g4_sw]) ' (' num2str(g4_pv) ')'  ]) 
disp(['   financial conditions: ' num2str([fc_sw]) ' (' num2str(fc_pv) ')'  ]) 
disp(blanks(1))

%% ABG sample remove observations after 2015Q4

num_ext = 23 ;                  % Data extended to 2021Q3, 23 observations past end of ABG sample
g1ABG = g1(1:end-num_ext) ;
g4ABG = g4(1:end-num_ext) ;
fcABG = fc(1:end-num_ext) ;

disp('1973:1 - 2015:4') 
disp('***************')
disp(blanks(1))
g1_moments = [ mean(g1ABG) std(g1ABG) skewness(g1ABG) kurtosis(g1ABG) min(g1ABG) max(g1ABG) size(g1ABG,1) ] ;
g4_moments = [ mean(g4ABG) std(g4ABG) skewness(g4ABG) kurtosis(g4ABG) min(g4ABG) max(g4ABG) size(g4ABG,1) ] ;
fc_moments = [ mean(fcABG) std(fcABG) skewness(fcABG) kurtosis(fcABG) min(fcABG) max(fcABG) size(fcABG,1) ] ;  
disp('Variable                   Mean        Std Dev      Skewness       Kurtosis       Minimum        Maximum            N') 
disp(['1 quarter output growth: ' num2str(g1_moments) ]) 
disp(['4 quarter output growth: ' num2str(g4_moments) ]) 
disp(['   Financial conditions: ' num2str(fc_moments) ]) 

disp(blanks(1))

% Normality Test
[g1_rj, g1_pv, g1_sw ] = swtest(g1ABG) ;
[g4_rj, g4_pv, g4_sw ] = swtest(g4ABG) ;
[fc_rj, fc_pv, fc_sw ] = swtest(fcABG) ;
 
disp('Shapiro-Wilk Test')
disp(['1 quarter output growth: ' num2str([g1_sw]) ' (' num2str(g1_pv) ')'  ]) 
disp(['4 quarter output growth: ' num2str([g4_sw]) ' (' num2str(g4_pv) ')'  ]) 
disp(['   financial conditions: ' num2str([fc_sw]) ' (' num2str(fc_pv) ')'  ]) 
disp(blanks(1))

