* qr3 [if]
*	require $y outcome	
*		$s is a binary variable, used to group the sample into subsamples (often to be schooling) 
*		$x are the other covariants (controls) 	
* Input: NLSYM NO weight
* Output: 	For overall sample, qr reports (1) quantiles .1 .25 .4 .5 .6 .75 .9; (2) Interquantile range 90-10 75-25 90-50 50-10 60-40	
*	 	For each defined group (by x1), qr reports (1) and (2)
* Only point estimates; No confidence interval. For confidence interval, DO BOOSTRAP
* Revised from Ivan Fernandez-Val's program (05/16/2004) 
* Reproduce Agrist, Chernozhukov, Fernandez-Val (2004), Table 2
* 3/26/2005: assume the same regression coeff for different selection groups (COMPARED WITH qte)

capture program drop qr3
program define qr3, rclass
	version 6.0
	syntax [varlist] [if] 
tempfile temp
preserve
tempvar touse
mark `touse'  `if' 

foreach tau of numlist 10 25 40 50 60 75 90  { 
	local q=`tau'/100
	qreg $y $s $x if `touse', quantile(`q') nolo
qui	predict aq`tau' if e(sample) & $s==1
qui	sum aq`tau' if e(sample) & $s==1
	scalar A`tau'=r(mean)

qui	predict bq`tau' if e(sample) & $s==0
qui	sum bq`tau' if e(sample) & $s==0
	scalar B`tau'=r(mean)
	}
return scalar QR9010_1 = A90-A10
return scalar QR7525_1 = A75-A25
return scalar QR6040_1 = A60-A40
return scalar QR9010_0 = B90-B10
return scalar QR7525_0 = B75-B25
return scalar QR6040_0 = B60-B40
return scalar riq6040=(A60-A40)/(B60-B40)
return scalar riq7525=(A75-A25)/(B75-B25)
return scalar riq9010=(A90-A10)/(B90-B10)

end
exit

* Documentation
*	qr3 depvar [varlist] [if exp]
