* REPRODUCE KLING 2001
******************************
* upload kling's (2001) ORIGINAL data set
clear
set mem 100m
cd /media/Data/Research/shak/EmpiricalApp/NLS/

log using "./chenkhan20121122.log", replace

use "./Kling(2001)/data66.dta", clear

******************************
*RETAIN cases for the analysis
keep if wage76!=. & grade76!=. & nlsflt==1

******************************
*DEFINITION
gen college=1 if grade76>12
replace college=0 if grade76==12

local exp exp76 expsq76
local age age76 agesq76
local y wage76
local s grade76 
local z col4
local x `exp' black  south76 smsa76 reg2-reg9 smsa66 momdad14 sinmom14 nodaded nomomed daded momed famed1-famed8
local w `age' black  south76 smsa76 reg2-reg9 smsa66 momdad14 sinmom14 nodaded nomomed daded momed famed1-famed8


******************************
* KLING'S TABLE1
* CARD OLS; col 1  
reg `y' `s' `x'	 /* 7 */	
reg `y' college `x' /* 17 */

* CARD IV; cols 2 & 3; 
* Endogenous variables: schooling, experience, experience squared; Excl instruments: college in cnty, age age^2
reg `y' `s' `x' (`z' `w') /* 13 (5) */
reg `y' college `x' (`z' `w')  /* 47 (29) */

reg `y' `s' `x' (`z' `w')  if age66<=19		/* 9 */
reg `y' college `x' (`z' `w')  if age66<=19 /* 29 (37)*/

* BENCHMARK: KLING IV; col 4; CONTROL for LINEAR EXPERIENCE (exp76) AGE (age76);
* Endogenous variables: schooling, experience; Excl. instruments: college in cnty, age
local x exp76 black  south76 smsa76 reg2-reg9 smsa66 momdad14 sinmom14 nodaded nomomed daded momed famed1-famed8
local w age76 black  south76 smsa76 reg2-reg9 smsa66 momdad14 sinmom14 nodaded nomomed daded momed famed1-famed8
reg `y' `s' `x' /* 7 (5) */ 
reg `y' `s' `x' (`z' `w') /* 13 (5) */ 

reg `y' college `w' /* 17 (2) */ 
reg `y' college `w' (`z' `x') /* 47 (29) */

*******************************
* REDUCE THE SET OF COVARIATES IN THE BENCHMARK
* REPLACE FAMED1-FAMED8 TO THE FOLLOWING 5 DUMMIES THAT GIVE IDENTICAL RESULTS TO THE BENCHMARK
gen pared1=famed1 
gen pared2=daded>12 & momed>=12
gen pared3=daded==12 & momed==12
gen pared4=daded<12 & momed>=12
gen pared5=daded>=12 & momed<12

local c black  south76 smsa76 reg2-reg9 smsa66 momdad14 sinmom14 nodaded nomomed daded momed pared1-pared5
local x exp76 `c'
local w age76 `c'
reg `y' `s' `x'  /* 7 */
reg `y' `s' `x' (`z' `x') /* 13 (5) */
reg `y' college `x' /* 16.8 */
reg `y' college `x' (`z' `w') /* 47 (30) */

***************************************************************
* FURTHER REDUCE THE NUMBER OF CONTROLS FOR PARENTAL EDUCATION
gen par1=famed1
gen par2=daded>12 | momed>12
gen par3=daded==12 & momed==12
gen par4=daded>9 | momed>9

local c  black  south76 smsa76 reg2-reg9 smsa66 momdad14 sinmom14 nodaded nomomed daded momed par1
local x exp76 `c'
local w age76 `c'
reg `y' `s' `x'  /* 7 */
reg `y' `s' `x' (`z' `x') /* 13 (5) */
reg `y' college `x' /* 17 */
reg `y' college `x' (`z' `w') /* 46 (29) */

**********************************************************************
* NEW BENCHMARK: DROP reg2-reg9 smsa66 momdad14 sinmom14 nodaded nomomed daded momed FROM KLING'S MODEL
local c black south76 smsa66 smsa76 par1
local x exp76 `c'
local w age76 `c'
reg `y' `s' `x'  /* 7 */
reg `y' `s' `x' (`z' `w') /* 12 (5) */
reg `y' college `x' /* 17 */
reg `y' college `x' (`z' `w') /* 43 (36) */

****************************************
* DATA THAT WILL BE USED FOR ANALYSIS
save c:\research\shak\data\chenkhan, replace

* generate gauss data file 
drop if college==.
sum `y' `s' `z' `x' age76
outfile `y' `s' `z' `x' age76 using "./chenkhan.asc", wide comma replace


****************************************
* CALL MACROS
qui do "C:\data\nlsym66\kling\sum1"	
qui do "C:\data\nlsym66\kling\bsnlsym"
* qui do "C:\data\nlsym66\kling\qr1"
qui do "C:\data\nlsym66\kling\qr3"
* qui do "C:\data\nlsym66\kling\qte"
* qui do "C:\data\nlsym66\kling\qr3a"

*****************************************
* ANALYSIS
use c:\research\shak\data\chenkhan, clear
local y wage76
local s college
local z col4
local c  black south76 smsa66 smsa76 par1
local x  exp76 `c'
local w  age76 `c'


****************************************
* TABLE 3: STATISTICS
sum `y' college grade76 `z' `x' `w' 
sum `y' grade76 `z' `x' `w' if `s'==1 | `s'==0
sum `y' grade76 `z' `x' `w' if `s'==1
sum `y' grade76 `z' `x' `w' if `s'==0

********************************************************
* TABLE 5: PARAMETRIC ESTIMATES OF DEGREE OF DISPERSION 
* OLS
reg `y' `s' `x', robust
predict u if e(sample), res
sum1 u 
drop u
return list 

* IV 
reg `y' `s' `x' (`z' `w'), robust /* 43 (36) */
predict u if e(sample), res
sum1 u
drop u
return list 

* Heckman MLE 
treatreg `y' `x', treat(`s'=`z' `w') robust first
predict xb1 if e(sample), yctrt
predict xb0 if e(sample), ycntrt
gen u=`y'-xb1 if `s'==1
replace u=`y'-xb0 if `s'==0
sum1 u
drop u xb1 xb0 
return list
scalar var1=r(var1)
scalar var0=r(var0)

predict gama if e(sample), xbtrt
gen lambda=normd(gama)/normprob(gama) if `s'==1
replace lambda=-normd(gama)/(1-normprob(gama)) if `s'==0
gen Delta=1-(e(rho)^2)*lambda*(lambda+gama)
sum Delta if `s'==1
scalar Delta1=r(mean)
sum Delta if `s'==0
scalar Delta0=r(mean)
scalar vol1=var1/Delta1
scalar vol0=var0/Delta0

scalar rvar=var1/var0
scalar rvol=vol1/vol0

display var1
display var0
display vol1
display vol0
display rvar 
display rvol
display sqrt(rvar)
display sqrt(vol1)
display sqrt(vol0)
display sqrt(rvol)
drop  gama lambda Delta

* QUANTILE REGRESSION
qr3 /* remark the return in qr3.do to show output */
return list

* QUANTILE TREATMENT EFFECTS
* qte
* return list 

*********************************************
* BOOTSTRAP
** 1. HECKMAN PROCEDURE
bsnlsym
return list
bootstrap "bsnlsym" r(rsdvol) r(rvol) r(rsdv) r(rvar), reps(2513) dots saving(temp) replace
use "C:\DATA\NLSY\Wage\temp.dta", clear 

*rsdvol
gsort _bs_1, gen(index)
list _bs_1 if index==126| index==2388
drop index

*rvol
gsort _bs_2, gen(index)
list _bs_2 if index==126| index==2388
drop index

*rsdv
gsort _bs_3, gen(index)
list _bs_3 if index==126| index==2388
drop index

*rvar
gsort _bs_4, gen(index)
list _bs_4 if index==126| index==2388
drop index

** 2. QUANTILE REGRESSION
use c:\research\shak\data\chenkhan, clear
* MODEL
local y wage76
local s college
local z col4pub
local x  age76 black  south76 smsa76 smsa66 par1 par2
qr3 /* remark the return in qr3.do to show output */
return list
bootstrap "qr3" r(riq9010) r(riq7525) r(riq6040), reps(2513) dots saving(qrdata) replace
	use C:\data\qrdata, clear
*riq9010
gsort _bs_1, gen(index)
list _bs_1 if index==126| index==2388
drop index

*riq7525
gsort _bs_2, gen(index)
list _bs_2 if index==126| index==2388
drop index

*riq6040
gsort _bs_3, gen(index)
list _bs_3 if index==126| index==2388
drop index

** 3. QUANTILE TREATMENT EFFECTS
use c:\research\shak\data\chenkhan, clear
/* MODEL
local y wage76
local s college
local z col4pub
local x  age76 black  south76 smsa76 smsa66 par1 par2
qte
return list 
bootstrap "qte" r(rq9010) r(rq7525) r(rq6040), reps(2513) dots saving(qtedata) replace
	use c:\data\qtedata.dta, clear
*/

log close
