% Shell code to invoke the simulation study
clc; clear; close all

N     = [160, 80, 40]; % The number of indivalues
T     = [160, 80, 40]; % The number of time periods
no_mc = 500;          % The number of replications
d_f   = 2;             % The number of factors

% no_cores = 2;
% if isempty(gcp('nocreate'))  % checking to see if matlab pool is already open
%     parpool(no_cores);
% elseif ~isempty(gcp('nocreate'))
%     delete(gcp('nocreate'));
%     parpool(no_cores);
% else
% end

rng('shuffle')

for i = 1:length(N)
    for j = 1:length(T)
        h = 0.5;    % Bandwidth
        J = floor(sqrt(min(N(i), T(j)))); % User chosen value, see Step 1 
                                          % of the estimation procedure
                                          
        RunSim(N(i), T(j), h, d_f, J, no_mc)
    end
end