function RunSim(N, T, h, d_f, J, no_mc)
% This function implements the simulation studies
%
% Inputs:
% N           The number of individuals
% T           The number of time periods
% h           The bandwidth
% d_f         The dimension of the factors
% J           A user pre-specified number for intitial guess on the total
%             number of factors
% no_mc       The number of iterations 

% no_cores = 2;
% if isempty(gcp('nocreate'))  % checking to see if matlab pool is already open
%     parpool(no_cores);
% elseif ~isempty(gcp('nocreate'))
%     delete(gcp('nocreate'));
%     parpool(no_cores);
% else
% end

% Selected points on [0,1]
delta  = 0:0.05:1;
L_D    = length(delta);

% Store the estimates of beta_0(.)
Bet1_all = zeros(no_mc, L_D);
Bet2_all = zeros(no_mc, L_D);
Bet3_all = zeros(no_mc, L_D);

% Store 1 if successfully identify the number of factors, 0 otherwise
ID1_rhat = ones(no_mc, 1);
ID2_rhat = ones(no_mc, 1);
ID3_rhat = ones(no_mc, 1);

% Store 1 if reject the constancy test, 0 otherwise
LNT = zeros(no_mc, 1);

for imc = 1:no_mc
    % -------------------------------------------------
    % Data generating process
    V = sqrt(0.5) * randn(N*T, 1);
    
    E = zeros(N*T, 1); % Errors
    CovE = zeros(N, N);
    for i = 1:N
        for j = 1:N
            CovE(i, j) = 0.2^abs(i-j);
        end
    end
    CovE = chol(CovE,'lower');
    for t = 1:T
        ind = t:T:(N*T);
        E(ind) = CovE * randn(N, 1);
    end
    
    G = 2*randn(N, d_f); % Factor loadings
    for i = 1:N
        ind = (i-1)*T + (1:T);
        G(i, :) = G(i, :) + mean(abs( V(ind, 1) ), 1);
    end
    F = GenF(T, d_f, 1); % Factors. In the third input, 
                         % 1 stands for Case 1 or Case 3 of the paper,
                         % 2 stands for Case 2 or Case 4 of the paper
    
    X = randn(N*T, 1); % Regressors
    for t = 2:T
        ind_1     = (t-1):T:(N*T);
        ind       = t:T:(N*T);
        X(ind, 1) = X(ind_1, 1) + V(ind, 1);
    end
    
    Y = zeros(N*T, 1); % Dependent variable
    for i = 1:N
        for t = 1:T
            ind = (i-1)*T + t;
            Y(ind, 1) = X(ind, 1)*Bet(t/T) + G(i, :)*(F(t, :)') ...
                + E(ind, 1);
        end
    end
    % -------------------------------------------------
    
    
    % -------------------------------------------------
%     del = 0.1:0.1:0.9;
%     L   = length(del);
%     
%     err_pre = zeros(L, 1);
%     for j = 1:L
%         % Calculate the kernel matrix
%         [btemp, Ftemp, ~] = EstPanel(Y, X, T, h, J, del(j));
%         
%         K_d = K_delta(T, h, del(j));
%         M_F = eye(T) - Ftemp * (Ftemp')/T;
% 
%         etemp = 0;
%         for i = 1:N
%             ind   = (i-1)*T + (1:T);
%             temp  = Y(ind) - X(ind, 1)*btemp;
%             etemp = etemp + temp' * K_d * M_F * K_d * temp;
%         end
%         err_pre(j, 1) = etemp/(N*T);
%     end
%     err_pre = sqrt( mean(err_pre) );
%     
%     % Bandwidths
%     h1 = 2.34*err_pre/( (N*T*T)^(1/5) );
%     h2 = 0.8*h1;
%     h3 = 1.2*h1;
% 
%     % Estimation procedure I
%     no_eig1 = EstK(Y, X, h1, J, N);
%     if no_eig1 ~= d_f
%         ID1_rhat(imc, 1) = 0;
%     end
%     no_eig2 = EstK(Y, X, h2, J, N);
%     if no_eig2 ~= d_f
%         ID2_rhat(imc, 1) = 0;
%     end
%     no_eig3 = EstK(Y, X, h3, J, N);
%     if no_eig3 ~= d_f
%         ID3_rhat(imc, 1) = 0;
%     end
%     
%     temp1 = zeros(1, L_D);
%     temp2 = zeros(1, L_D);
%     temp3 = zeros(1, L_D);
%     for j = 1:L_D
%          [temp, ~, ~] = EstPanel(Y, X, T, h1, no_eig1, delta(j));
%          temp1(1, j) = temp;
%          [temp, ~, ~] = EstPanel(Y, X, T, h2, no_eig2, delta(j));
%          temp2(1, j) = temp;
%          [temp, ~, ~] = EstPanel(Y, X, T, h3, no_eig3, delta(j));
%          temp3(1, j) = temp;
%     end
%     Bet1_all(imc, :) = temp1; %#ok<*PFOUS>
%     Bet2_all(imc, :) = temp2;
%     Bet3_all(imc, :) = temp3;
    % -------------------------------------------------
    
    
    % -------------------------------------------------
    % Constancy Test based on Estimation procedure II
    no_eig = EstKPara(Y, X, J, N);
    [~, ~, ~, ~, tempstat] = EstPanelPara(Y, X, T, no_eig);
    
    if abs(tempstat) > 1.96
        LNT(imc, 1) = 1; 
    end
    disp(abs(tempstat))
    % -------------------------------------------------
end

rate = [mean(ID1_rhat), mean(ID2_rhat), mean(ID3_rhat), mean(LNT)];

filename = sprintf('B1N%dT%d.txt', N, T);
save(filename, 'Bet1_all', '-ascii')

filename = sprintf('B2N%dT%d.txt', N, T);
save(filename, 'Bet2_all', '-ascii')

filename = sprintf('B3N%dT%d.txt', N, T);
save(filename, 'Bet3_all', '-ascii')

filename = sprintf('RN%dT%d.txt', N, T);
save(filename, 'rate', '-ascii')

end