function K_d = K_delta(T, h, delta)
% This function calculates the kernel matrix used in the paper
% 
% Inputs:
% T           The number of time periods
% h           The bandwidth
% delta       The point at which we evaluate beta_0(.)
%
% Outputs:
% K_d         The kernel matrix

tau = (1:T)'/T;
K_d = zeros(T, T);
for t = 1:T
    if (delta >= h) && (delta <= 1-h )
        K_d(t, t) = sqrt( Kern( (tau(t) - delta)/h )/h );
    elseif delta < h
        temp = integral(@(x)Kern(x), -delta/h, 1);
        K_d(t, t) = sqrt( Kern( (tau(t) - delta)/h )/(h*temp) );
    else
        temp = integral(@(x)Kern(x), -1, (1-delta)/h);
        K_d(t, t) = sqrt( Kern( (tau(t) - delta)/h )/(h*temp) );
    end
end
end