function no_eig = EstKPara(Y, X, J, N)
% This function implements Step 2 of the estimation procedure
% 
% Inputs:
% Y           The dependent variable    (N*T)-by-1
% X           The regressors            (N*T)-by-d_x
% h           The bandwidth
% J           A user pre-specified number for intitial guess on the total
%             number of factors
% N           The number of individuals
%
% Ouputs:
% no_eig      The estimated number of factors

% Prepare some variables
NT  = length(Y);  % N*T
T   = NT/N;       % The number of time periods

[Bethat, ~, ~, ~, ~] = EstPanelPara(Y, X, T, J);

% Calculate the 0^{th} mock eigenvalue, and the sample covariance
% matrix
temp = zeros(T, T);
lam0 = 0;
for i = 1:N
    ind  = (i-1)*T + (1:T);
    Err  = Y(ind) - X(ind, :) * Bethat;
    temp = temp + Err  * (Err');
    lam0 = lam0 + Err' * Err;
end
temp = temp/N;
lam0 = lam0/N;

% Calculate the eigenvalues and eigenvectors
[~, lamtemp] = eig(temp);
[lamtemp, ~] = sort(diag(lamtemp), 'descend');
lamtemp      = [lam0; lamtemp];  %#ok<*AGROW>

% Estimate the number of factors based on the ratio criterion
ratiotemp = zeros(T, 1);
for t = 1:T
    if lamtemp(t)/lamtemp(1) <= ( 1/log(max(lam0, N)) )
        ratiotemp(t, 1) = 1;
    else
        ratiotemp(t, 1) = lamtemp(t+1)/lamtemp(t);
    end
end
% disp(ratiotemp)
[~, temp] = min(ratiotemp);
no_eig = temp - 1;

%disp(no_eig)
end