function [V, D] = EstF(Y, X1, K_d, a, tt)
% This function provides the estimates on eigenvalues and eigenvectors of 
% the following matrix
% 
%       1/(N) \sum_{i=1}^N K_d * (Y_i - X1_i * a) (Y_i - X1_i * a)' * K_d
%  
% Please see the paper for the detailed definitioin of each variable.
%  
% Notice that this function is invoked inside of "EstPanel.m", so 
% we suppress all the checks that have been implemented in "EstPanel.m"
%   
% Input:
% Y      (y_{11}, ..., y_{1T}, ..., y_{N1}, ..., y_{NT})'       
% X1     (x_{11}, ..., x_{1T}, ..., x_{N1}, ..., x_{NT})'
% K_d    The matrix associated to the kernel function
% a      It is the estimate of the coefficient
% tt     The number of time periods
%   
% Output:
% va     The eigenvalues of the matrix mentioned above arranged in 
%        decending order
% vc     The corresponding eigenvectors

N = length(Y)/tt; % The number of individuals

d_matrix = zeros(tt, tt);
for i = 1:N
    ind      = (i-1)*tt + (1:tt);
    temp     = Y(ind, 1) - X1(ind, :) * a;
    d_matrix = d_matrix + temp*(temp');
end
d_matrix = (K_d * d_matrix * K_d) / N;

% sort eigenvalues in descending order
[V, D] = eig(d_matrix);
[D, order] = sort(diag(D), 'descend'); 
V = sqrt(tt)*V(:,order);

end