source("kernels_JAE.R")
statistic <- function(u, h)
{
  neq <- NCOL(u)
  nobs <- NROW(u)
  grid <- (1:nobs)/nobs
  sum = sum2 <-0
  k <- matrix(0, nrow = nobs, ncol = nobs)
  for(t in 2:nobs)
  {
    for (s in 1:(t-1))
    {
      k[t, s] <-Kernel(grid[t]-grid[s], h , type ="Epa")
      for (i1 in 1:neq)
      {
        for (j1 in 1:neq)
        {
          if(j1 == i1 )
            next()
            sum = sum + u[t, i1]*u[s, j1]*k[t, s]
            #cat("i ", i, " j ", j, " t ", t, " s ", s, "\t")
          for(i2 in 1:neq)
              for(j2 in 1:neq)
              {
                if(i2 == j2)
                  next()
                sum2 <- sum2 + u[t, i1]*u[s, j1]*u[t, i2]*u[s, j2]*k[t, s]^2
              }
        }
            
      }
  
    }
  }
  LNT <- 2*sum
  BNT <- 2*(2*sum2)
  statistic <- LNT/sqrt(BNT)
  return(statistic)
}



.tvboot <- function (x , runs = 100, ci = 0.95, tboot="wild", factor =FALSE, method)
{
  PANEL <- x
  B <- PANEL$tvcoef
  BOOT <- vector("list", runs)
  resorig <- scale(PANEL$residuals, scale = FALSE)
  resid <-resorig
  fitted<-PANEL$fitted
  X.tilde <- PANEL$X.orig
  h <- PANEL$h
  nobs <- PANEL$nobs
  neq <- PANEL$neq
  nvar <- PANEL$nvar
 
  if(factor)
  {
    factor.dim <- PANEL$factor.dim
    BOOT2 <- vector("list", runs)
  }
  alpha <- PANEL$alpha
  
  for (i in 1:runs) 
  {
    if (tboot=="wild"){
      index <- ifelse(apply(resorig, 2, rbinom, size=1, prob=0.7236067977499789360962)==1, TRUE, FALSE)
      resid <- resorig*-0.6180339887498949025257 # (1-sqrt(5))*0.5
      resid [!index] <- resorig[!index]*1.618033988749894902526 # (1+sqrt(5))*0.5
      ystar<-fitted + resid
    }else if (tboot=="wild2"){
      resid <- resorig*rnorm(obs*neq)
      ystar <- fitted + resid
    }
    if(factor)
    {
      if(method == "tvPOLS")
        panelboot <- tvPOLS_PCA(X.tilde, ystar, h,nobs, neq,nvar, 
                              factor.dim = factor.dim)
      else if (method == "tvFE")
        panelboot <- tvFE_PCA(X.tilde, ystar, h, alpha,nobs, neq,nvar, factor.dim = factor.dim)
      BOOT2[[i]]<- panelboot$factors
    }
    else 
    {
      if(method == "tvPOLS")
        panelboot <- tvPOLS(X.tilde, ystar, h, nobs, neq,nvar)
      else if (method =="tvFE")
        panelboot <- tvFE(X.tilde, ystar, h, alpha,nobs, neq,nvar)
    }
    BOOT[[i]] <- panelboot$tvcoef
  }
  if(factor)
    return(list(BOOT = BOOT, BOOT2 = BOOT2))
  return(list(BOOT = BOOT))
}

CI<-function(x, ci, runs=100, tboot="wild", factor = FALSE, method ="tvPOLS")
{
  result <- .tvboot(x = x, runs = runs, tboot=tboot, factor = factor, method=method)
  BOOT <- result$BOOT
  nobs <- x$nobs
  neq <- x$neq
  nvar <- x$nvar
  B <- x$tvcoef
  lower <- ci/2
  upper <- 1 - ci/2
  mat.l <- matrix(NA, nrow=nobs, ncol=nvar)
  mat.u <- matrix(NA, nrow=nobs, ncol=nvar)
  temp <- matrix(NA, nrow=nobs, ncol=runs)
  for (l in 1:nvar) 
  {
    for (i in 1:runs) 
    {
      temp[,i] <- BOOT[[i]][,l]
    }
    sd.star <- apply(temp, 1,sd)
    c.hat <- apply(abs(temp-B[,l])/sd.star, 1, quantile, prob=upper, na.rm=TRUE)
    mat.l[,l] <- B[, l] - c.hat*sd.star
    mat.u[,l] <- B[, l] + c.hat*sd.star
  }
  x$Lower <- mat.l
  x$Upper <- mat.u
  if(x$factor)
  {
    nfactors <- x$factor.dim
    factors <- cbind(x$factors)
    if(nfactors == 1)
      factors <- cbind(factors)
    BOOT2 <- result$BOOT2
    mat.l <- matrix(NA, nrow=nobs, ncol=nfactors)
    mat.u <- matrix(NA, nrow=nobs, ncol=nfactors)
    temp <- matrix(NA, nrow=nobs, ncol=runs)
    for (l in 1:nfactors) 
    {
      for (i in 1:runs) 
      {
        temp[,i] 
        if(nfactors == 1)
          temp[,i] <-BOOT2[[i]]
        else
          temp[,i] <- matrix(BOOT2[[i]][,l])
      }
      sd.star <- apply(temp, 1,sd)
      c.hat <- apply(abs(temp-factors[,l])/sd.star, 1, quantile, prob=upper, na.rm=TRUE)
      mat.l[,l] <- factors[, l] - c.hat*sd.star
      mat.u[,l] <- factors[, l] + c.hat*sd.star
    }
    x$Lower2 <- mat.l
    x$Upper2 <- mat.u
  }
  return(x)
}

CI.factor<-function(factor, residuals, nobs, neq, nfactors, ci, runs=100, tboot="wild")
{
  BOOT <- .tvboot.factor(x = residuals, nobs, neq, nfactors, runs = runs, tboot=tboot)
  lower <- ci/2
  upper <- 1 - ci/2
  mat.l <- matrix(NA, nrow=nobs, ncol=nfactors)
  mat.u <- matrix(NA, nrow=nobs, ncol=nfactors)
  temp <- matrix(NA, nrow=nobs, ncol=runs)
  for (l in 1:nfactors) {
    for (i in 1:runs) {
      temp[,i] <- BOOT[[i]][,l]
    }
    sd.star <- apply(temp, 1,sd)
    c.hat <- apply(abs(temp-factor[,l])/sd.star, 1, quantile, prob=upper, na.rm=TRUE)
    mat.l[,l] <- factors[, l ] - c.hat*sd.star
    mat.u[,l] <- factors[, l ] + c.hat*sd.star
  }
  Lower <- mat.l
  Upper <- mat.u
  return(list(Lower = Lower, Upper = Upper))
}




