source("utils.R")
library(Matrix)

tvFE<-function(X, Y, h,alpha =NULL, nobs, neq, nvar, tkernel="Epa")
{
  X <- as.data.frame(X)
  if (sum(names(X)%in%c("ind", "time"))>0)
    X2 <- as.matrix(X[, -which(names(X) %in% c("ind", "time"))])
  else
    X2 <- as.matrix(X)
  fitted = resid <- numeric(nobs*neq)
  beta.hat <- matrix(0, nrow=nobs, ncol=nvar)
  alpha.hat <- matrix(0, nrow=nobs, ncol=neq-1)
  if(!is.null(alpha))
    alpha.hat <- matrix(rep(alpha, nobs), nrow=nobs, ncol=neq -1, byrow =TRUE)
  D <- t(cbind(rep(-1, neq-1), diag(neq-1)))%x%rep(1, nobs)
  grid <- (1:nobs)/nobs
  for (t in 1:nobs)
  {
        Xtemp <- X2
        k.temp <- Kernel(grid - grid[t], h, type = tkernel)
        if(grid[t]<h)
          k.temp <-k.temp/integrate(Epanechnikov, lower = -grid[t]/h, upper = 1)$value
        else if (grid[t]> (1-h))
          k.temp <-k.temp/integrate(Epanechnikov, lower = -1, upper = (1-grid[t])/h)$value
        k.temp <- sqrt(k.temp)
        W.tilde <- diag(neq)%x%diag(k.temp)
        temp <- crossprod(D, W.tilde)
        K.tilde <- diag(nobs*neq)- D%*%solve(temp%*%D)%*%temp
        W.tilde.star <- t(K.tilde)%*%W.tilde%*%K.tilde
        X.tilde <- crossprod(W.tilde.star,as.matrix(Xtemp))
        Y.tilde <- crossprod(W.tilde.star,Y)
        temp <- crossprod(X.tilde)
        result <- solve(temp)%*% crossprod(X.tilde,Y.tilde)
        beta.hat[t,] <- result [1:nvar]
        if(is.null(alpha))
        {
          temp3 <- crossprod(D, W.tilde)
          temp4 <- temp3%*%D
          alpha.hat[t,] <- as.numeric(solve(temp4)%*%temp3%*%(Y - X2%*%result))
        }
        for (i in 1:neq)
          fitted[t+(i-1)*nobs] <- sum(X2[t+(i-1)*nobs,]*beta.hat[t,]) 
  }

  if(!is.null(alpha))
    alpha.hat <- alpha
  else
    alpha.hat <- apply(alpha.hat, 2, mean)
  fitted <- fitted + drop(D%*%alpha.hat)
  resid <- Y - fitted 
  return(list(fitted = fitted, tvcoef = beta.hat, resid = resid, alpha.hat = alpha.hat))

}


tvFE.cv<-function(h,X, Y,alpha, block = 0, nobs, neq, nvar, 
                      tkernel="Epa")
{
  errormin <-.Machine$double.xmax
  X <- as.data.frame(X)
  if (sum(names(X)%in%c("ind", "time"))>0)
    X2 <- as.matrix(X[, -which(names(X) %in% c("ind", "time"))])
  else
    X2 <- as.matrix(X)
  fitted = fitted2 = resid <- numeric(nobs*neq)
  beta.hat=beta.hat2 <- matrix(0, nrow=nobs, ncol=nvar)
  alpha.hat=alpha.hat2 <- matrix(0, nrow=nobs, ncol=neq-1)
  if(!is.null(alpha))
    alpha.hat=alpha.hat2 <- matrix(rep(alpha, nobs), nrow=nobs, ncol=neq -1, byrow =TRUE)
  grid <- (1:nobs)/nobs
  D =  t(cbind(rep(-1, neq-1), diag(1, neq-1)))%x%rep(1, nobs)
  for (t in 1:nobs)
  {
    delta0 <- grid - grid[t]
    Xtemp <- X2
    k.temp <- Kernel(grid - grid[t], h, type = tkernel)
    k.temp[max(1, (t-block)):min((t+block), nobs)] <- 0
    if(grid[t]<h)
      k.temp <-k.temp/integrate(Epanechnikov, lower = -grid[t]/h, upper = 1)$value
    else if (grid[t]> (1-h))
      k.temp <-k.temp/integrate(Epanechnikov, lower = -1, upper = (1-grid[t])/h)$value
    k.temp <- sqrt(k.temp)
    w.0 <- sum(k.temp)
    k.index <- which(k.temp!=0)
    if (sum(k.index != 0) < 3)
      return (.Machine$double.xmax)
    W.tilde <- diag(1, neq)%x%diag(k.temp)
    temp <- crossprod(D,W.tilde)
    inverse<- try(D%*%solve(temp%*%D)%*%temp, silent=TRUE)
    if(inherits(inverse, "try-error")) return (errormin)
    K.tilde <- diag(1, nobs*neq) - inverse
    W.tilde.star <- t(K.tilde)%*%W.tilde%*%K.tilde
    X.tilde <- crossprod(W.tilde.star,as.matrix(Xtemp))
    Y.tilde <- crossprod(W.tilde.star,Y)
    temp <- crossprod(X.tilde)
    result <- solve(temp)%*% crossprod(X.tilde,Y.tilde)
    beta.hat[t,] <- result 
    for (i in 1:neq)
      fitted[t+(i-1)*nobs] <- X2[t+(i-1)*nobs,]%*%result
    if(is.null(alpha))
    {
      temp3 <- crossprod(D, W.tilde)
      temp4 <- temp3%*%D
      alpha.hat[t,] <- as.numeric(solve(temp4)%*%temp3%*%(Y - X2%*%result))
    }
  }
  if(!is.null(alpha))
    alpha.hat <- alpha
  else
    alpha.hat <- apply(alpha.hat, 2, mean)
  fitted <- fitted + drop(D%*%alpha.hat)
  resid <- Y - fitted 
  return(mean(resid^2))
}
tvPOLS<-function(X, Y, h,nobs, neq, nvar, tkernel="Epa")
{
  X <- as.data.frame(X)
  if (sum(names(X)%in%c("ind", "time"))>0)
    X2 <- as.matrix(X[, -which(names(X) %in% c("ind", "time"))])
  else
    X2 <- as.matrix(X)
  fitted <- numeric(nobs*neq)
  beta.hat <- matrix(0, nrow=nobs, ncol=nvar)
  grid <- (1:nobs)/nobs
  Xnew <- X2
  Ynew <- Y
  for (t in 1:nobs)
  {
    Upsilon <- Kernel(grid - grid[t], h, type = tkernel)
    if(grid[t]<h)
      Upsilon <-Upsilon/integrate(Epanechnikov, lower = -grid[t]/h, upper = 1)$value
    else if (grid[t]> (1-h))
      Upsilon <-Upsilon/integrate(Epanechnikov, lower = -1, upper = (1-grid[t])/h)$value
    Upsilon <- sqrt(Upsilon)
    for (i in 1:neq)
    {
      ind <- (i-1)*nobs + (1:nobs)
      Xnew[ind, ] <- X2[ind,] * Upsilon
      Ynew[ind] <- Y[ind] * Upsilon
    }
    result<-try(qr.solve(crossprod(Xnew))%*%crossprod(Xnew, Ynew))
    if(inherits(result, "try-error"))
      browser()
    beta.hat[t,]<-result
    for (i in 1:neq)
      fitted[t+(i-1)*nobs] <- sum(X2[t+(i-1)*nobs,]*beta.hat[t,])
  }
  resid <- Y - fitted
  return(list(fitted = fitted, tvcoef = beta.hat, resid = resid))
}

tvPOLS.cv<-function(h,X, Y, block = 0, nobs, neq, nvar, tkernel="Epa")
{
  X <- as.data.frame(X)
  if (sum(names(X)%in%c("ind", "time"))>0)
    X2 <- as.matrix(X[, -which(names(X) %in% c("ind", "time"))])
  else
    X2 <- as.matrix(X)
  fitted <- numeric(nobs*neq)
  grid <- (1:nobs)/nobs
  Xnew <- X2
  Ynew <- Y
  for (t in 1:nobs)
  {
    Upsilon <- Kernel(grid - grid[t], h, type = tkernel)
    Upsilon[max(1, (t-block)):min((t+block), nobs)] <- 0
    if(grid[t]<h)
      Upsilon <-Upsilon/integrate(Epanechnikov, lower = -grid[t]/h, upper = 1)$value
    else if (grid[t]> (1-h))
      Upsilon <-Upsilon/integrate(Epanechnikov, lower = -1, upper = (1-grid[t])/h)$value
    Upsilon <- sqrt(Upsilon)
    if (sum(Upsilon != 0) < 3)
      return (.Machine$double.xmax)
    for (i in 1:neq)
    {
      ind <- (i-1)*nobs + (1:nobs)
      Xnew[ind, ] <- X2[ind,] * Upsilon
      Ynew[ind] <- Y[ind] * Upsilon
    }
    beta.hat<-solve(crossprod(Xnew))%*%crossprod(Xnew, Ynew)
    for (i in 1:neq)
      fitted[t+(i-1)*nobs] <- sum(X2[t+(i-1)*nobs,]*beta.hat)
  }
  resid <- Y - fitted
  return(mean(resid^2))
}
