source("kernels_JAE.R")
source("bw.R")
source("tvPANEL_JAE.R")
source("PANEL_PCA_JAE.R")
source("utils.R")
library(MASS)
library("plm")
library("phtt")
sensitivity_JAE<-function(zone = "Eurozone")
{
  #zone can be "Eurozone" or "OECD"
  #By the default, the bandwidths are selected by leave-nobs/4-out cross-validation
  cat("\nEstimating models for the", zone, "\n")
  cat("-------------------------------------------\n\n")
  data <- read.table(paste(zone, ".csv", sep = ""), h=T, sep=",")
  Y.tilde <- data$lhe
  neq <- levels(data$country)
  countries.final <- levels(data$country)
  neq <- length(countries.final)
  nobs <- nrow(data)/neq
  ind <- rep(1:neq, each=nobs) 
  time <- rep(1:nobs, neq)
  X.tilde <- data.frame( ind=ind, time=time,
                         LogGDP = data$LogGDP, Pop65 = data$Pop65,
                         Pop14 = data$Pop14,
                         Gov = data$Gov)
  nvar <- ncol(X.tilde) -2
  lgdp_tvife <- matrix(0, nrow = nobs, ncol = length(countries.final)+2)
  h2<-bwtvpolspca(X.tilde, Y.tilde, block = floor(nobs/4),  
                 nobs=nobs, neq=neq, nvar=nvar, tkernel="Epa")
  sigma.star <- sqrt(tvPOLS_PCA.cv(h2, X.tilde, Y.tilde, block= floor(nobs/4), nobs, neq, nvar, tkernel="Epa"))
  h2 <- 2.34*neq^(-1/5)*nobs^(-2/5)*2.34*sigma.star
  
  #===TVIFE======
  cat("\nEstimating TVIFE... full sample \n")
  result<- tvPOLS_PCA(X.tilde, Y.tilde, h=h2, nobs, neq,nvar, 
                      factor.dim = NULL)
  lgdp_tvife[, length(countries.final)+2] <-result$tvcoef[, 1]
  
  for ( k in 1:length(countries.final))
  {
    index <- 1:nobs + (k-1)*nobs
    X.tilde2 <- X.tilde[-index, ]
    Y.tilde2 <- Y.tilde[-index]

    #===TVIFE======
    cat("\nEstimating TVIFE... without ", countries.final[k],"\n")
    result<- tvPOLS_PCA(X.tilde2, Y.tilde2, h=h2, nobs, neq-1,nvar, 
                       factor.dim = NULL)
    lgdp_tvife[, k] <-result$tvcoef[, 1]

  }
  #====================================================================
  par(mar = c(6, 2, 3, 1), las = 3, cex.axis = 1)
  ylim1 = c(0.53,0.77)
  names = c(countries.final,  "", zone)
  main = paste0(zone, " - TVIFE\n income elasticity distribution")
  boxplot(lgdp_tvife, names = names, ylim =  ylim1, main = main)
  abline(v=neq+1, lty = 3)
}  


