plot.factors<- function(zone = "OECD", nboot=100, level = 0.05, nvar )
{
  filename <- paste0("Estimation_", zone, "_nvar_", nvar, "_nboot_",nboot, "_level_", level, ".rda")
  load(filename)
  neq <- estimation$TVIFE$neq
  nobs <-estimation$TVIFE$nobs
  F.TVIFE <- estimation$TVIFE$factors
  r <- NCOL(F.TVIFE)
  if(r ==1)
    F.TVIFE <- cbind(F.TVIFE)
  lambda.TVIFE <- estimation$TVIFE$lambda
  Upper1 <- estimation$TVIFE$Upper2
  Lower1 <- estimation$TVIFE$Lower2
  countries <- as.character(estimation$TVIFE$countries)
  x.axis<-1995:2014
  par(mfrow = c(1, 1), mar = c(4, 3, 2, 1), lwd = 2,  cex.main = 1.5)
  colour =c("black", "blue", "red", "magenta", "yellow3", 
            "green", "darkturquoise", "grey50", "darkorange3")
  colour2 = c("grey60", "grey70", "grey80", "grey90")
  cat("\n\nPlotting unobservable factors of the ", zone, "\n")
  nvar <- estimation$TVIFE$nvar
  if(nvar == 4)
    main <- paste0("Factors of ", zone, "\n X = (pop65, pop14, public)")
  else if (nvar == 1)
    main <- paste0("Factors of ", zone, "\n without X")
  else if(nvar == 3)
    main <- paste0("Factors of ", zone, "\n X = (pop65, pop14)")
  pdf(paste0(zone, "_factors_nvar_", nvar, ".pdf"))
  for (i in 1:NCOL(F.TVIFE))
  {
    if(i == 1)
      plot(x.axis, F.TVIFE[,i], xlab ="year", ylab =expression(F[0]), 
           main = main, 
           ylim = c(-5, 5), type ="l")
    polygon(c(rev(x.axis), x.axis), c(rev(Upper1[,i]), Lower1[,i]), 
          col=colour2[i], border=NA, fillOddEven = TRUE)
    lines(x.axis, F.TVIFE[,i], lty = i)
  }
  legend("top", legend = paste0("f ",1:NCOL(F.TVIFE)), col = 1, 
         lty = 1:NCOL(F.TVIFE), bty="n", ncol = 4)
  dev.off()
  
}


effects <- function()
{
  if(zone =="OECD")
  {
    cat("\n\nPlotting interactive effects of the ", zone, "\n")
    Factors <- matrix(0, nrow = nobs, ncol = neq)
    for (i in 1:length(countries))
    {
      #for each country
      Factors[, i] <- tcrossprod(lambda.TVIFE[,i], F.TVIFE)
    }
    colnames(Factors) <- countries
    colour =c("black", "blue", "red", "magenta", "yellow3", 
              "green", "darkturquoise", "grey50", "darkorange3")
    ylim <- range(-1.1, 1)
    par(mfrow = c(1, 1), mar = c(4, 3, 2, 1), lwd = 2, cex.main = 1.5)
    #Nordic
    index <- c(7, 9, 14, 24, 30)
    pdf("OECD_effects1.pdf")
    plot(x.axis, Factors[, index[1]], col = 1, type ="l", ylim =ylim, 
         ylab ="Contribution of unknown factors", xlab ="year",
         main = "Nordic")
    
    for (i in 2:length(index))
      lines(x.axis, Factors[, index[i]], col= colour[i])
    legend("topleft", countries[index], col =colour[1:length(index)], lty = 1, 
           ncol=3, bty="n")
    dev.off()
    #mtext(text = "year", side = 1, line = 2)
    #Eastern Europe
    index <- c(6, 8, 13, 19, 25, 27,  28)
    pdf("OECD_effects2.pdf")
    plot(x.axis, Factors[, index[1]], col = 1, type ="l", ylim =ylim, 
         ylab ="Contribution of unknown factors", xlab ="year",
         main = "Eastern Europe")
    for (i in 2:length(index))
      lines(x.axis, Factors[, index[i]], col= colour[i])
    #mtext(text = "year", side = 1, line = 2)
    legend("topleft", countries[index], col =colour[1:length(index)], lty = 1, 
           ncol=3, bty="n")
    dev.off()
    #Central Europe
    index <- c(2, 3, 10,11, 20, 22, 31)
    pdf("OECD_effects3.pdf")
    plot(x.axis, Factors[, index[1]], col = 1, type ="l", ylim =ylim, 
         ylab ="Contribution of unknown factors", xlab ="year",
         main = "Central Europe")
    for (i in 2:length(index))
      lines(x.axis, Factors[, index[i]], col= colour[i])
    #mtext(text = "year", side = 1, line = 2)
    # mtext("Central Europe", side = 3, line = 0.5)
    legend("topleft", countries[index], col =colour[1:length(index)], lty = 1, 
           ncol=5, bty="n")
    dev.off()
    #Commonwealth and ex-commonwealth
    index <- c(1, 4, 33, 23, 15)
    pdf("OECD_effects4.pdf")
    plot(x.axis, Factors[, index[1]], col = 1, type ="l", ylim =ylim, 
         ylab ="Contribution of unknown factors", xlab ="year",
         main = "Commonwealth and Ireland")
    for (i in 2:length(index))
      lines(x.axis, Factors[, index[i]], col= colour[i])
    #mtext(text = "year", side = 1, line = 2)
    #mtext("Commonwealth and Ireland", side = 3, line = 0.5)
    legend("topleft", countries[index], col =colour[1:length(index)], lty = 1, 
           ncol=3, bty="n")
    dev.off()
    #Mediterranean countries
    index <- c(12, 16, 17, 26,  29, 32)
    pdf("OECD_effects5.pdf")
    plot(x.axis, Factors[, index[1]], col = 1, type ="l", ylim =ylim, 
         ylab ="", xlab ="year",
         main = "Mediterranean and Portugal")
    for (i in 2:length(index))
      lines(x.axis, Factors[, index[i]], col= colour[i])
    #mtext(text = "year", side = 1, line = 2)
    legend("topleft", countries[index], col =colour[1:length(index)], lty = 1, 
           ncol=5, bty="n")
    dev.off()
    #Other coutries countries
    index <- c(5, 18, 21,  34)
    pdf("OECD_effects6.pdf")
    plot(x.axis, Factors[, index[1]], col = 1, type ="l", ylim =ylim, 
         ylab ="Contribution of unknown factors", xlab ="year",
         main = "Rest of OECD")
    for (i in 2:length(index))
      lines(x.axis, Factors[, index[i]], col= colour[i])
    #mtext(text = "year", side = 1, line = 2)
    legend("topleft", countries[index], col =colour[1:length(index)], lty = 1, 
           ncol=2, bty="n")
    dev.off()
  }
}
