
plot.beta<- function(zone = "Eurozone",  nboot=100, level = 0.05, nvar)
{
  filename <- paste0("Estimation_", zone, "_nvar_", nvar, "_nboot_",nboot, "_level_", level, ".rda")
  load(filename)
  cat("\nPlotting coefficient estimates of the ", zone,"\n")
  x.axis <- 1995:2014
  neq <- estimation$TVIFE$neq
  nobs <- estimation$TVIFE$nobs
  nvar <- estimation$TVIFE$nvar
  beta.FE <- estimation$FE$coef
  beta.TVFE <-estimation$TVFE$tvcoef
  beta.TVIFE <- estimation$TVIFE$tvcoef
  beta.mod18 <- estimation$mod18$coef
  Lower.FE <- estimation$FE$Lower
  Upper.FE <- estimation$FE$Upper
  Lower.TVFE <- estimation$TVFE$Lower
  Upper.TVFE <- estimation$TVFE$Upper
  Lower.TVIFE <- estimation$TVIFE$Lower
  Upper.TVIFE <- estimation$TVIFE$Upper

  var.names = names(estimation$TVFE$X.orig[-c(1:2)])
  if(length(var.names) == 4)
    main <- c(paste0(zone, ": Log GDP\n X = (pop65, pop14, public)"), 
              paste0(zone, ": Population over 65\n X = (pop65, pop14, public)"), 
              paste0(zone, ": Population under 15\n X = (pop65, pop14, public)"),
              paste0(zone, ": Public investment\n X = (pop65, pop14, public)"))
  else if (length(var.names) == 1)
    main <- paste0(zone, ": Log GDP\n without X")
  else if(length(var.names) == 3)
    main <- c(paste0(zone, ": Log GDP\n X = (pop65, pop14)"), 
              paste0(zone, ": Population over 65\n X = (pop65, pop14)"), 
              paste0(zone, ": Population under 15\n X = (pop65, pop14)"))
 
  par(mfrow = c(1, 1), mar = c(4, 3, 2, 1), cex.main = 0.9, 
      lwd = 2, cex.axis = 0.7, cex.lab = 0.8)
  for (i in nvar:1)
  { 
    pdf(paste0(zone,"_",var.names[i], "_nvar_",nvar, ".pdf"))
    
    par(lwd=2, mar=c(5, 2, 3, 1))
    if(var.names[i] =="LogGDP")
        ylim = c(0.35, 2.4)
    else if (var.names[i] == "Pop65")
      ylim = c(-0.15, 0.25)
    else if (var.names[i] == "Pop14")
      ylim = c(-0.15, 0.13)
    else if (var.names[i] == "Gov")
      ylim = c(-0.03, 0.12)
    else
      ylim = c(-3, 3)

     # ylim = range(Lower.TVFE[, i], Upper.TVIFE[,i], Upper.TVFE[,i], Lower.TVIFE[,i])

    plot(x.axis,beta.TVFE[, i], type="l", xlab="", ylab ="",ylim=ylim, main=main[i])
    if(nvar == 1)
    polygon(c(rev(x.axis), x.axis), 
            c(rev(rep(Upper.FE[i], length(x.axis))), rep(Lower.FE[i], length(x.axis))), 
            col="grey60", border=NA, fillOddEven = TRUE)
    polygon(c(rev(x.axis), x.axis), c(rev(Upper.TVFE[,i]), Lower.TVFE[,i]), 
            col="grey80", border=NA, fillOddEven = TRUE)
    polygon(c(rev(x.axis), x.axis), c(rev(Upper.TVIFE[,i]), Lower.TVIFE[,i]), 
            col="grey40", border=NA, fillOddEven = TRUE)
    
    if(nvar == 1)
    lines(x.axis,rep(beta.FE[i], length(x.axis)), col =1, lty =4) 
    lines(x.axis,beta.TVFE[, i], col= 1, lty =1) 
    lines(x.axis,beta.TVIFE[, i], col= 1, lty =2)
   # abline(h=0, lty=3)
    mtext(text = "year", side = 1, line = 2, cex = 0.8)
    if(nvar ==1)
    legend("top", legend = c("FE", "TVFE", "TVIFE"), 
           col=1, lty=c(4,1:2), ncol = 3, text.width = 4,  bty = "n")
    else
      legend("top", legend = c("TVFE", "TVIFE"), 
             col=1, lty=c(1:2), ncol = 2, text.width = 4,  bty = "n")
    dev.off()
  }
}
