#--------------------

Kernel<-function(x, h, type = "Gaussian")
{
	return(kernel.conv(x, h, type=type))
	return(0)
	
}

kernel.conv<-function(x, h, type="Gaussian", cv=TRUE)
{  #Kernel function, Gaussian kernel, order 2, infinite support.
   x <- x/c(h) 
   value <- numeric(length(x))
   if (type == "Gaussian")
   {
   	value <- exp(-0.5*x^2)/sqrt(2*pi)
   }
   else if(type == "Epa")
   {
	  index <- (x>=-1 & x<=1)
	  value[index]<-0.75*(1-x[index]^2)
   }
   else if(type == "Parzen")
   {
     index <- (abs(x)<=0.5 & abs(x)>=0)
     value[index] <- 1-6*x[index]^2 + 6*abs(x[index])^3
     index <- (abs(x)>=0.5 & abs(x)<=1)
     value[index] <- 2*(1-abs(x[index]))^3
   }
   else if(type == "Barlett")
   {
     index <- abs(x)<=1
     value[index] <- 1-abs(x)
   }
   else if(type == "Truncated")
   {
     index <- abs(x)<=1
     value[index] <- 1
   }
   else if(type == "Lag")
   {
     value <- exp(-0.5*x^2)
   }
   return(value)
	
}

Epanechnikov <- function(x)
{
  value <- numeric(length(x))
  index <- (x>=-1 & x<=1)
  value[index]<-0.75*(1-x[index]^2)
  return(value)
   
}
