source("kernels_JAE.R")
source("bw.R")
source("tvPANEL_JAE.R")
source("PANEL_PCA_JAE.R")
source("plot.beta_JAE.R")
source("plot.factors_JAE.R")
source("utils.R")
library(MASS)
library("plm")
library("phtt")
estimation_JAE<-function(zone = "Eurozone", nboot=5, level = 0.05, nvar = 4)
{
  #zone can be "Eurozone" or "OECD"
  #By the default, the bandwidths are selected by leave-k-out cross-validation
  #nboot is the number of bootstrap resamples used in the computation of 
  #bootstrap confidence intervals in the paper use nboot = 100, here we write nboot = 5
  #by default for testing so it does not get as long.
  cat("\nEstimating models for the", zone, "\n")
  cat("-------------------------------------------\n\n")
  data <- read.table(paste(zone, ".csv", sep = ""), h=T, sep=",")
  Y.tilde <- data$lhe
  countries.final <- levels(as.factor(data$country))
  neq <- length(countries.final)
  nobs <- nrow(data)/neq
  ind <- rep(1:neq, each=nobs) 
  time <- rep(1:nobs, neq)
  X.tilde <- data.frame( ind=ind, time=time, 
                       LogGDP = data$LogGDP, Pop65 = data$Pop65, Pop14 = data$Pop14,
                       Gov = data$Gov)
  if(nvar == 1)
    X.tilde <- X.tilde[, 1:3]
  else if(nvar == 3)
    X.tilde <- X.tilde[, -6]
  else if (nvar == 2)
    X.tilde <- X.tilde[, 1:4]
  nvar <- ncol(X.tilde) - 2
  
  #=====FE======
  pdata <- pdata.frame(data, index = c("country", "year"))
  #Between 1
  if(nvar == 1)
    result <- plm(lhe~1+LogGDP , model ="within", effect="individual", 
                data = pdata)
  if(nvar == 3)
    result <- plm(lhe~1+LogGDP + Pop65+ Pop14 , model ="within", effect="individual", data = pdata)
  if(nvar == 4)
    result <- plm(lhe~1+LogGDP + Pop65+ Pop14 + Gov, model ="within", effect="individual", data = pdata)
  FE <- list(coef =result$coefficient, neq = neq, nvar = nvar, zone= zone,
             countries = countries.final)
  result.ci <- confint(result, level = 1-level)
  FE$Lower <- result.ci[, 1]
  FE$Upper <- result.ci[, 2]
  
  #===TVFE======
  h<-bwtvfe(X.tilde, Y.tilde, alpha = NULL, block = floor(nobs/4),  
            nobs=nobs, neq=neq, nvar=nvar, tkernel="Epa")
 #h <- 0.56
  cat("\nTVFE estimation... Bandwidth, ",h)
  result <- tvFE(X.tilde, Y.tilde, h=h, alpha=NULL,nobs, neq,nvar)
  cat(" ... RMSE ", sqrt(mean(result$resid^2)),"... no factors\n")
  TVFE <- list(h=h,tvcoef=result$tvcoef, fitted=result$fitted, 
                  alpha.hat=result$alpha.hat, residuals=result$resid, 
                  factor = FALSE,  Y.orig=Y.tilde,
                  X.orig = X.tilde,  nobs=nobs, alpha = NULL, 
                  alpha.hat = result$alpha.hat,
                  neq = neq, 
                  nvar = nvar,
                  zone = zone, countries = countries.final)
  #(1-level)% confidence interval computation, nboot bootstrap replications
  result.ci <- CI(TVFE, runs = nboot, ci = level, factor = FALSE, method ="tvFE")
  TVFE$Lower <- result.ci$Lower
  TVFE$Upper <- result.ci$Upper

  #===TVIFE======
  cat("\nTVIFE estimation... ")
  h<-bwtvpolspca(X.tilde, Y.tilde, block = floor(nobs/4), 
                 nobs=nobs, neq=neq, nvar=nvar, tkernel="Epa")
  sigma.star <- sqrt(tvPOLS_PCA.cv(h, X.tilde, Y.tilde, block= floor(nobs/4), nobs, neq, nvar, tkernel="Epa"))
  h <- 2.34*neq^(-1/5)*nobs^(-2/5)*2.34*sigma.star
  
  cat("Bandwidth: ",h)
  result <- tvPOLS_PCA(X.tilde, Y.tilde, h=h, nobs, neq,nvar, 
                        factor.dim = NULL)
  cat("... Number of factors: ", result$factor.dim, " RMSE ", sqrt(mean(result$resid^2)))
  TVIFE <- list(h=h,tvcoef=result$tvcoef, fitted=result$fitted, 
             residuals= result$resid, factors = result$factors, 
             lambda = result$lambda,factor.dim = result$factor.dim,
             Y.orig = Y.tilde,
             X.orig = X.tilde, factor = TRUE,
             factor.dim = NULL,
             zone = zone, nobs = nobs, neq=neq, 
             nvar = nvar, 
             countries = countries.final)
  #confidence intervals with bootstrapping
  result.ci <- CI(TVIFE, runs = nboot, ci = level, factor = TRUE, method ="tvPOLS")
  TVIFE$Lower <- result.ci$Lower
  TVIFE$Upper <- result.ci$Upper
  TVIFE$Lower2 <- result.ci$Lower2
  TVIFE$Upper2 <- result.ci$Upper2
  #====================================================================
  estimation=list(FE = FE, TVFE=TVFE, TVIFE=TVIFE)
  save(estimation, file = paste("Estimation_", zone, "_nvar_", nvar,"_nboot_",nboot, "_level_", level, ".rda", sep =""))
  plot.beta(zone = zone, nboot = nboot, level = level, nvar = nvar)
  plot.factors(zone = zone, nboot = nboot, level = level, nvar = nvar)
}  

