source("PANEL_PCA_JAE.R")
library(plm)
source("utils.R")
library(phtt)
library(xtable)
Constancy_Test_JAE<-function(zone = "Eurozone", nvar = 4)
{
  #nvar = 1, model lhe~0+LogGDP
  #nvar = 3, model lhe~0+LogGDP + Pop65+ Pop14
  #nvar = 4, model lhe~0+LogGDP + Pop65+ Pop14 + Gov
  cat("\nConstancy test for the", zone, "\n")
  cat("-------------------------------------------\n\n")
  data <- read.table(paste(zone, ".csv", sep = ""), h=T, sep=",")
  neq <- length(levels(as.factor(data$country)))
  nobs <- nrow(data)/neq
  #H0 model estimation, constant betas
  J <- nobs
  if (nvar == 4)
    formula <- (lhe~0+LogGDP + Pop65+ Pop14 + Gov)
  else if (nvar ==3)
   formula <- (lhe~0+LogGDP + Pop65+ Pop14)
  else if (nvar == 1)
    formula <- (lhe~0+LogGDP)
  result <- OLS_PCA(formula, data, index = c("country", "year"), nobs, neq, nfactors = J)
  error <- matrix (result$model$residuals, nrow = nobs, ncol = neq)
  Sigma.tilde <-0
  eta0 <-0
  for(i in 1:neq)
  {
    Sigma.tilde<- Sigma.tilde + tcrossprod(error[, i])
    eta0 <- eta0 + mean(error[, i]^2)
  }
  Sigma.tilde <- Sigma.tilde/neq
  eta0 <- eta0/neq
  epsilon.N <- 1/log(max(eta0, neq))
  fpca<-eigen(Sigma.tilde)
  eta <- c(eta0/neq , fpca$values[fpca$values !=0])
  b <-(eta[-1]/eta[-(J+1)] )*((eta[-(J+1)]/eta[1])>=epsilon.N) + ((eta[-(J+1)]/eta[1])<epsilon.N)
  r <- which.min(b)
  result <- OLS_PCA(formula, data, index = c("country", "year"), nobs, neq, nfactors = r)
  u.tilde <- result$model$residuals - as.vector(tcrossprod(result$factors, result$lambda))
  error <-   matrix (u.tilde, nrow = nobs, ncol = neq)
  sigmau <- 0
  for(i in 1:neq)
    sigmau <- sigmau + crossprod(error[,i])
  sigmau<-sqrt(sigmau/(neq*nobs))
  h.star <- max(3/nobs, 2.34*sigmau/(nobs^(0.4)))
  statistic <- statistic(error, h.star)
  if(statistic>0)
    pvalue <- pnorm(statistic, lower.tail = FALSE)
  else
    pvalue <- pnorm(statistic, lower.tail = TRUE)
  cat("Constancy two-tailed test for ", zone, ", bandwidth", h.star, "\n\ntest statistic = ", statistic, ", p-value: ", pvalue*2, 
      "\nnull hypothesis: all coefficients are constant \nalternative hypothesis: the coefficient of at least one of the variables is time-varying\n")
  return(2*pvalue)
}  

Table3 <- function()
{
  final.table <- NULL
  for (nvar in c(1, 3, 4))
  {
    result1 <- Constancy_Test_JAE(nvar = nvar)
    result2 <- Constancy_Test_JAE(zone ="OECD", nvar = nvar)
    final.table <- rbind(final.table, c(result1, result2))
  }
  rownames(final.table) <- c("lgdp", "lgdp, pop65, pop14", "lgdp, pop65, pop14, public")
  colnames(final.table) <- c("Eurozone", "OECD")
  xtable(final.table, digits = 3)
}

