library(xtable)
library(plm)
library(phtt)
source("PANEL_PCA_JAE.R")
  coeftable<- matrix(NA, nrow = 5, ncol = 12)
  citable <- matrix(NA, nrow = 5, ncol = 12)
  for (zone in c("Eurozone", "OECD"))
  {
    R2 = RMSE <- NULL
    data <- read.table(paste(zone, ".csv", sep = ""), h=T, sep=",")
    countries.final <- levels(as.factor(data$country))
    neq <- length(countries.final)
    nobs <- nrow(data)/neq
    pdata <- pdata.frame(data, index = c("country", "year"))
    #Between 1
 
    result <- plm(lhe~1+LogGDP , model ="between", effect="individual", data = pdata)
    coeftable[1:2, 1]<-round(result$coefficients, 2)[]
    ci <- confint(result, level = 0.95)[,]
    citable[1:2,1] <-  apply(round(ci, 2), 1, paste, collapse =",")
    RMSE <- c(RMSE, round(sqrt(mean(result$resid^2)), 3))
    #Between 2
    result <- plm(lhe~1+LogGDP + Pop65+ Pop14 , model ="between", effect="individual", data = pdata)
    coeftable[1:4, 2]<-round(result$coefficients, 2)[]
    ci <- confint(result, level = 0.95)[,]
    citable[1:4,2] <- apply(round(ci, 2), 1, paste, collapse =",")
    RMSE <- c(RMSE, round(sqrt(mean(result$resid^2)), 3))
    #Between 3
    result <- plm(lhe~1+LogGDP + Pop65+ Pop14 + Gov, model ="between", effect="individual", data = pdata)
    coeftable[1:5, 3]<-round(result$coefficients, 2)[]
    ci <- confint(result, level = 0.95)[,]
    citable[1:5,3] <- apply(round(ci, 2), 1, paste, collapse =",")
    RMSE <- c(RMSE, round(sqrt(mean(result$resid^2)), 3))
    #RE 1
    result <- plm(lhe~1+LogGDP , model ="random", effect="individual", data = pdata)
    coeftable[1:2, 4]<-round(result$coefficients, 2)[]
    ci <- confint(result, level = 0.95)[,]
    citable[1:2,4] <-  apply(round(ci, 2), 1, paste, collapse =",")
    RMSE <-  c(RMSE, round(sqrt(mean(result$resid^2)), 3))
    #RE 2
    result <- plm(lhe~1+LogGDP + Pop65+ Pop14 , model ="random", effect="individual", data = pdata)
    coeftable[1:4, 5]<-round(result$coefficients, 2)[]
    ci <- confint(result, level = 0.95)[,]
    citable[1:4,5] <- apply(round(ci, 2), 1, paste0, collapse =",")
    RMSE <- c(RMSE, round(sqrt(mean(result$resid^2)), 3))
    #RE 3
    result <- plm(lhe~1+LogGDP + Pop65+ Pop14 + Gov, model ="random", effect="individual", data = pdata)
    coeftable[1:5, 6]<-round(result$coefficients, 2)[]
    ci <- confint(result, level = 0.95)[,]
    citable[1:5,6] <- apply(round(ci, 2), 1, paste0, collapse =",")
    RMSE <- c(RMSE, round(sqrt(mean(result$resid^2)), 3))
    #FE 1
    result <- plm(lhe~1+LogGDP , model ="within", effect="individual", data = pdata)
    coeftable[2, 7]<-round(result$coefficients, 2)
    ci <- confint(result, level = 0.95)
    citable[2,7] <- paste0(round(ci, 2), collapse =",")
    RMSE <- c(RMSE, round(sqrt(mean(result$resid^2)), 3))
    #FE 2
    result <- plm(lhe~1+LogGDP + Pop65+ Pop14 , model ="within", effect="individual", data = pdata)
    coeftable[2:4, 8]<-round(result$coefficients, 2)
    ci <- confint(result, level = 0.95)
    citable[2:4,8] <- apply(round(ci, 2), 1, paste0, collapse =",")
    RMSE <- c(RMSE, round(sqrt(mean(result$resid^2)), 3))
    #FE 3
    result <- plm(lhe~1+LogGDP + Pop65+ Pop14 + Gov, model ="within", effect="individual", data = pdata)
    coeftable[2:5, 9]<-round(result$coefficients, 2)
    ci <- confint(result, level = 0.95)
    citable[2:5,9] <- apply(round(ci, 2), 1, paste0, collapse =",")
    RMSE <- c(RMSE, round(sqrt(mean(result$resid^2)), 3))
    #IFE 1 
    result <- FE_PCA(lhe~LogGDP , pdata, nobs, neq, effect="individual")
    factor.dim <- result$factor.dim
    cat("number of factors: ", factor.dim, "\n")
    coeftable[2, 10]<-round(result$model$coefficients, 2)
    ci <- confint(result$model, level = 0.95)
    citable[2,10] <- apply(round(ci, 2), 1, paste0, collapse =",")
    RMSE <- c(RMSE, round(sqrt(mean(result$model$residuals^2)), 3))
    #IFE 2
    result <- FE_PCA(lhe~LogGDP + Pop65+ Pop14, pdata, nobs, neq, effect="individual")
    factor.dim <- result$factor.dim
    cat("number of factors: ", factor.dim, "\n")
    coeftable[2:4, 11]<-round(result$model$coefficients, 2)
    ci <- confint(result$model, level = 0.95)
    citable[2:4,11] <- apply(round(ci, 2), 1, paste0, collapse =",")
    RMSE <- c(RMSE, round(sqrt(mean(result$model$residuals^2)), 3))
    #IFE 3
    result <- FE_PCA(lhe~LogGDP + Pop65+ Pop14+Gov, pdata, nobs, neq, effect="individual")
    factor.dim <- result$factor.dim
    cat("number of factors: ", factor.dim, "\n")
    coeftable[2:5, 12]<-round(result$model$coefficients, 2)
    ci <- confint(result$model, level = 0.95)
    citable[2:5,12] <- apply(round(ci, 2), 1, paste0, collapse =",")
    RMSE <- c(RMSE, round(sqrt(mean(result$model$residuals^2)), 3))
    totaltable <- NULL
    for (j in 1:(nrow(coeftable)))
      totaltable <-rbind(totaltable,round(coeftable[j,],2), paste0("(",citable[j,], ")"))
    #totaltable <-rbind(totaltable, round(coeftable[j+1,], 2))
    rownames(totaltable) <- c(1:nrow(totaltable))
    rownames(totaltable)[seq(1, 9, by = 2)] <- c("intercept", "$lgdp$", "$pop65$", "$pop14$", "$public$")
    colnames(totaltable)<- c("Between", "Between","Between", "FE", "FE", "FE", "RE", "RE","RE","IFE","IFE",  "IFE")
    totaltable <-rbind(totaltable, as.numeric(RMSE))
    rownames(totaltable)[11] <- "RMSE"
    cat("\n--------", zone, "----------\n")
    print(xtable(totaltable))
    cat ("Press [enter] to continue")
    line <- readline()
    
  }
  