library(xtable)
library(urca)
library(plm)

Table1<- function(zone ="OECD")
{
  #zone can be "OECD" or "Eurozone"
  x.axis <- 1995:2014
  rejection.final <- NULL
  for (zone in c("Eurozone", "OECD"))
  {
    data.orig <- read.table(paste0(zone, ".csv"), h=T, sep=",")
    data.plm <-pdata.frame(data.orig, index = c("country", "year"))
    countries <- levels(as.factor(data.orig$country))
    neq <- length(countries)
    nobs <- nrow(data.orig)/neq
    variables <- matrix(NA, nrow = nobs, ncol = 5)
    var.names <- c("lhe", "LogGDP", "Pop65", "Pop14", "Gov")
    r <- length(var.names)
    rejection.partial <- NULL
    for (j in 1:r)
    {
      reject1 = reject2 = reject3 <- 0

      for (i in 1:neq)
      {
        lags = 1
        index <- which(data.orig$country == countries[i])
        variable<- data.orig[index, var.names[j]]
        reject1 <- reject1 + (attributes(ur.df(variable, lags=lags, type ="none"))$teststat[1] < -1.95)
        reject2 <- reject2 + (attributes(ur.df(variable, lags=lags, type ="drift"))$teststat[1] < -3)
        reject3 <- reject3 + (attributes(ur.df(variable, lags=lags, type ="trend"))$teststat[1]< -3.24)
        
      }
      rejection.partial <- rbind(rejection.partial, c(reject2, reject3)*100/neq)
      #panel data unit root test
      #Pesaran MH (2007). A simple panel unit root test in the presence of 
      #cross-section dependence. Journal of Applied Econometrics, 22(2), 265-312.
      reject2<-cipstest(data.plm[,var.names[j]], type ="drift", pmax = 15)$p.value
      reject3<- cipstest(data.plm[,var.names[j]], type ="trend", pmax = 1)$p.value
      rejection.partial <- rbind(rejection.partial, c(reject2, reject3))
      
    }
    rejection.final <- cbind(rejection.final, rejection.partial) 
  }
  colnames(rejection.final) <- rep(c("Drift", "Drift + trend"), 2)
  rownames(rejection.final)<- c("lhe", "PSI p-value", "lgdp", "PSI p-value", "pop65", 
                                "PSI p-value", "pop14", "PSI p-value", "public", "PSI p-value")
  print(xtable(rejection.final, digits =2))
  
  
}
