tvFE_PCA<-function(X, Y, h,alpha, nobs, neq, nvar, factor.dim, tkernel="Epa")
{
  result <- tvFE(X, Y, h, alpha, nobs, neq, nvar, tkernel)
  beta1 <- result$tvcoef
  error <- matrix (result$resid, nrow = nobs, ncol = neq)
  fpca.fit.obj <- phtt:::fpca.fit(error)
  if(is.null(factor.dim))
    factor.dim <- as.numeric(phtt::OptDim(error, criteria = "ER")$summary)
  factors <- fpca.fit.obj$factors[, 1:factor.dim]
  lambda <- fpca.fit.obj$loadings[, 1:factor.dim]
  tol = 0.001
  iter_max = 100
  distance = tol + 1
  iter <- 0
  beta1 <- matrix(0, nrow=nobs, ncol=nvar)
  Ynew <- Y
  nfactors <- factor.dim
  while (iter < iter_max && distance> tol)
  {
    beta.hat <- beta1
    Ynew <- Y - as.vector(tcrossprod(factors, lambda))
    result <- tvFE(X, Ynew, h, alpha, nobs, neq, nvar, tkernel)
    beta1 <- result$tvcoef
    error <- matrix (Y -result$fitted, nrow = nobs, ncol = neq)
    fpca.fit.obj <- phtt:::fpca.fit(error)
    factors <- fpca.fit.obj$factors[, 1:factor.dim]
    lambda <- fpca.fit.obj$loadings[, 1:factor.dim]
    distance <- mean(((beta1 - beta.hat)/beta1)^2)
    iter <- iter + 1
  }
  return(list(fitted = result$fitted, tvcoef = beta1, 
              resid = Y-result$fitted, alpha.hat = result$alpha.hat, 
              factors = factors, lambda = lambda, factor.dim = factor.dim))
}

OLS_PCA<-function(formula, pdata, index, nobs, neq, nfactors)
{
  nfactors <- min(nfactors, neq)
  POLS <- plm (formula , data =pdata, index=index, model ="pooling")
  error <- matrix (POLS$residuals, nrow = nobs, ncol = neq)
  cov.mat <- tcrossprod(error)/(neq*nobs)
  result <- eigen(cov.mat, symmetric = TRUE)
  factors <- result$vectors[, 1:nfactors]*sqrt(nobs)
  lambda <- t(error)%*%factors/T
   
  fpca.fit.obj <- phtt:::fpca.fit(error)
  factors <- fpca.fit.obj$factors[, 1:nfactors]
  lambda <- fpca.fit.obj$loadings[, 1:nfactors]
  tol = 0.0001
  iter_max <- 100
  distance <- tol + 1
  iter <- 0
  beta1 <- 0
  lhe.orig <- pdata[, "lhe"]
  while (iter < iter_max && distance> tol)
  {
    beta.hat <- beta1
    pdata$lhe <- lhe.orig - as.vector(tcrossprod(factors, lambda))
    result <- plm (formula , data=pdata, model ="pooling")
    beta1 <- result$coef
    resid <- lhe.orig - fitted(result)
    error <- matrix (resid, nrow = nobs, ncol = neq)
    fpca.fit.obj <- phtt:::fpca.fit(error)
    factors <- fpca.fit.obj$factors[, 1:nfactors]
    lambda <- fpca.fit.obj$loadings[, 1:nfactors]
    distance <- mean(((beta1 - beta.hat)/beta1)^2)
    iter <- iter + 1
  }
  result$coefficients <- beta1
  fitted = fitted(result) 
  result$fitted <- fitted #no factor term because it is not needed in Step 2 
  result$residuals <- lhe.orig - fitted
  return(list(model =result, 
              factors = factors, lambda = lambda, 
              factor.dim = nfactors))
  
}


FE_PCA<-function(formula, pdata, nobs, neq, effect = "individual")
{
 # FE <- plm (lhe~ 0+ lgdp + Pop65 + Pop14 +  public, data =pdata, 
 #              model ="within", effect="individual")

  FE <- plm (formula , data =pdata, 
             model ="within", effect=effect)
  error <- matrix (FE$residuals, nrow = nobs, ncol = neq)
  fpca.fit.obj <- phtt:::fpca.fit(error)
  factor.dim<- as.numeric(phtt::OptDim(error, criteria = "ER")$summary)
  factors <- fpca.fit.obj$factors[, 1:factor.dim]
  lambda <- fpca.fit.obj$loadings[, 1:factor.dim]
  tol = 0.001
  iter_max <- 100
  distance <- tol + 1
  iter <- 0
  beta1 <- 0
  lhe.orig <- pdata[, "lhe"]
  nfactors <- factor.dim
  while (iter < iter_max && distance> tol)
  {
    beta.hat <- beta1
    pdata$lhe <- lhe.orig - as.vector(tcrossprod(factors, lambda))
    result <- plm (formula , data=pdata, 
                   model ="within", effect="individual")
    beta1 <- result$coef
    resid <- lhe.orig - fitted(result)
    error <- matrix (resid, nrow = nobs, ncol = neq)
    fpca.fit.obj <- phtt:::fpca.fit(error)
    if(is.null(factor.dim) && iter == 0)
      nfactors <- as.numeric(phtt::OptDim(error, criteria = "ER")$summary)
    factors <- fpca.fit.obj$factors[, 1:nfactors]
    lambda <- fpca.fit.obj$loadings[, 1:nfactors]
    distance <- mean(((beta1 - beta.hat)/beta1)^2)
    iter <- iter + 1
  }
  result$coefficients <- beta1
  fitted = fitted(result) + as.vector(tcrossprod(factors, lambda))
  result$fitted <- fitted
  result$residuals <- lhe.orig - fitted
  return(list(model =result, 
              factors = factors, lambda = lambda, 
              factor.dim = nfactors))
  
}

tvPOLS_PCA <- function(X, Y, h, nobs, neq, nvar, factor.dim = NULL,
         tkernel="Epa")
{
  result <- tvPOLS(X, Y, h, nobs, neq, nvar, tkernel)
  beta1 <- result$tvcoef
  error <- matrix (result$resid, nrow = nobs, ncol = neq)
  fpca.fit.obj <- phtt:::fpca.fit(error)
  if(is.null(factor.dim))
    factor.dim <- factor.dimension(error, h, tkernel)
  factors <- fpca.fit.obj$factors[, 1:factor.dim]
  lambda <- fpca.fit.obj$loadings[, 1:factor.dim]
  tol = 0.001
  iter_max = 100
  distance = tol + 1
  iter <- 1
  while (iter < iter_max && distance > tol)
  {
    beta.hat <- beta1
    Ynew <- Y - as.vector(tcrossprod(factors, lambda))
    result <- tvPOLS(X, Ynew, h, nobs, neq, nvar, tkernel)
    beta1 <- result$tvcoef
    error <- matrix (Y - result$fitted, nrow = nobs, ncol = neq)
    fpca.fit.obj <- phtt:::fpca.fit(error)
    factors <- fpca.fit.obj$factors[, 1:factor.dim]
    lambda <- fpca.fit.obj$loadings[, 1:factor.dim]
    distance <- mean(((beta1 - beta.hat)/beta1)^2)
    iter <- iter + 1
  }
  fitted = result$fitted + as.vector(tcrossprod(factors,lambda))
  return(list(fitted = fitted, tvcoef = beta1, 
              resid = Y-fitted, 
              factors = factors, lambda = lambda, 
              factor.dim = factor.dim))
}

tvPOLS_PCA.cv<-function(h,X, Y, block = 0, nobs, neq, nvar, tkernel="Epa")
{
  X <- as.data.frame(X)
  if (sum(names(X)%in%c("ind", "time"))>0)
    X2 <- as.matrix(X[, -which(names(X) %in% c("ind", "time"))])
  else
    X2 <- as.matrix(X)
  fitted <- numeric(nobs*neq)
  grid <- (1:nobs)/nobs
  Xnew <- X2
  Ynew <- Y
  beta1 <- matrix(0, nrow=nobs, ncol=nvar)
  for (t in 1:nobs)
  {
    k.temp <- Kernel(grid - grid[t], h, type = tkernel)
    k.temp[max(1, (t-block)):min((t+block), nobs)] <- 0
    if(grid[t]<h)
      k.temp <-k.temp/integrate(Epanechnikov, lower = -grid[t]/h, upper = 1)$value
    else if (grid[t]> (1-h))
      k.temp <-k.temp/integrate(Epanechnikov, lower = -1, upper = (1-grid[t])/h)$value
    k.temp <- sqrt(k.temp)
    if (sum(k.temp != 0) < 3)
      return (.Machine$double.xmax)
    for (i in 1:neq)
    {
      ind <- (i-1)*nobs + (1:nobs)
      Xnew[ind, ] <- X2[ind,] * k.temp
      Ynew[ind] <- Y[ind] * k.temp
    }
    beta1[t,]<-solve(crossprod(Xnew))%*%crossprod(Xnew, Ynew)
    for (i in 1:neq)
      fitted[t+(i-1)*nobs] <- sum(X2[t+(i-1)*nobs,]*beta1[t,])
  }
  resid <- Y - fitted
  error <- matrix (resid, nrow = nobs, ncol = neq)
  fpca.fit.obj <- phtt:::fpca.fit(error)
  
  factor.dim <- factor.dimension(error, h, tkernel)
  
  factors <- fpca.fit.obj$factors[, 1:factor.dim]
  lambda <- fpca.fit.obj$loadings[, 1:factor.dim]
  tol = 0.001
  iter_max = 100
  distance = tol + 1
  iter <- 1
  while (iter < iter_max && distance > tol)
  {
    beta.hat <- beta1
    Ynew <- Y - as.vector(tcrossprod(factors, lambda))
    for (t in 1:nobs)
    {
      k.temp <- Kernel(grid - grid[t], h, type = tkernel)
      k.temp[max(1, (t-block)):min((t+block), nobs)] <- 0
      if(grid[t]<h)
        k.temp <-k.temp/integrate(Epanechnikov, lower = -grid[t]/h, upper = 1)$value
      else if (grid[t]> (1-h))
        k.temp <-k.temp/integrate(Epanechnikov, lower = -1, upper = (1-grid[t])/h)$value
      k.temp <- sqrt(k.temp)
      if (sum(k.temp != 0) < 3)
        return (.Machine$double.xmax)
      for (i in 1:neq)
      {
        ind <- (i-1)*nobs + (1:nobs)
        Xnew[ind, ] <- X2[ind,] * k.temp
        Ynew[ind] <- Y[ind] * k.temp
      }
      beta1[t,]<-solve(crossprod(Xnew))%*%crossprod(Xnew, Ynew)
      for (i in 1:neq)
        fitted[t+(i-1)*nobs] <- sum(X2[t+(i-1)*nobs,]*beta1[t,])
    }
    resid <- Y - fitted
    error <- matrix (resid, nrow = nobs, ncol = neq)
    fpca.fit.obj <- phtt:::fpca.fit(error)
    factors <- fpca.fit.obj$factors[, 1:factor.dim]
    lambda <- fpca.fit.obj$loadings[, 1:factor.dim]
    distance <- mean(((beta1 - beta.hat)/beta1)^2)
    iter <- iter + 1
  }
  resid <- resid 
  return(mean(resid^2))
}

factor.dimension<-function(error, h, tkernel = "Epa")
{
  fpca.fit.obj <- phtt:::fpca.fit(error)
  nobs <- NROW(error)
  neq <- NCOL(error)
  grid <- (1:nobs)/nobs
  rmax <- 0
  for (t in grid)
  {
    k.temp <- sqrt(Kernel(grid - t, h, type = "Epa"))
    k.index <- which(k.temp!=0)
    W.tilde <- diag(neq)%x%diag(k.temp[k.index])
    Sigma.tilde <-0
    eta0 <-0
    for(i in 1:neq)
    {
      Sigma.tilde<- Sigma.tilde + tcrossprod(error[,i]*k.temp)
      eta0 <- eta0 + crossprod(error[,i]*k.temp)
    }
    Sigma.tilde <- Sigma.tilde/neq
    eta0 <- eta0/neq
    epsilon <- 1/log(max(eta0, neq))
    fpca<-eigen(Sigma.tilde)
    eta <- c(eta0/neq , fpca$values[fpca$values !=0])
    J <- length(eta) -1
    b <-(eta[-1]/eta[-J] )*((eta[-J]/eta[1])>=epsilon) + ((eta[-J]/eta[1])<epsilon)
    r <- which.min(b)
    rmax <- max(rmax, r)
  }
  return(rmax)
}