data<-read.table("./OECD_factorproxy.csv", sep =",", h =TRUE)
year <- data$year
phar <- data$Phar_spending
Life <- data$Life_expectancy_atbirth
par(mfrow = c(1, 1), mar = c(4, 4, 2, 4), oma = c(0, 0, 0, 0), lwd = 2, cex = 1.5)
plot(year, phar, type ="l", xlab="", ylab ="Pharmaceutical spending",xaxt ="n") 
axis(side = 1, at = seq(1995, 2014, by = 2))
par(new =T)
plot(year, Life, yaxt= "n", type ="l", lty =2, col = 1, xlab ="",
     bty = "n",ylab ="", xaxt ="n" )
axis(side = 4, col.ticks = 1, col.axis = 1)
mtext(side = 4, line = 2, 'Life expectancy at birth', cex = 1.5, col = 1)
mtext(text = "year", side = 1, line = 2, cex = 1)
legend("bottomright", c("Pharma spending", "Life exp. birth"), lty =1:2, col = 1, bty= "n", cex = 0.8)
