oecd <- read.table("OECD.csv", sep =",", h=T)
euro<-read.table("Eurozone.csv", sep =",", h=T)
par(mar = c(4, 4, 2,4), oma = c(0, 0, 0, 0), lwd = 2,cex =1.5)
x.axis <- 1995:2014
LHE <- apply( matrix(euro$lhe, nrow = length(x.axis), byrow=FALSE), 1, mean)
LGDP <- apply( matrix(euro$LogGDP, nrow = length(x.axis), byrow=FALSE), 1, mean)
LHE2 <- apply( matrix(oecd$lhe, nrow = length(x.axis), byrow=FALSE), 1, mean)
LGDP2 <- apply( matrix(oecd$LogGDP, nrow = length(x.axis), byrow=FALSE), 1, mean)
plot(x.axis, LHE, type ="l", ylim= range(LHE, LHE2), ylab ="Average log-health expenditure", main="Eurozone",
     xlab ="",xaxt ="n") 
axis(side = 1, at = seq(1994,2014, by =2))
mtext(text = "year", side = 1, line = 2, cex = 1)
par(new = TRUE)
plot(x.axis, LGDP, type ="l", ylim = range(LGDP, LGDP2),
     axes = FALSE, bty = "n", xlab ="", ylab ="", lty = 2, col = 1)
axis(side = 4, at = pretty(LGDP2), col.axis = 1, col.ticks = 1)
mtext("Average log-GDP",side=4, line = 2.5, col = 1, cex = 1.5) 
legend("bottomright", c("log-HCE", "log-GDP"), col = 1, lty = 1:2, bty = "n", cex = 0.8)

plot(x.axis, LHE2, type ="l", ylim= range(LHE, LHE2), ylab ="Average log-health expenditure", main ="OECD",
     xlab ="", xaxt ="n")
axis(side = 1, at = seq(1994,2014, by =2))
par(new = TRUE)
plot(x.axis, LGDP2, type ="l", ylim = range(LGDP, LGDP2),
     axes = FALSE, bty = "n", xlab ="", ylab ="", lty = 2, col = 1)
lines(x.axis, oecd$lgdp[oecd$country ==levels(oecd$country)[34]], col =6)
axis(side = 4, at = pretty(LGDP2), col.axis = 1, col.ticks = 1)
mtext("Average log-GDP",side=4, line = 2.5, col = 1, cex = 1.5) 
mtext(text = "year", side = 1, line = 2, cex = 1)
legend("bottomright", c("log-HCE", "log-GDP"), col = 1, lty = 1:2, bty = "n", cex =0.8 )
