
%% compute largest roots (stock 91)

medRhoData=zeros(n,1);
medRhoCom=zeros(n,1);
medRhoIdio=zeros(n,1);

ICRhoData=zeros(4,2,n);
ICRhoCom=zeros(4,2,n);
ICRhoIdio=zeros(4,2,n);

for j=1:n
    [medRhoData(j),ICRhoData(:,:,j)]=largestARrootStock91(Y_actual(j,:));
    [medRhoCom(j),ICRhoCom(:,:,j)]=largestARrootStock91(mY_ComComp(j,:));
    [medRhoIdio(j),ICRhoIdio(:,:,j)]=largestARrootStock91(mY_Idio(j,:));
end


ICRhoData95=flip(reshape(ICRhoData(1,:,:),[2,n])',2);
ICRhoCom95=flip(reshape(ICRhoCom(1,:,:),[2,n])',2);
ICRhoIdio95=flip(reshape(ICRhoIdio(1,:,:),[2,n])',2);


ICRhoData90=flip(reshape(ICRhoData(2,:,:),[2,n])',2);
ICRhoCom90=flip(reshape(ICRhoCom(2,:,:),[2,n])',2);
ICRhoIdio90=flip(reshape(ICRhoIdio(2,:,:),[2,n])',2);


[medRhoFactor,ICRhoFactor]=largestARrootStock91(mfactor);
ICRhoFactor95=flip(ICRhoFactor(1,:));
ICRhoFactor90=flip(ICRhoFactor(2,:));


%% graph settings
usedfont='Garamond';
fontaxsize=10;
qualitystr='-r200';

b_savefig=true;
FigW=16; FigH=20;

LegendaDesc={'Actual','Common','Individual','Factor'};

%% barre verticali con mediana

figure
set(gcf,'color', 'white',...
    'PaperUnits','centimeters','PaperSize',[FigW FigH],...
    'PaperPosition',[0,0,FigW,FigH],'PaperPositionMode','manual',...
    'Units','normalized',...
    'OuterPosition',[0,0,1,1]);

rhobar=bar([medRhoData,medRhoCom,medRhoIdio],1,'EdgeColor','none');
set(rhobar(1),'facecolor','g')
set(rhobar(2),'facecolor','r')
set(rhobar(3),'facecolor','b')
alpha(0.6)
hold on
plot([0,n+1],largestARrootStock91(mfactor)*[1,1],'k','LineWidth',3)

%colormap(gcf,'prism')
grid on
set(gca,'xtick',1:n,'xticklabel',short_desc,'XTickLabelRotation',90)
axis([0 n+1 0 1.05])
legend(LegendaDesc,'Location','SouthOutside','Orientation','Horizontal','Box','off')

strtitle='Largest AR root';
set(gca,'fontname',usedfont,'fontsize',fontaxsize)
title(strtitle,'fontname',usedfont,'fontsize',fontaxsize)

if b_savefig
    print('-dpng',qualitystr,'./figures/Stock91_persistence_MedianBar.png')
end


%% aree con intervallo 95%
FigW=16; FigH=20;
figure
set(gcf,'color', 'white',...
    'PaperUnits','centimeters','PaperSize',[FigW FigH],...
    'PaperPosition',[0,0,FigW,FigH],'PaperPositionMode','manual',...
    'Units','normalized',...
    'OuterPosition',[0,0,1,1]);


for j=1:n
    subaxis(5,4,j,'Margin',.05,'MarginTop',0.08,'MarginBottom',0.08,'SpacingVertical',0.08,'SpacingHorizontal',0.04);
    
    fill([ICRhoData95(j,:),flip(ICRhoData95(j,:))]',[1,1,2,2],'g','EdgeColor','none'); hold on
    fill([ICRhoCom95(j,:),flip(ICRhoCom95(j,:))]',1+[1,1,2,2],'r','EdgeColor','none'); hold on
    fill([ICRhoIdio95(j,:),flip(ICRhoIdio95(j,:))]',2+[1,1,2,2],'b','EdgeColor','none'); hold on
    fill([ICRhoFactor95,flip(ICRhoFactor95)]',3+[1,1,2,2],'k','EdgeColor','none'); hold on
    alpha(0.6)
    
    grid on
    
    axis([0.75,1.05,1,5])
    set(gca,'xtick',0.75:0.05:1,'ytick',[],'XTickLabelRotation',90)
    
    
    strtitle=short_desc{j};
    set(gca,'fontname',usedfont,'fontsize',fontaxsize)
    title(strtitle,'fontname',usedfont,'fontsize',fontaxsize)
    
    
    if j>=n
        legend(LegendaDesc,'Position',[0.45,0.95,0.1,0.05],'Orientation','Horizontal','Box','off')
    end
    
    
    
    
end

if b_savefig
    print('-dpng',qualitystr,'./figures/Stock91_persistence_IC95.png')
end

%%



%% aree con intervallo 90%
FigW=16; FigH=20;
figure
set(gcf,'color', 'white',...
    'PaperUnits','centimeters','PaperSize',[FigW FigH],...
    'PaperPosition',[0,0,FigW,FigH],'PaperPositionMode','manual',...
    'Units','normalized',...
    'OuterPosition',[0,0,1,1]);


for j=1:n
    
    subaxis(5,4,j,'Margin',.05,'MarginTop',0.08,'MarginBottom',0.08,'SpacingVertical',0.08,'SpacingHorizontal',0.04);
    
    
    fill([ICRhoData90(j,:),flip(ICRhoData90(j,:))]',[1,1,2,2],'g','EdgeColor','none'); hold on
    fill([ICRhoCom90(j,:),flip(ICRhoCom90(j,:))]',1+[1,1,2,2],'r','EdgeColor','none'); hold on
    fill([ICRhoIdio90(j,:),flip(ICRhoIdio90(j,:))]',2+[1,1,2,2],'b','EdgeColor','none'); hold on
    fill([ICRhoFactor90,flip(ICRhoFactor90)]',3+[1,1,2,2],'k','EdgeColor','none'); hold on
    alpha(0.6)
    
    grid on
    
    
    axis([0.75,1.05,1,5]);  set(gca,'xtick',0.75:0.05:1,'ytick',[],'XTickLabelRotation',90)
    
    strtitle=short_desc{j};
    set(gca,'fontname',usedfont,'fontsize',fontaxsize)
    title(strtitle,'fontname',usedfont,'fontsize',fontaxsize)
    
    if j>=n
        legend(LegendaDesc,'Position',[0.45,0.95,0.1,0.05],'Orientation','Horizontal','Box','off')
    end
    
    
end


if b_savefig
    print('-dpng',qualitystr,'./figures/Stock91_persistence_IC90.png')
end
