function logp = mvtLogpdf(X, MU, P, Q, v)
% Matricvariate student t distribution, log pdf

% typically Q is the error variance
[p q] = size(X);
lnkapt = 0.5*q*p*log(pi) -0.5*q*log(det(P))-0.5*v*log(det(Q)); 
%%Dickey version, Karlsson uses 0.5*p*log(det(Q))
for i = 1:q
lnkapt = lnkapt+gammaln(0.5*(v+1-i))-gammaln(0.5*(v+1-i+p));  
end
logp  = -lnkapt  - 0.5*(p+v)*log(det(Q+(X-MU)'*P*(X-MU)));
