% code used with permission from Joslin Singleton and Zhu (2011)
% Title of publication in reference - A New Perspective on Gaussian
%                                   Dynamic Term Structure Models
% Authors - Scott Joslin MIT Sloan
%         - Kenneth J Singleton Standford GSB
%         - Haoxiang Zhu Stanford GSB
% Date of publication - 2011
% Journal - Reviwe of Financial Studies 24, pg 926-970
% DOI - 10.1093/rfs/hhq128

function W = jszWeightsFromMats(mats_woe, mats)
% function W = jszWeightsFromMats(mats_woe, mats);
%
% This is an easy way to generate the weighting matrix when we measure
% specific yields without error.
%
% For example:
% mats_woe = [1,5];
% mats = [1:5}
% gives:
%       [1,0,0,0,0;
%        0,0,0,0,1]
% 

inds = ismember(mats, mats_woe);
if ~(sum(inds)==length(mats_woe))
    error('Some of the maturities without error arent in the original maturities');
end
J = length(mats);
W = eye(J);
W = W(inds,:);