********************* RATS program, from 
********************* Carriero, Clark, and Marcellino, "Assessing International Commonality in Macroeconomic Uncertainty 
********************* and Its Effects," Journal of Applied Econometrics
********************* estimating BVAR-GFSV model with quarterly data on GDP growth in 19 countries
********************* 

dis %dateandtime()
dis %ratsversion()

*********************
********************* BASIC SETUP & PARAMETER ENTRY
*********************
comp ndraws = 5000                     ;* # of draws retained
comp burnindraws = 10000                ;* # of draws burned
comp skipint = 5                      ;* save only every 20th draw of MCMC (out of skipint*ndraws)
comp nparticle = 50

/*
comp ndraws = 200                     ;* # of draws retained
comp burnindraws = 50                ;* # of draws burned
comp skipint = 1                      ;* save only every 20th draw of MCMC (out of skipint*ndraws)
comp nparticle = 25
*/

comp styr = 1960
comp freq = 4
if freq==12
 cal(m) styr:1
else
 cal(q) styr:1
endif
comp stsmpl = styr:1	;*earliest period with data
comp endsmpl = 2016:4      ;* last data observation (will use same data sample as for other models)

comp nvar = 19	;* number of variables in the VAR
comp nfact = 1  ;* number of common volatility factors in the model
comp fixlags = 2	;* fixed lag order to use in VAR

all endsmpl
smpl stsmpl endsmpl

comp seedval = 3000
seed seedval
dis seedval

grparm(bold) header 14 subheader 12
grparm axislabeling 24
env nowshowgraphs
comp modeldesc = "BVAR-GFSV model, OECD GDP growth data for 19 countries"
gsave(format=pdf) "GFSV_19countries_*.pdf"

*********************
********************* READING IN DATA and determining available sample
*********************
open data data/GDP_OECD.xls
data(format=xls,org=col) / US Australia Austria Belgium Canada Denmark Finland France Germany Italy Japan Luxembourg Netherlands Norway Portugal Spain Sweden Switzerland UK
close

comp basestsmpl = stsmpl
do i = 1,nvar
 inquire(series=i) stpt endpt
 comp nobs = endpt-stpt+1
 dis %l(i) @15 %datelabel(stpt) %datelabel(endpt)
 stats(noprint) i
 if %nobs<>nobs
  dis 'missing obs = ' (nobs-%nobs)
 comp basestsmpl = %imax(basestsmpl,stpt)
 comp endsmpl = %imin(endsmpl,endpt)
end do i

dis %datelabel(basestsmpl) %datelabel(endsmpl)

dec vec[ser] y(nvar)
dec vec[int] transvec(nvar)
dec vec[str] varlabel(nvar+nfact)
comp varlabel(nvar+1) = "log uncertainty factor 1"

*** set of data vector and convert simple percent changes to log growth rates, which is what we will use
smpl basestsmpl endsmpl
do i = 1,nvar
 comp transvec(i) = 5
 comp varlabel(i) = %l(i)
 set(first=1.) ylevel basestsmpl-1 endsmpl = ylevel{1}*(1.+.01*i{0})
 set y(i) = 100.*log(ylevel{0}/ylevel{1})
end do i

** outlier screening
do i = 1,nvar
 dis ""
 dis "**************************** " varlabel(i)
 stats(fractiles,noprint) y(i)
 comp iqr = %fract75-%fract25
 comp lower = %median - 6.*iqr
 comp upper = %median + 6.*iqr
 set outlier = (y(i)(t).gt.upper).or.(y(i)(t).lt.lower)
 do vtime = basestsmpl,endsmpl
  if outlier(vtime)>0
   {
    dis "outlier in " %datelabel(vtime)
    dis "old value = " y(i)(vtime)
    if y(i)(vtime).gt.upper
     comp y(i)(vtime) = upper
    else if y(i)(vtime).lt.lower
     comp y(i)(vtime) = lower
    dis "new value = " y(i)(vtime)
   }
 end do vtime
end do i

********************************
******************************** stuff for estimation
********************************
sou(noecho) procedures/BVARGFSV.GFSV.src
sou(noecho) procedures/impresp.GFSV.src

******** prior means of first lag of dep variable in each equation (basic intention is to push VAR towards AR(1) models with coef of 0)
comp [vec] bvarprior = %fill(nvar,1,0.0)  ;* default prior mean is 0.0
comp [vec] shrinkage = ||.1,0.5,1.,10.,10.,0.5|| ;* overall tightness, relative weight on other lags, decay on lag
                                                  * elements 4 and 5 control coef on f(t) and f(t-1), respectively
                                                  * element 6 is prior variance on elements of A matrix

********* mean and variance of Phi, var-cov matrix of innovations to log stochastic volatility
comp flags = 2                         ;* AR order of log factor process, corresponding to length of lags included in VAR's conditional mean

comp [vec] muphiH = %fill(nvar,1,0.03)
comp priordfPhiH = 15
comp fshockvar = 0.03   ;* fixed variance of innovations to factor vols

dec symm OmegastateH0(nvar,nvar)
comp OmegastateH0 = %mscalar(2.0)

dec vec[vec] load_prmean(nvar) psiH_prmean(nvar)  psiF_prmean(nfact)
dec vec[symm]  load_prvar(nvar) psiH_prvar(nvar) psiF_prvar(nfact)

do i = 1,nvar
 ** prior mean and variance for factor loadings
 comp load_prmean(i) = %fill(nfact,1,1.0)
 comp load_prvar(i) = 0.5^2.*%identity(nfact)
 ** prior mean and variance for AR coefs of idiosyn. processes
 comp psiH_prmean(i) = ||0.0, 0.0||
 comp psiH_prvar(i) = ||2.|  0.0, 0.5^2.||
end do i

comp nfcoef = flags+nvar
do i = 1,nfact
 comp psiF_prmean(i) = 0.9*%unitv(nfcoef,1)
 comp psiF_prvar(i) = 0.4^2.*%identity(nfcoef)   ;* prior variance for all coefs. of factor process (lagged y and lagged factor)
 dis ""
 do l = 1,flags
  comp psiF_prvar(i)(l,l) = 0.2^2.         ;* tighter variance for lagged factor coefs of factor process
 end do l
end do i

dec rec[int] loadrestrictions(nvar,2)  ;* indicators of which variables are used to impose sign restrictions on factors.  1 or 0 in first col, factor number in second col
do i = 1,nvar
 comp loadrestrictions(i,1)=0, loadrestrictions(i,2)=0
end do i
comp loadrestrictions(1,1)=1, loadrestrictions(1,2)=1        ;* first factor

******************************** define sample and
******************************** set initial values needed
******************************** and then standardize data
comp basestsmpl = 1985:1   ;* basestsmpl+fixlags
smpl basestsmpl endsmpl
dis %datelabel(basestsmpl) %datelabel(endsmpl)

comp [vec] keepscales = %fill(nvar,1,1.0)
do i = 1,nvar
 stats(noprint) y(i)
 set(scratch) y(i) basestsmpl-fixlags endsmpl = (y(i){0}-%mean)/%variance^0.5
 comp keepscales(i) = %variance^0.5
end do i

********************************
******************************** setting up other initial stuff
********************************
smpl basestsmpl endsmpl

*** log lambda for idiosyn processes
comp [vec] lnlambdainp = %zeros(nvar,1)
dec vec[ser] Aresids(nvar)
do i = 1,nvar
  linreg(noprint) y(i) basestsmpl endsmpl Aresids(i)
  # constant y(i){1 to fixlags}
  sstats(mean) / Aresids(i){0}**2.>>lnlambdainp(i)
  comp lnlambdainp(i) = log(0.7*lnlambdainp(i))
  comp psiH_prmean(i)(1) = lnlambdainp(i)
end do i

*** initial factors
dec vec[ser] initialfactor(nfact)
do i = 1,nfact
 set initialfactor(i) stsmpl endsmpl = 1.0
end do i

* US
comp varno = 1
comp pos = 1
linreg(noprint) Aresids(varno)
# constant
garch(p=1,q=1,regressors,presample=||%seesq||,hser=garchvar) / Aresids(varno)
# constant
log garchvar / logvar
diff(center) logvar / loginitialfactor
set initialfactor(pos) = exp(loginitialfactor{0})
stats initialfactor(pos)

do i = 1,nvar
  dis i @5 varlabel(i) @25 psiH_prmean(i)(1) lnlambdainp(i)
end do i

********************************
******************************** model estimation
********************************
comp starttime = %cputime()
@modelestimation(prmean,lnlambdainp=lnlambdainp,noinclconst,npart=nparticle) y nfact basestsmpl endsmpl 0 fixlags flags ndraws burnindraws skipint bvarprior shrinkage OmegastateH0 muPhiH priordfPhiH $
 fshockvar load_prmean load_prvar loadrestrictions psiH_prmean psiH_prvar psiF_prmean psiF_prvar initialfactor PiRes ARes loadingRes Psi0Res Psi1Res fcoefres PhiRes factorRes uncertshocks SigmaRes hres LambdaRes stdevRes
dis 'run time in minutes = ' (%cputime()-starttime)/60.

********************************
******************************** write draws of params. and states to files
******************************** set of stuff:  PiRes ARes  loadingRes loading2Res Psi0Res Psi1Res fcoefres PhiRes PhiFRes  factorRes shockres orthoshockres hres LambdaRes
******************************** note: to reduce storage needs, rather than store draws of Sigma(t), we will reconstruct them from the draws of A and Lambda(t)
comp directory = "draws_19countries/"

*** Pi (draws of matrices of VAR coefs)
comp thisroot = 'Pi'
comp filename = directory+thisroot+'.prn'
open copy &filename
write(unit=copy,for='(40F40.20)') PiRes
close copy

*** A (vec(draws) of matrix of A coefs)
comp thisroot = 'A'
comp filename = directory+thisroot+'.prn'
open copy &filename
write(unit=copy,for='(40F30.20)') ARes
close copy

*** loading matrices
comp thisroot = 'loading'
comp filename = directory+thisroot+'.prn'
open copy &filename
write(unit=copy,for='(40F40.20)')  loadingRes
close copy

*** Psi0 (intercepts of idiosyn vols)
comp thisroot = 'Psi0'
comp filename = directory+thisroot+'.prn'
open copy &filename
write(unit=copy,for='(40F40.20)') Psi0Res
close copy

*** Psi1 (AR(1) coefs of idiosyn vols)
comp thisroot = 'Psi1'
comp filename = directory+thisroot+'.prn'
open copy &filename
write(unit=copy,for='(40F40.20)') Psi1Res
close copy

*** factor process coefficients
comp thisroot = 'factorcoef'
comp filename = directory+thisroot+'.prn'
open copy &filename
write(unit=copy,for='(40F40.20)') fcoefres
close copy

*** Phi (var-cov matrix of innovations to idiosyn. vol.)
comp thisroot = 'Phi'
comp filename = directory+thisroot+'.prn'
open copy &filename
write(unit=copy,for='(40F40.20)') PhiRes
close copy

*** vol factors (rec array(draws, nvar) of time series)
comp ndatacol = nfact
do i = 1,ndraws
 do j = 1,ndatacol
  label factorRes(i,j)
  # "factor_"+i+"_"+j
 end do j
end do i
do i = 1,ndatacol
 comp thisroot = 'factor.n'+i
 comp filename = directory+thisroot+'.xls'
 open copy &filename
 copy(org=row,for=xls) / factorRes(1,i) to factorRes(ndraws,i)
 close copy
end do i

*** reduced form shocks to vol factors (rec array(draws, nvar) of time series)
comp ndatacol = nfact
do i = 1,ndraws
 do j = 1,ndatacol
  label uncertshocks(i,j)
  # "shock_"+i+"_"+j
 end do j
end do i
do i = 1,ndatacol
 comp thisroot = 'shock.n'+i
 comp filename = directory+thisroot+'.xls'
 open copy &filename
 copy(org=row,for=xls) / uncertshocks(1,i) to uncertshocks(ndraws,i)
 close copy
end do i

*** idiosyncratic vols (rec array(draws, nvar) of time series)
comp ndatacol = nvar
do i = 1,ndraws
 do j = 1,ndatacol
  label hRes(i,j)
  # "h_"+i+"_"+j
 end do j
end do i
do i = 1,ndatacol
 comp thisroot = 'idiosyn.n'+i
 comp filename = directory+thisroot+'.xls'
 open copy &filename
 copy(org=row,for=xls) / hRes(1,i) to hRes(ndraws,i)
 close copy
end do i

*** lambdas (rec array(draws, nvar) of time series)
comp ndatacol = nvar
do i = 1,ndraws
 do j = 1,ndatacol
  label lambdaRes(i,j)
  # "lambda_"+i+"_"+j
 end do j
end do i
do i = 1,ndatacol
 comp thisroot = 'lambda.n'+i
 comp filename = directory+thisroot+'.xls'
 open copy &filename
 copy(org=row,for=xls) / lambdaRes(1,i) to lambdaRes(ndraws,i)
 close copy
end do i

********************************
******************************** GFSV and idiosyncratic volatility, calculating posterior stats
********************************
dec vec[ser] idiovolmedian(nvar) idiovol15(nvar) idiovol85(nvar) rfvolmedian(nvar) rfvol15(nvar) rfvol85(nvar)
clear(length=endsmpl) idiovolmedian idiovol15 idiovol85 rfvolmedian rfvol15 rfvol85 gfsvmedian gfsv15 gfsv85 gfsv2median gfsv215 gfsv285

smpl 1 ndraws
do vtime = basestsmpl,endsmpl
  do i = 1,nvar
    set(scratch) statser = hRes(t,i)(vtime)^0.5
    comp [vec] frac = %fractiles(statser,||.15,.5,.85||)
    comp idiovolmedian(i)(vtime) = frac(2)
    comp idiovol15(i)(vtime) = frac(1)
    comp idiovol85(i)(vtime) = frac(3)

    set(scratch) statser = stdevRes(t,i)(vtime)
    comp [vec] frac = %fractiles(statser,||.15,.5,.85||)
    comp rfvolmedian(i)(vtime) = frac(2)
    comp rfvol15(i)(vtime) = frac(1)
    comp rfvol85(i)(vtime) = frac(3)
  end do i

  set statser = factorRes(t,1)(vtime)^0.5
  comp [vec] frac = %fractiles(statser,||.15,.5,.85||)
  comp gfsvmedian(vtime) = frac(2)
  comp gfsv15(vtime) = frac(1)
  comp gfsv85(vtime) = frac(3)

end do vtime

**** now write to Excel files:  GFSV estimates and reduced form vols
comp filename = %unitfnroot("input")+".xls"
open copy &filename
copy(dates,org=col,for=xls) basestsmpl endsmpl gfsvmedian gfsv15 gfsv85 rfvolmedian rfvol15 rfvol85  ;* gfsv2median gfsv215 gfsv285 
close copy

********************************
******************************** charts of vols
********************************

comp perpage = 20
comp IRperpage = 20
comp vf = 4
comp hf = 5

comp [vec[string]] mykey_full = ||'median','15%ile','85%ile'||
smpl basestsmpl endsmpl

******************************** reduced-form volatilities
comp header1 = 'Innovation volatility estimate: ' + modeldesc
comp subheader = '(standard deviation)'
do i = 1,nvar,perpage
 grparm(bold) header 14
 spgraph(vfields=vf,hfields=hf,header=header1,subheader=subheader)
 grparm(bold) header 22
 do j = i,%imin(i+perpage-1,nvar)
  comp header = varlabel(j)
  graph(header=header,dates,key=below,klab=mykey_full) 3
  # rfvolmedian(j) / 1
  # rfvol15(j) / 2
  # rfvol85(j) / 2
 end do j
 spgraph(done)
end do i

******************************** uncertainty estimates

*** because this is a 1 by 1 chart, reset some chart fonts to defaults
grparm(bold) header 14
grparm axislabeling 18
comp nlines = 3

comp header = "Uncertainty estimates"
graph(header=header,dates,key=below,klab=||'unc. factor 1^0.5 (left)','15%ile','85%ile'||) nlines
# gfsvmedian / 1
# gfsv15 / 2
# gfsv85 / 2

********************************
******************************** impulse responses, uncertainty shocks (global)
********************************
comp starttime = %cputime()
comp nsteps = 4*freq
dec vec[ser] uncertmedian(nfact)
set uncertmedian(1) basestsmpl endsmpl = log(gfsvmedian{0}^2.)

@impresp(noinclconst,undiff=transvec) y uncertmedian basestsmpl endsmpl fixlags flags ndraws nsteps PiRes Psi1Res fcoefres PhiRes fshockvar SigmaRes simpleIRs

dis 'var decomp calculation run time in minutes = ' (%cputime()-starttime)/60.

dec rec[ser] simIRmedian(nvar+nfact,nfact) simIR15(nvar+nfact,nfact) simIR85(nvar+nfact,nfact)
clear(length=nsteps) simIRmedian simIR15 simIR85

** construct median and credible set:  response to US uncert
smpl 1 ndraws
do vtime = 1,nsteps
 do nn = 1,nfact
  do i = 1,nvar+nfact
    if i<=nvar
     set(scratch) statser = keepscales(i)*simpleIRs(t,(nn-1)*(nvar+nfact)+i)(vtime)
    else
     set(scratch) statser = simpleIRs(t,(nn-1)*(nvar+nfact)+i)(vtime)
    comp [vec] frac = %fractiles(statser,||.15,.5,.85||)
    comp simIRmedian(i,nn)(vtime) = frac(2)
    comp simIR15(i,nn)(vtime) = frac(1)
    comp simIR85(i,nn)(vtime) = frac(3)
  end do i
 end do nn
end do vtime

** make charts
smpl 1 nsteps

do nn = 1,nfact
 comp header = 'Impulse responses to uncertainty shock: factor ' + %string(nn)
 do i = 1,nvar+nfact,IRperpage
  grparm(bold) header 14
  spgraph(vfields=vf,hfields=hf,header=header)
  grparm(bold) header 22
  do j = i,%imin(i+IRperpage-1,nvar+nfact)
   comp header1 = varlabel(j)
   graph(ticks,number=0,ovcount=2,overlay=fan,ovsame,header=header1) 3
   # simirmedian(j,nn) / 1
   # simir15(j,nn) / 2
   # simir85(j,nn) / 2
  end do j
  spgraph(done)
 end do i
end do nn

** write to Excel
smpl 1 nsteps
comp filename = %unitfnroot("input")+".impresp.xls"
open copy &filename
copy(dates,org=col,for=xls) / simIRmedian simIR15 simIR85
close copy
