********************* RATS program, from 
********************* Carriero, Clark, and Marcellino, "Assessing International Commonality in Macroeconomic Uncertainty 
********************* and Its Effects," Journal of Applied Econometrics
********************* Creating Figure 2 after reading in estimates created by other estimation program

comp styr = 1980
cal(q) styr:1
comp stsmpl = styr:1	;*earliest period with data
comp endsmpl = 2016:4   ;* for 19 economy

all endsmpl
smpl stsmpl endsmpl

env noshowgraphs
gsave(format=pdf) "Figure2_*.pdf"

******************************************************* set up Bloom date indicators

*** Bloom 2009 dates, converted to quarterly (only monthly)
clear(zeros,length=endsmpl) bloom crisisperiod
set crisisperiod 2007:3 2008:4 = 1.0
set bloom 1987:4 1987:4 = 1.0
set bloom 1990:3 1990:3 = 1.0
set bloom 2002:3 2002:3 = 1.0
dofor i = 1997:4 1998:3 2001:3 2003:1
 comp bloom(i) = 1.0
end do i

comp [vec[int]] bloomdatevec = ||1987:4,1990:3,1997:4,1998:3,2001:3,2002:3,2003:1,2008:2||
comp [vec[str]] bloomlabels = ||"Black Monday","Gulf War I","Asian Crisis","Russian Crisis","9/11","Enron","Gulf War II","Crisis"||

do i = 1,%rows(bloomdatevec)
 dis %datelabel(bloomdatevec(i)) @10 bloomlabels(i)
end do i

*******************************************************
******************************************************* 19 country GDP case
*******************************************************
smpl stsmpl endsmpl

open data estimatesforfigures/factorcomparison.xlsx
data(format=xlsx,org=col,sheet="19country") / GFSVmedian	GFSV15	GFSV85 pc1
close data
set(scratch) pc1 = sqrt(exp(pc1{0}))   ;* transform PC in line with GFSV median (which is m(t)^0.5 here)
set pc1keep = pc1

comp basestsmpl = stsmpl
comp baseendsmpl = endsmpl
dofor i = gfsvmedian
 inquire(series=i) stpt endpt
 comp basestsmpl = %imax(basestsmpl,stpt)
 comp baseendsmpl = %imin(baseendsmpl,endpt)
end do i
dis %datelabel(basestsmpl) %datelabel(baseendsmpl)
smpl basestsmpl baseendsmpl

*********************
********************* simple correlations
*********************

cmom(corr,print)
# GFSVmedian pc1
dis(store=string1) "correlation = " #.### %cmom(2,1)

*********************
********************* charts with Bloom dates
*********************

*** from single factor model, with PC of BVAR-SV lambdas added
comp nlines = 4
spgraph(vfields=1,hfields=1)
set statser = GFSV85
graph(dates,grid=bloom,key=below,klab=||'uncertainty factor m(t)^0.5','PC of BVAR-SV','15%ile','85%ile'||,ovcount=2,overlay=fan,ovsame,shading=crisisperiod) nlines  ;*
# GFSVmedian / 1
# pc1 / 2
# GFSV15 / 8
# GFSV85 / 8
extremum(noprint) statser
stats(noprint) statser
comp units = %variance^0.5/2.
do j = 1,%rows(bloomdatevec)
 comp ypos = %maximum - %mod(j-1,3)*units
 grtext(bold,entry=bloomdatevec(j),y=ypos,valignment=top,size=14) bloomlabels(j)
end do j
grtext(position=upright,bold,size=13) string1
spgraph(done)

*******************************************************
******************************************************* 67 variable case
*******************************************************
smpl stsmpl endsmpl
clear(length=endsmpl) GFSVmedian	GFSV15	GFSV85 pc1

open data estimatesforfigures/factorcomparison.xlsx
data(format=xlsx,org=col,sheet="larger2factor") / GFSVmedian	GFSV15	GFSV85 pc1
close data
set(scratch) pc1 = sqrt(exp(pc1{0}))   ;* transform PC in line with GFSV median (which is m(t)^0.5 here)

comp basestsmpl = stsmpl
comp baseendsmpl = endsmpl
dofor i = gfsvmedian
 inquire(series=i) stpt endpt
 comp basestsmpl = %imax(basestsmpl,stpt)
 comp baseendsmpl = %imin(baseendsmpl,endpt)
end do i
dis %datelabel(basestsmpl) %datelabel(baseendsmpl)
smpl basestsmpl baseendsmpl

*********************
********************* simple correlations
*********************

cmom(corr,print)
# GFSVmedian pc1 pc1keep
dis(store=string1) "correlation = " #.### %cmom(2,1)

*********************
********************* charts with Bloom dates
*********************

*** from single factor model, with PC of BVAR-SV lambdas added
comp nlines = 4
spgraph(vfields=1,hfields=1)
set statser = GFSV85
graph(dates,grid=bloom,key=below,klab=||'uncertainty factor m(t)^0.5','PC of BVAR-SV','15%ile','85%ile'||,ovcount=2,overlay=fan,ovsame,shading=crisisperiod) nlines  ;*
# GFSVmedian / 1
# pc1 / 2
# GFSV15 / 8
# GFSV85 / 8
extremum(noprint) statser
stats(noprint) statser
comp units = %variance^0.5/2.
do j = 1,%rows(bloomdatevec)
 comp ypos = %maximum - %mod(j-1,3)*units
 grtext(bold,entry=bloomdatevec(j),y=ypos,valignment=top,size=14) bloomlabels(j)
end do j
grtext(position=upright,bold,size=13) string1
spgraph(done)
