%pssivF.m

%Computes the Powell, Stock, and Stoker (1989 Econometrica)
%IV or scaled Density Weighted Average Derivative Estimators and their asymptotic variance

%This file is a simple ``wrapper'' for the script pssiv.m

%Required files:
%pssiv.m    File containing the actual code for implementing the pssiv procedure.

%%%%%%Inputs:
%   y         Vector [n,1]  Dependent variables
%   x         Matrix [n,k]  Explanatory variables
%   h         Scalar        Bandwidth

%%%%%%Outputs:
% dhat        Vector [k,1]  Vector of average derivative estimates
% Wmat        Matrix [k,k]  Asymptotic variance-covariance matrix of deltahat


function [dhat,Wmat]=pssivF(y,x,h)

% Set up the structure pssivARG, which passes inputs to the script pssiv
pssivARG.y=y;
pssivARG.x=x;
pssivARG.h=h;

% Call the script pssiv 
pssiv
