%% table8.m
%
%This program estimates robustness estimates reported in table 4.

%% Data management
%Add relevant directories to the path.
%Powell, Stock and Stocker procedures.
addpath('../../pss/matlab');

%Load the data for one industry.
load ../Data/data92rfp

%Calculate the empirical c.d.f. of prices.

%f2=1-n2./nestab;
f499=1-(n2+n499)./nestab;
% f699=1-(n2+n499+n699)./nestab;
% f999=1-(n2+n499+n699+n999)./nestab;
% f1499=1-(n2+n499+n699+n999+n1499)./nestab;
% f2999=1-(n2+n499+n699+n999+n1499+n2999)./nestab;

%Calculate the ``exit rate''.
erate=1-nestabend./nestab;

%Calculate the average seating.
aseat=log(nseat./nestabseat);

%Transform independent variables for regressions.
lpop92=log(pop92);
lssrent=log(ssrent);
lrwage=log(rwage);
lnprate=log(nprate);
lpinc=log(pinc);
lhotel=log(hotel)-log(pop92);

pctstudents=students./pop92;

% Set up matrices to store coefficients.
%The A-table stores the coefficients on market size, while the B-table stores coefficients on the ``extra'' right-hand side variable.
deltahatA=zeros(4,7);
stderrsA=zeros(4,7);
deltahatB=zeros(4,7);
stderrsB=zeros(4,7);

%% Add control variables.

extraxs=[veh lhotel pctstudents elderly poverty highinc popgr];
nextraxs=size(extraxs,2);

%% Estimate density-weighted average derivatives for each of three measures of market size.

h=2;

for ss=1:nextraxs
    
    %Gather independent variables together. Scale by their standard deviations.
    xbase=[lpop92 lssrent lrwage lnprate lpinc female pctblk pctcol];
    x=[xbase extraxs(:,ss)];
    
    %Gather the dependent variables together.
    
    y=[100*log(f499./(1-f499)) 100*erate 100*log(vseat./nestabseat) 100*aseat];
    
    
    %Eliminate observations with missing data for any variable used.
    missy=sum(isnan(y),2);
    missx=sum(isnan(x),2);
    jj=find(missy==0 & missx==0);
    y=y(jj,:);
    x=x(jj,:);
    
    %Center and scale right-hand side variables.
    x(:,1)=x(:,1)-mean(x(:,1));
    x=std(x(:,1))*x./(ones(size(x,1),1)*std(x));
    
    
    %Compute Powell, Stock, and Stoker estimates.
    for i=1:size(y,2);
        [delta,sigma]=pssivF(y(:,i),x,h);
        deltahatA(i,ss)=delta(1);
        stderrsA(i,ss)=sqrt(diag(sigma(1,1)));
        deltahatB(i,ss)=delta(end);
        stderrsB(i,ss)=sqrt(diag(sigma(end,end)));
    end
    
    
end

%% Create cell array containing table8a.
ncols=nextraxs+1;
nrows=size(y,2)*2;

table8Acell=cell(nrows,ncols);
table8Acell{1,1}='$\mathbb{L}(\$5.00)^{\textrm{(iii)}}$';
table8Acell{3,1}='Exit Rate';
table8Acell{5,1}= ['Log of Restaurants' char(39) ' Average Revenue'];
table8Acell{7,1}='Log of Average Seats per Restaurant';

for i=1:nrows/2;
    
    
    for j=1:ncols-1
        
        %Create sign and significance strings.
        signstr=zsign(deltahatA(i,j));
        starsstr=stars(deltahatA(i,j)/stderrsA(i,j));
        
        %Assemble the table entries.
        temp1=[signstr num2str(abs(deltahatA(i,j)),' %2.2f ') starsstr];
        temp2=num2str(stderrsA(i,j),' & (%2.2f) ');
        
        %Write to the cell array appending tabular returns if appropriate.
        
        if j<ncols-1
            table8Acell{(i-1)*2+1,j+1}=temp1;
            table8Acell{i*2,j+1}=temp2;
        else
            table8Acell{(i-1)*2+1,j+1}=[temp1 '\\'];
            table8Acell{i*2,j+1}=[temp2 '\\\\'];
        end
        
    end
    
end

%% Save table8a to LaTeX.
f1=fopen('table8a.tex','w');
[nrows,ncols]=size(table8Acell);
for i=1:nrows
    for j=1:ncols-1
        fprintf(f1,'%s',table8Acell{i,j});
    end
    fprintf(f1,'%s\n',table8Acell{i,ncols});
end

fclose(f1);


%% Create cell array containing table8b.
ncols=nextraxs+1;
nrows=size(y,2)*2;

table8Bcell=cell(nrows,ncols);
table8Bcell{1,1}='$\mathbb{L}(\$5.00)^{\textrm{(iii)}}$';
table8Bcell{3,1}='Exit Rate';
table8Bcell{5,1}= ['Log of Restaurants' char(39) ' Average Revenue'];
table8Bcell{7,1}='Log of Average Seats per Restaurant';

for i=1:nrows/2;
    
    
    for j=1:ncols-1
        
        %Create sign and significance strings.
        signstr=zsign(deltahatB(i,j));
        starsstr=stars(deltahatB(i,j)/stderrsB(i,j));
        
        %Assemble the table entries.
        temp1=[signstr num2str(abs(deltahatB(i,j)),' %2.2f ') starsstr];
        temp2=num2str(stderrsB(i,j),' & (%2.2f) ');
        
        %Write to the cell array appending tabular returns if appropriate.
        
        if j<ncols-1
            table8Bcell{(i-1)*2+1,j+1}=temp1;
            table8Bcell{i*2,j+1}=temp2;
        else
            table8Bcell{(i-1)*2+1,j+1}=[temp1 '\\'];
            table8Bcell{i*2,j+1}=[temp2 '\\\\'];
        end
        
    end
    
end


%% Save table8b to LaTeX.
f1=fopen('table8b.tex','w');
[nrows,ncols]=size(table8Bcell);
for i=1:nrows
    for j=1:ncols-1
        fprintf(f1,'%s',table8Bcell{i,j});
    end
    fprintf(f1,'%s\n',table8Bcell{i,ncols});
end

fclose(f1);


%% Write table8keys
% This uses the pgfkeys package to make the two tables' entries available for insertion into the text.

f1=fopen('table8keys.tex','w');

%Table 4a
[rows,cols]=size(deltahatA);
for i=1:rows
    for j=1:cols
        fprintf(f1,'\\pgfkeyssetvalue{/results/table8a/deltahat/row %2.0f/column %2.0f}{%3.2f}\n',i,j,deltahatA(i,j));
        fprintf(f1,'\\pgfkeyssetvalue{/results/table8a/stderrs/row %2.0f/column %2.0f}{%3.2f}\n',i,j,stderrsA(i,j));
    end
end


%Table 4b
[rows,cols]=size(deltahatB);
for i=1:rows
    for j=1:cols
        fprintf(f1,'\\pgfkeyssetvalue{/results/table8b/deltahat/row %2.0f/column %2.0f}{%3.2f}\n',i,j,deltahatB(i,j));
        fprintf(f1,'\\pgfkeyssetvalue{/results/table8b/stderrs/row %2.0f/column %2.0f}{%3.2f}\n',i,j,stderrsB(i,j));
    end
end

fclose(f1);

%% Close shop.
quit


