%% table7.m
%
%This program estimates robustness estimates for refreshment places.

%% Data management
%Add relevant directories to the path.
%Powell, Stock and Stocker procedures.
addpath('../../pss/matlab');

%Load the data for one industry.
load ../Data/data92rfp

%Calculate the empirical c.d.f. of prices.

%f2=1-n2./nestab;
f499=1-(n2+n499)./nestab;
% f699=1-(n2+n499+n699)./nestab;
% f999=1-(n2+n499+n699+n999)./nestab;
% f1499=1-(n2+n499+n699+n999+n1499)./nestab;
% f2999=1-(n2+n499+n699+n999+n1499+n2999)./nestab;

%Calculate the ``exit rate''.
erate=1-nestabend./nestab;

%Calculate the average seating.
aseat=log(nseat./nestabseat);

%Transform independent variables for regressions.
lpop92=log(pop92);
lpdense=log(pdense);
lhu=log(hu);
lssrent=log(ssrent);
lrwage=log(rwage);
lnprate=log(nprate);
lpinc=log(pinc);

%Transform instruments for regressions.
lhr=log(hr);
lhv=log(hv);

% Set up matrices to store coefficients.
deltahat=zeros(4,7);
stderrs=zeros(4,7);

%% Estimate density-weighted average derivatives for each of three measures of market size.
sizechoices=[lpop92 lpdense lhu];
h=2;

for ss=1:3

    %Gather independent variables together. Scale by their standard deviations.
    x=[sizechoices(:,ss) lssrent lrwage lnprate lpinc female pctblk pctcol];

    %Gather the dependent variables together.

    y=[100*log(f499./(1-f499)) 100*erate 100*log(vseat./nestabseat) 100*aseat];

    
    %Eliminate observations with missing data for any variable used.
missy=sum(isnan(y),2);
missx=sum(isnan(x),2);
jj=find(missy==0 & missx==0);
y=y(jj,:);
x=x(jj,:);

%Center and scale right-hand side variables.
x(:,1)=x(:,1)-mean(x(:,1));
x=std(x(:,1))*x./(ones(size(x,1),1)*std(x));


    %Compute Powell, Stock, and Stoker estimates.
    for i=1:size(y,2);
        [delta,sigma]=pssivF(y(:,i),x,h);
        deltahat(i,ss)=delta(1);
        stderrs(i,ss)=sqrt(diag(sigma(1,1)));
    end


end
%% Estimate density-weighted average derivatives for two alternative bandwidth choices.
hchoices=[1 3];
for sh=1:2

    %Gather independent variables together. Scale by their standard deviations.
    x=[lpop92 lssrent lrwage lnprate lpinc pctblk pctcol veh];

    %Gather the dependent variables together.
    y=[100*log(f499./(1-f499)) 100*erate 100*log(vseat./nestabseat) 100*aseat];

        
    %Eliminate observations with missing data for any variable used.
missy=sum(isnan(y),2);
missx=sum(isnan(x),2);
jj=find(missy==0 & missx==0);
y=y(jj,:);
x=x(jj,:);

%Center and scale right-hand side variables.
x(:,1)=x(:,1)-mean(x(:,1));
x=std(x(:,1))*x./(ones(size(x,1),1)*std(x));


    %Compute Powell, Stock, and Stoker estimates.
    for i=1:size(y,2);
        [delta,sigma]=pssivF(y(:,i),x,hchoices(sh));
        deltahat(i,3+sh)=delta(1);
        stderrs(i,3+sh)=sqrt(diag(sigma(1,1)));
    end

end
    
%% Compute ols estimates

for i=1:size(y,2);
    beta=inv(x'*x)*(x'*y(:,i));
    resids=y(:,i)-x*beta;
    sigma=diag(resids.^2);
    stderrstemp=sqrt(diag(inv(x'*x)*x'*sigma*x*inv(x'*x)));
    deltahat(i,6)=beta(1);
    stderrs(i,6)=stderrstemp(1);    
end

%% Compute iv estimates

%Choice of instruments.
z=[lpop92 lhr lhv lrwage lnprate lpinc pctblk pctcol veh];

%Account for possible missing values in the instrument set.
z=z(jj,:);
missz=sum(isnan(z),2);
jj=find(missz==0);
x=x(jj,:);
y=y(jj,:);
z=z(jj,:);

for i=1:size(y,2);
    beta=inv(x'*z*inv(z'*z)*z'*x)*(x'*z*inv(z'*z)*z'*y(:,i));
    resids=y(:,i)-x*beta;
    sigma=diag(resids.^2);
    stderrstemp=sqrt(diag(inv(x'*z*inv(z'*z)*z'*x)*(x'*z*inv(z'*z)*z'*sigma*z*inv(z'*z)*z'*x)*inv(x'*z*inv(z'*z)*z'*x)));    
    deltahat(i,7)=beta(1);
    stderrs(i,7)=stderrstemp(1);
end

%% Create cell array containing table.
% In the reporting, we break this table's final two columns into a separate table.

ncols=size(sizechoices,2)+size(hchoices,2)+3;
nrows=size(y,2)*2;

table7cell=cell(nrows,ncols);
table7cell{1,1}='$\mathbb{L}(\$5.00)^{\textrm{(iii)}}$';
table7cell{3,1}='Exit Rate';
table7cell{5,1}= ['Log of Refreshment Places' char(39) ' Average Revenue'];
table7cell{7,1}='Log of Average Seats per Refreshment Place';

for i=1:nrows/2;
    
    
    for j=1:ncols-1
        
        %Create sign and significance strings.
        signstr=zsign(deltahat(i,j));
        starsstr=stars(deltahat(i,j)/stderrs(i,j));
        
        %Assemble the table entries.
        temp1=[signstr num2str(abs(deltahat(i,j)),' %2.2f ') starsstr];
        temp2=num2str(stderrs(i,j),' & (%2.2f) ');
        
        if j==ncols-3 || j==ncols-1
            temp1=strcat(temp1,'\\');
            temp2=strcat(temp2,'\\\\');
        end
        
        %Write to the cell array.
        table7cell{(i-1)*2+1,j+1}=temp1;
        table7cell{i*2,j+1}=temp2;
        
    end
    
end

%% Save the results to LaTeX tables.
f1=fopen('table7a.tex','w');
f2=fopen('table7b.tex','w');
[nrows,ncols]=size(table7cell);
for i=1:nrows
    fprintf(f2,'%s',table7cell{i,1}); %First column for table3b.tex
    for j=1:ncols-3 %This omits the final two rows from table3a.tex
        fprintf(f1,'%s',table7cell{i,j});
    end
    fprintf(f1,'%s \n',table7cell{i,ncols-2}); %Final column of table3a.tex
    fprintf(f2,'%s',table7cell{i,ncols-1}); %Final two columns of table3b.tex
    fprintf(f2,'%s \n',table7cell{i,ncols});
end

fclose(f1);

%% Write table7keys.tex
% This creates keys using the pgfkeys package to insert results from the
% table into the text.

[rows,cols]=size(deltahat);
f1=fopen('table7keys.tex','w');
for i=1:rows
    for j=1:cols
        fprintf(f1,'\\pgfkeyssetvalue{/results/table7/deltahat/row %2.0f/column %2.0f}{%3.2f}\n',i,j,deltahat(i,j));
        fprintf(f1,'\\pgfkeyssetvalue{/results/table7/stderrs/row %2.0f/column %2.0f}{%3.2f}\n',i,j,stderrs(i,j));
    end
end


%% Close shop.
quit

