%table6.m

%This program estimates density-weighted average derivatives for refreshment places.
%Requires pssiv.m, procedure to run the PSS IV density weighted average derivatives estimates.

%Add relevant directories to the path.

%Powell, Stock and Stocker procedures.
addpath('../../pss/matlab');

%Set the window width h to construct the Kernel.
h=2;

%Load the data for one industry.
load ../Data/data92rfp

%Calculate the empirical c.d.f. of prices.

%f2=1-n2./nestab;
f499=1-(n2+n499)./nestab;
% f699=1-(n2+n499+n699)./nestab;
% f999=1-(n2+n499+n699+n999)./nestab;
% f1499=1-(n2+n499+n699+n999+n1499)./nestab;
% f2999=1-(n2+n499+n699+n999+n1499+n2999)./nestab;

%Calculate the ``exit rate''.
erate=1-nestabend./nestab;

%Transform independent variables for regressions.
lpop92=log(pop92);
lssrent=log(ssrent);
lrwage=log(rwage);
lnprate=log(nprate);
lpinc=log(pinc);

%Gather independent variables together. Scale by their standard deviations.
x=[lpop92 lssrent lrwage lnprate lpinc female pctblk pctcol];

%Give the independent variables names
vnames=cell(size(x,2)*2,1);
vnames(1)=cellstr('Population');
vnames(3)=cellstr('Commercial Rent');
vnames(5)=cellstr('Retail Wage');
vnames(7)=cellstr('Advertising Cost');
vnames(9)=cellstr('Income');
vnames(11)=cellstr('Percent Females in Labor Force');
vnames(13)=cellstr('Percent Black');
vnames(15)=cellstr('Percent College');
vnames(2)=cellstr(' ');
vnames(4)=vnames(2);
vnames(6)=vnames(2);
vnames(8)=vnames(2);
vnames(10)=vnames(2);
vnames(12)=vnames(2);
vnames(14)=vnames(2);
vnames(16)=vnames(2);

%Gather the dependent variables together.
y=[100*log(f499./(1-f499)) 100*erate 100*log(vseat./nestabseat) 100*log(nseat./nestabseat) ];

%Eliminate observations with missing data for any variable used.
missy=sum(isnan(y),2);
missx=sum(isnan(x),2);
jj=find(missy==0 & missx==0);
y=y(jj,:);
x=x(jj,:);

%Center and scale right-hand side variables.
x(:,1)=x(:,1)-mean(x(:,1));
stdx=std(x(:,1));
x=std(x(:,1))*x./(ones(size(x,1),1)*std(x));

%Compute pss iv and ols estimates
deltahat=zeros(size(x,2),size(y,2));
sigmahat=zeros(size(y,2)*size(x,2),size(x,2));
stderrs=zeros(size(x,2),size(y,2));

for i=1:size(y,2);
    [delta,sigma]=pssivF(y(:,i),x,h);
    deltahat(:,i)=delta;
    sigmahat(1+size(x,2)*(i-1):size(x,2)*i,:)=sigma;
    stderrs(:,i)=sqrt(diag(sigma));           
end

%Create table 2.
%Cycle through the independent variables.
v=cell(size(x,2)*2,size(y,2));

for i=1:size(x,2);
    
    %Cycle through the dependent variables.
    for j=1:size(y,2);
        d=deltahat(i,j);
        s=stderrs(i,j);
        dstr=num2str(d,'& %3.2f ');
        sstr=num2str(s,'& (%3.2f) ');
        t=d/s;
        
        %Define norminv so that the user does not need the statistics
        %toolbox.
        erfcinv = @(y) erfinv(1-y); 
        norminv = @(p) -sqrt(2)*erfcinv(2*p);
        
        if abs(t)>norminv(0.95) && abs(t)<=norminv(0.975);   significanceLevel='Ten Percent';
        elseif abs(t)>norminv(0.975) && abs(t) <=norminv(0.995);  significanceLevel='Five Percent';
        elseif abs(t)>norminv(0.995); significanceLevel='One Percent';
        else significanceLevel='Not Significant';
        end
        
        switch significanceLevel
            case('Ten Percent')
                dstr=strcat(dstr,'$^{\star}$');
            case('Five Percent')
                dstr=strcat(dstr,'$^{\star\star}$');
            case('One Percent')
                dstr=strcat(dstr,'$^{\star\star\star}$');
        end
        
        if j==size(y,2)
            dstr=strcat(dstr,'\\');
            sstr=strcat(sstr,'\\\\');
        end
        v((i-1)*2+1,j)=cellstr(dstr);
        v(i*2,j)=cellstr(sstr);
    end

end

%Add variable names to v
v=[vnames v];


%% Save the results to a LaTeX Table
f1=fopen('table6.tex','w');
[nrows,ncols]=size(v);
for i=1:nrows
    for j=1:ncols-1
        fprintf(f1,'%s',v{i,j});
    end
    fprintf(f1,'%s\n',v{i,ncols});
end

fclose(f1);


%% Write table2keys.tex
[rows,cols]=size(deltahat);
f1=fopen('table6keys.tex','w');
for i=1:rows
    for j=1:cols
        fprintf(f1,'\\pgfkeyssetvalue{/results/table6/deltahat/row %2.0f/column %2.0f}{%3.2f}\n',i,j,deltahat(i,j));
        fprintf(f1,'\\pgfkeyssetvalue{/results/table6/stderrs/row %2.0f/column %2.0f}{%3.2f}\n',i,j,stderrs(i,j));
    end
end
fprintf(f1,'\\pgfkeyssetvalue{/results/table6/stdx}{%3.2f}\n',stdx);
fprintf(f1,'\\pgfkeyssetvalue{/results/table6/bandwidth}{%3.2f}\n',h);
fclose(f1);

quit
