%table1.m

%This program calculates summary statistics for the dependent variables used in the regressions.

%Load the data for one industry.
load ../Data/data92rst

%Calculate the empirical c.d.f. of prices at $4.99
f499=1-(n2+n499)./nestab;

%Calculate the ``exit rate''.
erate=1-nestabend./nestab;

%Transform independent variables for regressions.
lpop92=log(pop92);


lssrent=log(ssrent);
lrwage=log(rwage);
lnprate=log(nprate);
lpinc=log(pinc);


%Gather independent variables together. Scale by their standard deviations.
x=[lpop92 lssrent lrwage lnprate lpinc pctblk pctcol veh];
 
%Gather the dependent variables together.In this program, these are only
%summarized.
y=[f499 100*erate vseat./nestabseat nseat./nestabseat ];

%Eliminate observations with missing data for any variable used in the regressions
missy=sum(isnan(y),2);
missx=sum(isnan(x),2);
y=y(missy==0 & missx==0,:);
x=x(missy==0 & missx==0,:);

samplesize=size(y,1);

%Calculate the relevant summary statistics.
my=mean(y);
sy=std(y);
covy=mean((y-ones(size(y,1),1)*mean(y)).*(x(:,1)*ones(1,size(y,2))));
corry=covy./(std(y)*std(x(:,1)));
%% Create the LaTeX table
namecell=cell(4,1);
namecell{1,1}='$\mathbb{S}(\$5.00)^{\textrm{(i)}}$';
namecell{2,1}='Exit Rate (in percentage points)';
namecell{3,1}=['Restaurants' char(39) ' Average Revenue (in $\$1,000$)'];
namecell{4,1}='Average Seating Capacity';
namestr=char(namecell);

v=[my' sy' corry'];
sv1=num2str(v(:,1:2),'& %3.2f ');
sv2=num2str(v(:,3),'& %3.2f \\\\\\\\');
sv=[namestr sv1 sv2];

%Write it to table1.tex
f1=fopen('table1.tex','w');
nrows=size(sv,1);
for i=1:nrows;
    fprintf(f1,'%s\n',sv(i,:));
end
fclose(f1);

%% Write table1keys.tex
f1=fopen('table1keys.tex','w');
fprintf(f1,'\\pgfkeyssetvalue{/results/table1/sample size}{%3.0f}\n',samplesize);

[rows,cols]=size(v);
for i=1:rows;
    for j=1:cols
        fprintf(f1,'\\pgfkeyssetvalue{/results/table1/row %2.0f/column %2.0f}{%3.2f}\n',i,j,v(i,j));
    end
end

fclose(f1);

quit
