%% stars.m
%
% Determines the appropriate string for indicating statistical significance, given a t-statistic.

function s=stars(t);

   %Determine the level of significance and assign stars appropriately.
   if abs(t)>=2.5758
       s='\levelone';
   elseif abs(t)>=1.96
       s='\levelfive';
   elseif abs(t)>=1.6449
       s='\levelten';
   else
       s=' ';
   end
   
   