%% figures.m
%  This program creates the scatter plots in Campbell (2009).

%% Data management
%Load the data for one industry.
load ../Data/data92rst

%Calculate the empirical c.d.f. of prices.

%f2=1-n2./nestab;
f499=1-(n2+n499)./nestab;
% f699=1-(n2+n499+n699)./nestab;
% f999=1-(n2+n499+n699+n999)./nestab;
% f1499=1-(n2+n499+n699+n999+n1499)./nestab;
% f2999=1-(n2+n499+n699+n999+n1499+n2999)./nestab;

%Calculate the ``exit rate''.
erate=1-nestabend./nestab;


%Transform independent variables for regressions.
lpop92=log(pop92);

lssrent=log(ssrent);
lrwage=log(rwage);
lnprate=log(nprate);
lpinc=log(pinc);

%Gather independent variables together. Scale by their standard deviations.
x=[lpop92 lssrent lrwage lnprate lpinc pctblk pctcol veh];

%Gather the dependent variables together.
y=[log(f499./(1-f499)) 100*erate 100*log(vseat./nestabseat) 100*log(nseat./nestabseat) ];

%Eliminate observations with missing data for any variable used in the regressions
missy=sum(isnan(y),2);
missx=sum(isnan(x),2);
jj=find(missy==0 & missx==0);
y=y(jj,:);
x=x(jj,:);
name=name(jj);

x(:,1)=x(:,1)-mean(x(:,1));
x=std(x(:,1))*x./(ones(size(x,1),1)*std(x));

%% Plot Relative Market Shares of Restaurants with High and Low Meal Prices against Population.

figure('Visible','off');
set(gcf,'color',[1 1 1]);
set(gcf,'Position',[-3 5 1280 950],...
    'PaperUnits','in','PaperSize',[17 11],'PaperPositionMode','manual','PaperPosition',[0 0 17 11]); %Set figure to screen size.

plot(x(:,1),y(:,1),'.k','MarkerSize',18);
box('off');
set(gca,'FontSize',28);
lowx=min(x(:,1))-0.1;
hix=max(x(:,1))+0.1;
xlim([lowx hix]);
lowy=min(y(:,1))-0.1;
hiy=max(y(:,1))+0.1;
ylim([lowy hiy]);
%title('Relative Market Shares of Restaurants with High and Low Meal Prices, $\ln S(\$4.99)/(1-S(\$4.99))$','Interpreter','latex');
xlabel('$\ln POP/\overline{POP}$','Interpreter','latex');

%Place tick-marks on the x-axis.
set(gca,'XTick',[min(x(:,1)) 0 max(x(:,1))])
xtickstr=' | | ';
set(gca,'XTickLabel',xtickstr);

%Place tick marks on the y-axis.
set(gca,'YTick',[min(y(:,1)) median(y(:,1)) max(y(:,1))]);
ytickstr=' | | ';
set(gca,'YTickLabel',ytickstr);

%Find the lower-left corner of the current axis. 
temp=get(gca,'position');
% Use this to create an in-line function that converts plot units to figure units.
funits = @(x) [temp(1)+temp(3)*(x(1)-lowx)/(hix-lowx) temp(2)+temp(4)*(x(2)-lowy)/(hiy-lowy)];

% Label the tick marks on the x-axis.
loc1=funits([min(x(:,1)) lowy]);
loc2=funits([0 lowy]);
loc3=funits([max(x(:,1)) lowy]);
str1=num2str(exp(min(x(:,1))),'%2.1f ');
str3=num2str(exp(max(x(:,1))),'%2.1f ');
annotation(...
    'textbox',...
    'Position',[loc1-[0.025 0] 0.05 0],...
    'LineStyle','none',...
    'FitHeightToText','off',...
    'FontSize',28,...
    'Interpreter','latex',...
    'String',['$\ln(' str1 ')$'],...
    'HorizontalAlignment','center');

annotation(...
    'textbox',...
    'Position',[loc2-[0.025 0] 0.05 0],...
    'LineStyle','none',...
    'FitHeightToText','off',...
    'FontSize',28,...
    'Interpreter','latex',...
    'String','$\ln(1)$',...
    'HorizontalAlignment','center');

annotation(...
    'textbox',...
    'Position',[loc3-[0.025 0] 0.05 0],...
    'LineStyle','none',...
    'FitHeightToText','off',...
    'FontSize',28,...
    'Interpreter','latex',...
    'String',['$\ln(' str3 ')$'],...
    'HorizontalAlignment','center');


% Label the tick marks on the y-axis.
loc1=funits([lowx min(y(:,1))]);
my=min(y(:,1));
str1=num2str(exp(my)/(1+exp(my)),' %2.2f');
str2=num2str(1/(1+exp(my)),'%2.2f');
annotation(...
    'textbox',...
    'Position',[loc1-[0.085 0] 0.05 0],...
    'LineStyle','none',...
    'FitHeightToText','off',...
    'FontSize',28,...
    'Interpreter','latex',...
    'String',['$\ln(\frac{' str1 '}{' str2 '})$'],...
    'HorizontalAlignment','center',...
    'VerticalAlignment','middle');

loc2=funits([lowx median(y(:,1))]);
my=median(y(:,1));
str1=num2str(exp(my)/(1+exp(my)),' %2.2f');
str2=num2str(1/(1+exp(my)),'%2.2f');

annotation(...
    'textbox',...
    'Position',[loc2-[0.085 0] 0.05 0],...
    'LineStyle','none',...
    'FitHeightToText','off',...
    'FontSize',28,...
    'Interpreter','latex',...
    'String',['$\ln(\frac{' str1 '}{' str2 '})$'],...
    'HorizontalAlignment','center',...
    'VerticalAlignment','middle');

loc3=funits([lowx max(y(:,1))]);
my=max(y(:,1));
str1=num2str(exp(my)/(1+exp(my)),'%2.2f');
str2=num2str(1/(1+exp(my)),'%2.2f');


annotation(...
    'textbox',...
    'Position',[loc3-[0.085 0] 0.05 0],...
    'LineStyle','none',...
    'FitHeightToText','off',...
    'FontSize',28,...
    'Interpreter','latex',...
    'String',['$\ln(\frac{' str1 '}{' str2 '})$'],...
    'HorizontalAlignment','center',...
    'VerticalAlignment','middle');

% label the outliers

%Lowest y
[my,i]=min(y(:,1));
namestr=regexprep(name{i},' MSA$','');
lowestYname=namestr;
lowestYvalue=exp(my)/(1+exp(my));
loc1=funits([x(i,1) my+0.05]);
loc2=funits([x(i,1)-0.05 my+0.25]);
annotation(...
  'textarrow',...
  [loc2(1) loc1(1)],[loc2(2) loc1(2)],...
  'String',namestr,...
  'FontSize',28,...
  'Interpreter','latex',...
  'HorizontalAlignment','center');


%Highest 2 y's
[my,i]=max(y(:,1));
namestr=regexprep(name{i},' MSA$','');
highestYname=namestr;
highestYvalue=exp(my)/(1+exp(my));

loc1=funits([x(i,1) my-0.05]);
loc2=funits([x(i,1)-0.05 my-0.25]);
annotation(...
  'textarrow',...
  [loc2(1) loc1(1)],[loc2(2) loc1(2)],...
  'String',namestr,...
  'FontSize',28,...
  'Interpreter','latex',...
  'HorizontalAlignment','center');

[z,i]=sort(y(:,1));
i=i(end-1);
my=z(end-1);
namestr=regexprep(name{i},' MSA$','');
secondHighestYname=namestr;
secondHighestYvalue=exp(my)/(1+exp(my));
loc1=funits([x(i,1) my-0.05]);
loc2=funits([x(i,1)+0.15 my-0.25]);
annotation(...
  'textarrow',...
  [loc2(1) loc1(1)],[loc2(2) loc1(2)],...
  'String',namestr,...
  'FontSize',28,...
  'Interpreter','latex',...
  'HorizontalAlignment','center');

%Lowest x.
[mx,i]=min(x(:,1));
namestr=regexprep(name{i},' MSA$','');
lowestXname=namestr;
lowestXvalue=mx;

loc1=funits([mx y(i,1)+0.05]);
loc2=funits([mx+0.175 y(i,1)+0.55]);
annotation(...
  'textarrow',...
  [loc2(1) loc1(1)],[loc2(2) loc1(2)],...
  'String',namestr,...
  'FontSize',28,...
  'Interpreter','latex',...
  'HorizontalAlignment','center');

%Highest x.

[mx,i]=max(x(:,1));
namestr=regexprep(name{i},' MSA$','');
highestXname=namestr;
highestXvalue=mx;
loc1=funits([mx y(i,1)+0.05]);
loc2=funits([mx-0.2 y(i,1)+0.55]);
annotation(...
  'textarrow',...
  [loc2(1) loc1(1)],[loc2(2) loc1(2)],...
  'String',namestr,...
  'FontSize',28,...
  'Interpreter','latex',...
  'HorizontalAlignment','center');


%-------------------------------------
% Export to .pdf file file
%-------------------------------------


print -dpdf -painters figure1.pdf
close all

%% Write figure1keys.tex
% This contains the names of the minimia and maxima reported as well as the various statistics reported.
f1=fopen('figure1keys.tex','w');
fprintf(f1,'\\pgfkeyssetvalue{/results/figure1/minimum x/name}{%s}\n',lowestXname);
fprintf(f1,'\\pgfkeyssetvalue{/results/figure1/minimum x/value}{%3.2f}\n',lowestXvalue);
fprintf(f1,'\\pgfkeyssetvalue{/results/figure1/maximum x/name}{%s}\n',highestXname);
fprintf(f1,'\\pgfkeyssetvalue{/results/figure1/maximum x/value}{%3.2f}\n',highestXvalue);
fprintf(f1,'\\pgfkeyssetvalue{/results/figure1/minimum y/name}{%s}\n',lowestYname);
fprintf(f1,'\\pgfkeyssetvalue{/results/figure1/minimum y/value}{%3.2f}\n',lowestYvalue);
fprintf(f1,'\\pgfkeyssetvalue{/results/figure1/maximum y/name}{%s}\n',highestYname);
fprintf(f1,'\\pgfkeyssetvalue{/results/figure1/maximum y/value}{%3.2f}\n',highestYvalue);
fprintf(f1,'\\pgfkeyssetvalue{/results/figure1/second maximum y/name}{%s}\n',secondHighestYname);
fprintf(f1,'\\pgfkeyssetvalue{/results/figure1/second maximum y/value}{%3.2f}\n',secondHighestYvalue);
mediany=median(y(:,1));
mediany=exp(mediany)/(1+exp(mediany));
fprintf(f1,'\\pgfkeyssetvalue{/results/figure1/median y}{%3.2f}\n',mediany);
corrxy=corrcoef([x(:,1) y(:,1)]);
fprintf(f1,'\\pgfkeyssetvalue{/results/figure1/correlation}{%3.2f}\n',corrxy(2,1));
fclose(f1);
    
%% Plot the Exit Rate against Population

figure('Visible','off');
set(gcf,'color',[1 1 1]);
set(gcf,'Position',[-3 5 1280 950],...
    'PaperUnits','in','PaperSize',[17 11],'PaperPositionMode','manual','PaperPosition',[0 0 17 11]); %Set figure to screen size.

plot(x(:,1),y(:,2),'.k','MarkerSize',18);
box('off');
set(gca,'FontSize',28);
lowx=min(x(:,1))-0.1;
hix=max(x(:,1))+0.1;
xlim([lowx hix]);
lowy=min(y(:,2))-1;
hiy=max(y(:,2))+1;
ylim([lowy hiy]);
%title('Relative Market Shares of Restaurants with High and Low Meal Prices, $\ln S(\$4.99)/(1-S(\$4.99))$','Interpreter','latex');
xlabel('$\ln POP/\overline{POP}$','Interpreter','latex');

%Place tick-marks on the x-axis.
set(gca,'XTick',[min(x(:,1)) 0 max(x(:,1))])
xtickstr=' | | ';
set(gca,'XTickLabel',xtickstr);

%Place tick marks on the y-axis.
set(gca,'YTick',[min(y(:,2)) median(y(:,2)) max(y(:,2))]);
ytickstr=' | | ';
set(gca,'YTickLabel',ytickstr);

%Find the lower-left corner of the current axis. 
temp=get(gca,'position');
% Use this to create an in-line function that converts plot units to figure units.
funits = @(x) [temp(1)+temp(3)*(x(1)-lowx)/(hix-lowx) temp(2)+temp(4)*(x(2)-lowy)/(hiy-lowy)];

% Label the tick marks on the x-axis.
loc1=funits([min(x(:,1)) lowy]);
loc2=funits([0 lowy]);
loc3=funits([max(x(:,1)) lowy]);
str1=num2str(exp(min(x(:,1))),'%2.1f ');
str3=num2str(exp(max(x(:,1))),'%2.1f ');
annotation(...
    'textbox',...
    'Position',[loc1-[0.025 0] 0.05 0],...
    'LineStyle','none',...
    'FitHeightToText','off',...
    'FontSize',28,...
    'Interpreter','latex',...
    'String',['$\ln(' str1 ')$'],...
    'HorizontalAlignment','center');

annotation(...
    'textbox',...
    'Position',[loc2-[0.025 0] 0.05 0],...
    'LineStyle','none',...
    'FitHeightToText','off',...
    'FontSize',28,...
    'Interpreter','latex',...
    'String','$\ln(1)$',...
    'HorizontalAlignment','center');

annotation(...
    'textbox',...
    'Position',[loc3-[0.025 0] 0.05 0],...
    'LineStyle','none',...
    'FitHeightToText','off',...
    'FontSize',28,...
    'Interpreter','latex',...
    'String',['$\ln(' str3 ')$'],...
    'HorizontalAlignment','center');


% Label the tick marks on the y-axis.
loc1=funits([lowx min(y(:,2))]);
str1=num2str(min(y(:,2)),' %2.1f');

annotation(...
    'textbox',...
    'Position',[loc1-[0.05 0] 0.05 0],...
    'LineStyle','none',...
    'FitHeightToText','off',...
    'FontSize',28,...
    'Interpreter','latex',...
    'String',str1,...
    'HorizontalAlignment','center',...
    'VerticalAlignment','middle');

loc2=funits([lowx median(y(:,2))]);
str2=num2str(median(y(:,2)),' %2.1f');
annotation(...
    'textbox',...
    'Position',[loc2-[0.05 0] 0.05 0],...
    'LineStyle','none',...
    'FitHeightToText','off',...
    'FontSize',28,...
    'Interpreter','latex',...
    'String',str2,...
    'HorizontalAlignment','center',...
    'VerticalAlignment','middle');


loc3=funits([lowx max(y(:,2))]);
str3=num2str(max(y(:,2)),' %2.1f');
annotation(...
    'textbox',...
    'Position',[loc3-[0.05 0] 0.05 0],...
    'LineStyle','none',...
    'FitHeightToText','off',...
    'FontSize',28,...
    'Interpreter','latex',...
    'String',str3,...
    'HorizontalAlignment','center',...
    'VerticalAlignment','middle');


% label the outliers

%Lowest y
[my,i]=min(y(:,2));
namestr=regexprep(name{i},' MSA$','');
lowestYname=namestr;
lowestYvalue=my;

loc1=funits([x(i,1) my+0.1]);
loc2=funits([x(i,1)-0.15 my+0.5]);
annotation(...
  'textarrow',...
  [loc2(1) loc1(1)],[loc2(2) loc1(2)],...
  'String',namestr,...
  'FontSize',28,...
  'Interpreter','latex',...
  'HorizontalAlignment','center');


%Highest y
[my,i]=max(y(:,2));
namestr=regexprep(name{i},' MSA$','');
highestYname=namestr;
highestYvalue=my;

loc1=funits([x(i,1) my-0.1]);
loc2=funits([x(i,1)+0.5 my-0.25]);
annotation(...
  'textarrow',...
  [loc2(1) loc1(1)],[loc2(2) loc1(2)],...
  'String',namestr,...
  'FontSize',28,...
  'Interpreter','latex',...
  'HorizontalAlignment','center');


%Lowest x.
[mx,i]=min(x(:,1));
namestr=regexprep(name{i},' MSA$','');
lowestXname=namestr;
lowestXvalue=y(i,2);

loc1=funits([mx y(i,2)+0.1]);
loc2=funits([mx+0.2 y(i,2)+0.55]);
annotation(...
  'textarrow',...
  [loc2(1) loc1(1)],[loc2(2) loc1(2)],...
  'String',namestr,...
  'FontSize',28,...
  'Interpreter','latex',...
  'HorizontalAlignment','center');

%Highest x.

[mx,i]=max(x(:,1));
namestr=regexprep(name{i},' MSA$','');
highestXname=namestr;
highestXvalue=y(i,2);

loc1=funits([mx y(i,2)+0.1]);
loc2=funits([mx-0.2 y(i,2)+3]);
annotation(...
  'textarrow',...
  [loc2(1) loc1(1)],[loc2(2) loc1(2)],...
  'String',namestr,...
  'FontSize',28,...
  'Interpreter','latex',...
  'HorizontalAlignment','center');


%-------------------------------------
% Export to .pdf file file
%-------------------------------------


print -dpdf -painters figure2.pdf
close all

%% Write figure2keys.tex
f1=fopen('figure2keys.tex','w');
fprintf(f1,'\\pgfkeyssetvalue{/results/figure2/minimum x/name}{%s}\n',lowestXname);
fprintf(f1,'\\pgfkeyssetvalue{/results/figure2/minimum x/value}{%3.2f}\n',lowestXvalue);
fprintf(f1,'\\pgfkeyssetvalue{/results/figure2/maximum x/name}{%s}\n',highestXname);
fprintf(f1,'\\pgfkeyssetvalue{/results/figure2/maximum x/value}{%3.2f}\n',highestXvalue);
fprintf(f1,'\\pgfkeyssetvalue{/results/figure2/minimum y/name}{%s}\n',lowestYname);
fprintf(f1,'\\pgfkeyssetvalue{/results/figure2/minimum y/value}{%3.2f}\n',lowestYvalue);
fprintf(f1,'\\pgfkeyssetvalue{/results/figure2/maximum y/name}{%s}\n',highestYname);
fprintf(f1,'\\pgfkeyssetvalue{/results/figure2/maximum y/value}{%3.2f}\n',highestYvalue);
corrxy=corrcoef([x(:,1) y(:,2)]);
fprintf(f1,'\\pgfkeyssetvalue{/results/figure2/correlation}{%3.2f}\n',corrxy(2,1));
mediany=median(y(:,2));
fprintf(f1,'\\pgfkeyssetvalue{/results/figure2/median y}{%3.2f}\n',mediany);
fclose(f1);

%% Plot Revenue per seat against population

figure('Visible','off');
set(gcf,'color',[1 1 1]);
set(gcf,'Position',[-3 5 1280 950],...
    'PaperUnits','in','PaperSize',[17 11],'PaperPositionMode','manual','PaperPosition',[0 0 17 11]); %Set figure to screen size.

plot(x(:,1),y(:,3),'.k','MarkerSize',18);
box('off');
set(gca,'FontSize',28);
lowx=min(x(:,1))-0.1;
hix=max(x(:,1))+0.1;
xlim([lowx hix]);
lowy=min(y(:,3))-1;
hiy=max(y(:,3))+1;
ylim([lowy hiy]);
%title('Relative Market Shares of Restaurants with High and Low Meal Prices, $\ln S(\$4.99)/(1-S(\$4.99))$','Interpreter','latex');
xlabel('$\ln POP/\overline{POP}$','Interpreter','latex');

%Place tick-marks on the x-axis.
set(gca,'XTick',[min(x(:,1)) 0 max(x(:,1))])
xtickstr=' | | ';
set(gca,'XTickLabel',xtickstr);

%Place tick marks on the y-axis.
set(gca,'YTick',[min(y(:,3)) median(y(:,3)) max(y(:,3))]);
ytickstr=' | | ';
set(gca,'YTickLabel',ytickstr);

%Find the lower-left corner of the current axis. 
temp=get(gca,'position');
% Use this to create an in-line function that converts plot units to figure units.
funits = @(x) [temp(1)+temp(3)*(x(1)-lowx)/(hix-lowx) temp(2)+temp(4)*(x(2)-lowy)/(hiy-lowy)];

% Label the tick marks on the x-axis.
loc1=funits([min(x(:,1)) lowy]);
loc2=funits([0 lowy]);
loc3=funits([max(x(:,1)) lowy]);
str1=num2str(exp(min(x(:,1))),'%2.1f ');
str3=num2str(exp(max(x(:,1))),'%2.1f ');
annotation(...
    'textbox',...
    'Position',[loc1-[0.025 0] 0.05 0],...
    'LineStyle','none',...
    'FitHeightToText','off',...
    'FontSize',28,...
    'Interpreter','latex',...
    'String',['$\ln(' str1 ')$'],...
    'HorizontalAlignment','center');

annotation(...
    'textbox',...
    'Position',[loc2-[0.025 0] 0.05 0],...
    'LineStyle','none',...
    'FitHeightToText','off',...
    'FontSize',28,...
    'Interpreter','latex',...
    'String','$\ln(1)$',...
    'HorizontalAlignment','center');

annotation(...
    'textbox',...
    'Position',[loc3-[0.025 0] 0.05 0],...
    'LineStyle','none',...
    'FitHeightToText','off',...
    'FontSize',28,...
    'Interpreter','latex',...
    'String',['$\ln(' str3 ')$'],...
    'HorizontalAlignment','center');


% Label the tick marks on the y-axis.
loc1=funits([lowx min(y(:,3))]);
str1=num2str(exp(min(y(:,3))/100),' %3.0f');

annotation(...
    'textbox',...
    'Position',[loc1-[0.08 0] 0.05 0],...
    'LineStyle','none',...
    'FitHeightToText','off',...
    'FontSize',28,...
    'Interpreter','latex',...
    'String',['$\ln(' str1 ')$'],...
    'HorizontalAlignment','center',...
    'VerticalAlignment','middle');

loc2=funits([lowx median(y(:,3))]);
str2=num2str(exp(median(y(:,3))/100),' %3.0f');
annotation(...
    'textbox',...
    'Position',[loc2-[0.08 0] 0.05 0],...
    'LineStyle','none',...
    'FitHeightToText','off',...
    'FontSize',28,...
    'Interpreter','latex',...
    'String',['$\ln(' str2 ')$'],...
    'HorizontalAlignment','center',...
    'VerticalAlignment','middle');


loc3=funits([lowx max(y(:,3))]);
str3=num2str(exp(max(y(:,3))/100),' %3.0f');
annotation(...
    'textbox',...
    'Position',[loc3-[0.08 0] 0.05 0],...
    'LineStyle','none',...
    'FitHeightToText','off',...
    'FontSize',28,...
    'Interpreter','latex',...
    'String',['$\ln(' str3 ')$'],...
    'HorizontalAlignment','center',...
    'VerticalAlignment','middle');


% label the outliers

%Lowest y
[my,i]=min(y(:,3));
namestr=regexprep(name{i},' MSA$','');

loc1=funits([x(i,1) my+1]);
loc2=funits([x(i,1)+0.40 my+12]);
annotation(...
  'textarrow',...
  [loc2(1) loc1(1)],[loc2(2) loc1(2)],...
  'String',namestr,...
  'FontSize',28,...
  'Interpreter','latex',...
  'HorizontalAlignment','center');


%Highest y
[my,i]=max(y(:,3));
namestr=regexprep(name{i},' MSA$','');

loc1=funits([x(i,1)-0.1 my]);
loc2=funits([x(i,1)-0.5 my-0.25]);
annotation(...
  'textarrow',...
  [loc2(1) loc1(1)],[loc2(2) loc1(2)],...
  'String',namestr,...
  'FontSize',28,...
  'Interpreter','latex',...
  'HorizontalAlignment','center');


%Lowest x.
[mx,i]=min(x(:,1));
namestr=regexprep(name{i},' MSA$','');

loc1=funits([mx y(i,3)+1]);
loc2=funits([mx+0.35 y(i,3)+100]);
annotation(...
  'textarrow',...
  [loc2(1) loc1(1)],[loc2(2) loc1(2)],...
  'String',namestr,...
  'FontSize',28,...
  'Interpreter','latex',...
  'HorizontalAlignment','center');

%Highest x.

[mx,i]=max(x(:,1));
namestr=regexprep(name{i},' MSA$','');

loc1=funits([mx y(i,3)+1]);
loc2=funits([mx-0.1 y(i,3)+20]);
annotation(...
  'textarrow',...
  [loc2(1) loc1(1)],[loc2(2) loc1(2)],...
  'String',namestr,...
  'FontSize',28,...
  'Interpreter','latex',...
  'HorizontalAlignment','center');


%-------------------------------------
% Export to .pdf file file
%-------------------------------------


print -dpdf -painters figure3.pdf
close all
%% Plot seats per establishment against population.

figure('Visible','off');
set(gcf,'color',[1 1 1]);
set(gcf,'Position',[-3 5 1280 950],...
    'PaperUnits','in','PaperSize',[17 11],'PaperPositionMode','manual','PaperPosition',[0 0 17 11]); %Set figure to screen size.

plot(x(:,1),y(:,4),'.k','MarkerSize',18);
box('off');
set(gca,'FontSize',28);
lowx=min(x(:,1))-0.1;
hix=max(x(:,1))+0.1;
xlim([lowx hix]);
lowy=min(y(:,4))-1;
hiy=max(y(:,4))+1;
ylim([lowy hiy]);
xlabel('$\ln POP/\overline{POP}$','Interpreter','latex');

%Place tick-marks on the x-axis.
set(gca,'XTick',[min(x(:,1)) 0 max(x(:,1))])
xtickstr=' | | ';
set(gca,'XTickLabel',xtickstr);

%Place tick marks on the y-axis.
set(gca,'YTick',[min(y(:,4)) median(y(:,4)) max(y(:,4))]);
ytickstr=' | | ';
set(gca,'YTickLabel',ytickstr);

%Find the lower-left corner of the current axis. 
temp=get(gca,'position');
% Use this to create an in-line function that converts plot units to figure units.
funits = @(x) [temp(1)+temp(3)*(x(1)-lowx)/(hix-lowx) temp(2)+temp(4)*(x(2)-lowy)/(hiy-lowy)];

% Label the tick marks on the x-axis.
loc1=funits([min(x(:,1)) lowy]);
loc2=funits([0 lowy]);
loc3=funits([max(x(:,1)) lowy]);
str1=num2str(exp(min(x(:,1))),'%2.1f ');
str3=num2str(exp(max(x(:,1))),'%2.1f ');
annotation(...
    'textbox',...
    'Position',[loc1-[0.025 0] 0.05 0],...
    'LineStyle','none',...
    'FitHeightToText','off',...
    'FontSize',28,...
    'Interpreter','latex',...
    'String',['$\ln(' str1 ')$'],...
    'HorizontalAlignment','center');

annotation(...
    'textbox',...
    'Position',[loc2-[0.025 0] 0.05 0],...
    'LineStyle','none',...
    'FitHeightToText','off',...
    'FontSize',28,...
    'Interpreter','latex',...
    'String','$\ln(1)$',...
    'HorizontalAlignment','center');

annotation(...
    'textbox',...
    'Position',[loc3-[0.025 0] 0.05 0],...
    'LineStyle','none',...
    'FitHeightToText','off',...
    'FontSize',28,...
    'Interpreter','latex',...
    'String',['$\ln(' str3 ')$'],...
    'HorizontalAlignment','center');


% Label the tick marks on the y-axis.
loc1=funits([lowx min(y(:,4))]);
str1=num2str(exp(min(y(:,4))/100),' %3.0f');

annotation(...
    'textbox',...
    'Position',[loc1-[0.08 0] 0.05 0],...
    'LineStyle','none',...
    'FitHeightToText','off',...
    'FontSize',28,...
    'Interpreter','latex',...
    'String',['$\ln(' str1 ')$'],...
    'HorizontalAlignment','center',...
    'VerticalAlignment','middle');

loc2=funits([lowx median(y(:,4))]);
str2=num2str(exp(median(y(:,4))/100),' %3.0f');
annotation(...
    'textbox',...
    'Position',[loc2-[0.08 0] 0.05 0],...
    'LineStyle','none',...
    'FitHeightToText','off',...
    'FontSize',28,...
    'Interpreter','latex',...
    'String',['$\ln(' str2 ')$'],...
    'HorizontalAlignment','center',...
    'VerticalAlignment','middle');


loc3=funits([lowx max(y(:,4))]);
str3=num2str(exp(max(y(:,4))/100),' %3.0f');
annotation(...
    'textbox',...
    'Position',[loc3-[0.08 0] 0.05 0],...
    'LineStyle','none',...
    'FitHeightToText','off',...
    'FontSize',28,...
    'Interpreter','latex',...
    'String',['$\ln(' str3 ')$'],...
    'HorizontalAlignment','center',...
    'VerticalAlignment','middle');


% label the outliers

%Lowest y
[my,i]=min(y(:,4));
namestr=regexprep(name{i},' MSA$','');

loc1=funits([x(i,1) my+0.5]);
loc2=funits([x(i,1)+0.4 my+20]);
annotation(...
  'textarrow',...
  [loc2(1) loc1(1)],[loc2(2) loc1(2)],...
  'String',namestr,...
  'FontSize',28,...
  'Interpreter','latex',...
  'HorizontalAlignment','center');


%Highest y
[my,i]=max(y(:,4));
namestr=regexprep(name{i},' MSA$','');

loc1=funits([x(i,1)+0.1 my]);
loc2=funits([x(i,1)+0.5 my-0.25]);
annotation(...
  'textarrow',...
  [loc2(1) loc1(1)],[loc2(2) loc1(2)],...
  'String',namestr,...
  'FontSize',28,...
  'Interpreter','latex',...
  'HorizontalAlignment','center');


%Lowest x.
[mx,i]=min(x(:,1));
namestr=regexprep(name{i},' MSA$','');

loc1=funits([mx y(i,4)-1]);
loc2=funits([mx+0.35 y(i,4)-30]);
annotation(...
  'textarrow',...
  [loc2(1) loc1(1)],[loc2(2) loc1(2)],...
  'String',namestr,...
  'FontSize',28,...
  'Interpreter','latex',...
  'HorizontalAlignment','center');

%Highest x.

[mx,i]=max(x(:,1));
namestr=regexprep(name{i},' MSA$','');

loc1=funits([mx y(i,4)+1.5]);
loc2=funits([mx-0.10 y(i,4)+25]);
annotation(...
  'textarrow',...
  [loc2(1) loc1(1)],[loc2(2) loc1(2)],...
  'String',namestr,...
  'FontSize',28,...
  'Interpreter','latex',...
  'HorizontalAlignment','center');


%-------------------------------------
% Export to .pdf file file
%-------------------------------------


print -dpdf -painters figure4.pdf
close all
%% Wrap up
quit
