*veh92.do

*This file aggregates county-level data from the 1994 CCDB on Vehicles per Household to the MSA level.
*Vehicles per Household, 1990, Item 117, file 12
*Households, 1990, Item 035, file 4

version 10

*Clear and set memory
clear
set mem 4m

*Load file 4
use ../../../CCDB_94_STATA/COF04

*Keep only observations from MSA counties.
keep if sumlev=="3"

*Drop variables that won't be used.
drop flag036-item046

*Join with file 12
joinby state county using ../../../CCDB_94_STATA/COF12

*Drop variables that won't be used.
drop flag113-item116 flag118-item127

*For each MSA, construct the total number of households
egen hh90 = sum(item035), by(metro)

*Construct vehicles per household for the MSA as the household weighted average of item117.
egen veh = sum(item035*item117/hh90), by(metro)

*Drop variables that will not be used.
drop item035 flag035 item117 flag117 hh90 state county sumlev pmsa areaname

*Keep a single observation of housing unit sum.
sort metro
quietly by metro: gen dup=cond(_N==1,0,_n)
drop if dup>1
drop dup

*Add a variable giving the data's reference year.
gen str2 yr = "92"
label var yr "Reference Year"

*Rename metro as "msa"
rename metro msa
label var msa "MSA Code"
notes msa: In original data file, the MSA code is called metro

*Label the data and variables.

label data "Vehicle Availability for MSA's, 1990"
label var veh "Vehicles per Household, 1990"
notes veh: Source, Vehicles per Houshold, 1990 (Item 117) divided by Households, 1990 (Item 035), both from the 1994 CCDB

*Sort by MSA.
sort msa

*Save the data.
save veh92, replace
