*students92.do

/* This program constructs the number of college enrolees in 1990 by MSA.
The original data source is the 1994 County and City Data Book. 
*/

version 10

*Clear and set memory.
clear
set mem 4m

*Load the data
use ../../../CCDB_94_STATA/COF07

*Drop variables that will not be used.
drop flag064-item066
drop flag068-item071
drop state county areaname pmsa

*Drop observations that are not part of MSA counties outside of New England.
*This also drops PMSA counties.
keep if sumlev=="3"
drop sumlev

*Sum students across msa counties
egen students=sum(item067), by(metro)


*Drop variables that are not part of the final data set.
drop flag067 item067

*Keep a single observation of housing unit sum.
sort metro
quietly by metro: gen dup=cond(_N==1,0,_n)
drop if dup>1
drop dup

*Add a variable giving the data's reference year.
gen str2 yr = "92"
label var yr "Reference Year"

*Rename metro as "msa"
rename metro msa
label var msa "MSA Code"
notes msa: In original data file, the MSA code is called metro

label var students "College Students, 1990"
notes students: Source, 1990 Decennial Census of Population and Housing.
notes students: Item 067 in file 7, 1994 CCDB.


label data "College Students, 1990"

*Sort the data by MSA.
sort msa

*Save the data
save students92, replace
