*ssrent92.do

*Measures shopping center rent with the MSA-specific median value.

version 10

*Load the data
use shopClean

*Replace missing values in low, high, and average with zeros.
mvencode low high average, mv(0)

*For each observation, generate a variable that equals either the reported average rent of the midpoint of the reported range.
gen rent = average + 0.5*low + 0.5*high

*Throw-away extreme values of average, the top and bottom 5%.

sort rent

*Eliminate outlying observations.
gen keepdum = cond((_n<=0.05*_N) | (_n>=0.95*_N),0,1)
keep if keepdum==1
drop keepdum

*Sort the data by MSA.
sort msa

*For each MSA, generate median rent.
egen ssrent = median(rent), by(msa)

*Drop the original variables and eliminate duplicate observations.
drop page zip_code low high average gla rent

sort msa
quietly by msa: gen dup = cond(_N==1,0,_n)
drop if dup>1
drop dup

*Add a variable giving the data's reference year.
gen str2 yr = "92"
label var yr "Reference Year"

*Rename the msa code rmsa, because it is a real number"
rename msa rmsa

label var rmsa "MSA Code (Real Number)"
label var ssrent "Median Commercial Lease Rate"
label data "Shopping Center Rent Data for MSA's, 1992"

notes: Shopping Center Rent Data
notes: Source NRB Shopping Center Directory, 1993.
notes: Data on average lease rates (per square foot) for strip malls.
notes: Original data entered by Eric Heilman, contained in shop.xls.
notes: Slightly revised and corrected data contained in shop2.xls.
notes: Medians created by Jeff Campbell, September 2000.

*Sort the data by MSA.
sort rmsa

save ssrent92, replace


