*rwage92.do


/* Creates the data file rwage92.dta using data on first-quarter payroll and mid-March employment from the 1992 Census of Retail Trade. The average retail wage is measured as first-quarter payroll divided by mid-March employment. */

version 10

*Clear and increase memory to hold the data.
clear
set mem 32m

*First, change the working directory and load in the data.

use ../../../EC_92_STATA/RC92A1

*First, keep only those observations which correspond to MSA areas.
keep if geotype=="6"

*Get rid of areas in New England.
drop if msa=="0000"
drop if pmsa=="0000"

*Get rid of statewide totals for non-MSA areas.
drop if msa=="9999"

*Drop those variables that we will not be using. These are mostly geographic descriptors.
drop geotype st county place conscity part tradekey

*Code the zeros in emp and value as missing values, which they are.
mvdecode emp value, mv(0)

*Keep only those observations that correspond to "All Retail Trade"
keep if sickey=="0001"

*Construct the average retail wage.
gen rwage = pay1q/emp

*Drop variables that will not be used.
drop sickey pmsa estab estabf value valuef emp empf pay payf pay1q pay1qf

*Label the data
label data "Average Retail Wage, 1992"
label var rwage "Average Retail Wage ($1,000), 1992"

*Annotate the data
notes drop _all
notes: Constructed from the 1992 Census of Retail Trade.
notes: Created by rwage92.do.
notes rwage: Defined as pay1q/emp.

*Sort the data by MSA.
sort msa

save rwage92, replace
