*rhs92.do

*This file joins the data sets containing the various data sets with MSA characteristics that reside in this directory.
*This file relies on the feature of the joinby command that observations that are not in either data set are dropped.

version 10

*Clear and set memory.
clear
set mem 4m

*Load the first data set, the MSA Names.
use msalst

*Join with subsequent data sets.

*Population
joinby msa using pop92

*Employment
joinby msa using n92

*Married-Couple Family Households
joinby msa using mchh92

*Housing Units
joinby msa using hu92

*Shopping Center Rent
*Use merge command because this variable is missing for some MSA's.
sort rmsa
merge rmsa using ssrent92
tabulate _merge
drop _merge

*Median Housing-Unit Rent
joinby msa using hr92

*Median Housing-Unit Value
joinby msa using hv92

*Average Retail Wage (CRT Based Measure)
joinby msa using rwage92

*Newspaper Advertising Rate
joinby rmsa using nprate92

*Per capita Personal Income
joinby msa using pinc92

*College attainment rate
joinby msa using pctcol92

*Black population percentage
joinby msa using pctblk92

*Population density
joinby msa using pdense92

*Vehicles per Household
joinby msa using veh92

*Population growth rate
joinby msa using popgr92

*Hotel Revenues
joinby msa using hotel92

*College Students
joinby msa using students92

*Female Labor Force Participation Rate
joinby msa using female92

*Family Poverty Rate
joinby msa using poverty92

*Percentage Elderly
joinby msa using elderly92

*Percentage High-Income
joinby msa using highinc92

*Drop notes associated with the data set as a whole.
notes drop _dta

*Label the data.
label data "MSA Characteristics, 1992"

*Sort the data by MSA.
sort msa

*Save the data.
save rhs92, replace

