*female92.do

/* This program measures the family poverty rate by MSA in 1990.
The original data source is the 1994 County and City Data Book. This source reports the number of families with income below the poverty level and the total number of families by county.
*/

version 10

*Clear and set memory.
clear
set mem 4m

*Load the data
use ../../../CCDB_94_STATA/COF09

*Drop observations that are not part of MSA counties outside of New England.
*This also drops PMSA counties.
keep if sumlev=="3"
drop sumlev

*Sum total families and poverty families across MSA counties.
egen povertyfamilies=sum(item082), by(metro)
egen families=sum(item083x), by(metro)
gen poverty=100*povertyfamilies/families

*Keep one observation for each msa
bysort metro: gen dup=_n>1
drop if dup==1

*Create the final data set.
keep metro poverty

*Add a variable giving the data's reference year.
gen str2 yr = "92"
label var yr "Reference Year"

*Rename metro as "msa"
rename metro msa
label var msa "MSA Code"
notes msa: In original data file, the MSA code is called metro

label var poverty "Family Poverty Rate Rate"
notes poverty: Source, 1990 Decennial Census of Population and Housing.
notes poverty: Items 083x (Families, 1990) and 082 (Families with income below poverty level, 1989) in file 9, 1994 CCDB.

label data "Family Poverty Rate for MSA's, 1990"

*Sort the data by MSA.
sort msa

*Save the data
save poverty92, replace
