*popgr92.do


*This file creates each MSA's population growth rate between 1980 and 1992.
*The original data source is the county-level population data in cof01.dbf of the 1994 CCDB compact disk.

version 10

*Clear and set memory.
clear
set mem 4m

*Load the data
use ../../../CCDB_94_STATA/COF01

*Drop observations from counties that are not in MSA's.
keep if sumlev=="3"

*For each MSA, create total population in 1992 and 1980.
egen pop92 = sum(item002), by(metro)
egen pop80 = sum(item006), by(metro)

*Construct population growth rate.
gen popgr = 2*(pop92-pop80)/(pop92+pop80)

*Drop variables that will not be used.
drop flag001-item008 pop92 pop80 state county sumlev pmsa areaname

*Keep a single observation of housing unit sum.
sort metro
quietly by metro: gen dup=cond(_N==1,0,_n)
drop if dup>1
drop dup

*Add a variable giving the data's reference year.
gen str2 yr = "92"
label var yr "Reference Year"

*Rename metro as "msa"
rename metro msa
label var msa "MSA Code"
notes msa: In original data file, the MSA code is called metro

*Label the data and variables.

label data "Population Growth Rate for MSA's, 1980-1992"
label var popgr "Population Growth Rate (Davis-Haltiwanger definition), 1980-1992"
notes popgr: Source: 1992 Population: Item 002 in 1994 CCDB.
notes popgr: Source: 1980 Population: Item 006 in 1994 CCDB.

*Sort by MSA.
sort msa

*Save the data.
save popgr92, replace
