*pop92.do


*Uses the data file cof01.dta to form MSA population, pop.

version 10

*Clear and set memory
clear
set mem 4m

*Load the data
use ../../../CCDB_94_STATA/COF01.dta

*Keep only those observations from MSA counties.
keep if sumlev=="3"

*Drop variables that will not be used later.
drop sumlev pmsa areaname flag001-item001 flag003-item008

*Sort the data by state and county.
sort state county

*For each MSA, calculate total population
egen pop = sum(item002), by(metro)

*Drop variables that will not be used.
drop state county item002 flag002 

*Eliminate duplicate observations for each MSA.
sort metro
quietly by metro: gen dup=cond(_N==1,0,_n)
drop if dup>1
drop dup

*Add a variable giving the data's reference year.
gen str2 yr = "92"
label var yr "Reference Year"

*Rename metro as "msa"
rename metro msa
label var msa "MSA Code"
notes msa: In original data file, the MSA code is called metro

label var pop "Population, 1992"
notes pop: Source: Population from Item 002 in file 1, CCDB.

label data "MSA Population, 1992"

*Sort the data by msa.
sort msa

*Save the data
save pop92, replace





